/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MicroservicesConfigUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsMetaConfigKey;
import com.intellij.quarkus.config.yaml.QsYamlKeyMetaConfigKeyReference;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.quarkus"})
public final class QsYamlInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                if (!(file instanceof YAMLFile)) {
                    return null;
                }
                Project project = ((YAMLFile)file).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(project)) break block5;
                PsiFile psiFile = ((YAMLFile)file).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file.containingFile");
                if (QsConfigUtils.INSTANCE.isConfigFile(psiFile)) break block6;
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        List yamlDocuments = ((YAMLFile)file).getDocuments();
        for (YAMLDocument document : yamlDocuments) {
            document.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(holder){
                final /* synthetic */ ProblemsHolder $holder;

                public void visitElement(@NotNull PsiElement element) {
                    YAMLSequenceItem yAMLSequenceItem;
                    PsiElement keyElement;
                    block15: {
                        YAMLSequenceItem item;
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        super.visitElement(element);
                        if (!(element instanceof YAMLKeyValue)) {
                            return;
                        }
                        PsiElement psiElement = ((YAMLKeyValue)element).getKey();
                        if (psiElement == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.key ?: return");
                        keyElement = psiElement;
                        YAMLValue valueElement = ((YAMLKeyValue)element).getValue();
                        if (valueElement != null && !(valueElement instanceof YAMLScalar) && !(valueElement instanceof YAMLSequence)) {
                            return;
                        }
                        if (valueElement != null) {
                            if (valueElement instanceof YAMLScalar) {
                                MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)valueElement), (ProblemsHolder)this.$holder);
                            } else {
                                YAMLSequence sequence = (YAMLSequence)valueElement;
                                Iterator<E> iterator = sequence.getItems().iterator();
                                while (iterator.hasNext()) {
                                    YAMLScalar itemValue;
                                    YAMLSequenceItem yAMLSequenceItem2 = item = (YAMLSequenceItem)iterator.next();
                                    Intrinsics.checkNotNullExpressionValue((Object)yAMLSequenceItem2, (String)"item");
                                    YAMLValue yAMLValue = yAMLSequenceItem2.getValue();
                                    if (!(yAMLValue instanceof YAMLScalar)) {
                                        yAMLValue = null;
                                    }
                                    if ((YAMLScalar)yAMLValue == null) {
                                        continue;
                                    }
                                    MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)itemValue), (ProblemsHolder)this.$holder);
                                }
                            }
                        }
                        if (PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{YAMLSequenceItem.class}) != null) {
                            return;
                        }
                        YAMLSequenceItem yAMLSequenceItem3 = ((YAMLKeyValue)element).getReferences();
                        Intrinsics.checkNotNullExpressionValue((Object)yAMLSequenceItem3, (String)"element.references");
                        item = yAMLSequenceItem3;
                        boolean bl = false;
                        YAMLSequenceItem yAMLSequenceItem4 = item;
                        boolean bl2 = false;
                        YAMLSequenceItem yAMLSequenceItem5 = yAMLSequenceItem4;
                        int n = ((YAMLSequenceItem)yAMLSequenceItem5).length;
                        for (int i = 0; i < n; ++i) {
                            YAMLSequenceItem yAMLSequenceItem6;
                            YAMLSequenceItem it = yAMLSequenceItem6 = yAMLSequenceItem5[i];
                            boolean bl3 = false;
                            if (!(it instanceof QsYamlKeyMetaConfigKeyReference)) continue;
                            yAMLSequenceItem = yAMLSequenceItem6;
                            break block15;
                        }
                        yAMLSequenceItem = null;
                    }
                    QsYamlKeyMetaConfigKeyReference keyReference = (QsYamlKeyMetaConfigKeyReference)yAMLSequenceItem;
                    if (keyReference == null) {
                        return;
                    }
                    QsMetaConfigKey configKey = keyReference.getKeyData().getKey();
                    if (configKey == null) {
                        if (keyReference.getKeyData().getParentKey() != null) {
                            this.$holder.registerProblem(keyElement, QuarkusBundle.message("quarkus.config.unresolved.sub.key", keyReference.getKeyData().getKeyText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                        }
                        return;
                    }
                    if (Intrinsics.areEqual((Object)configKey.getDeprecation(), (Object)MetaConfigKey.Deprecation.NOT_DEPRECATED) ^ true) {
                        this.$holder.registerProblem(keyElement, QuarkusBundle.message("quarkus.config.deprecated.key", configKey.getName()), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                    }
                }
                {
                    this.$holder = $captured_local_variable$0;
                }
            });
        }
        return holder.getResultsArray();
    }
}

