/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.microservices.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsConfigValueSearcher;
import com.intellij.quarkus.config.profiles.QsProfileTarget;
import com.intellij.quarkus.config.yaml.QsConfigYamlAccessor;
import com.intellij.quarkus.config.yaml.QsYamlUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlConfigFileContributor;", "Lcom/intellij/quarkus/config/QsConfigFileContributor;", "()V", "findKeys", "", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "getKeyVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getProfiles", "Lcom/intellij/quarkus/config/profiles/QsProfileTarget;", "processConfigValues", "", "params", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "intellij.quarkus"})
public final class QsYamlConfigFileContributor
extends QsConfigFileContributor {
    @Override
    @NotNull
    public List<PsiElement> findKeys(@NotNull PsiFile psiFile, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(psiFile instanceof YAMLFile)) {
            return CollectionsKt.emptyList();
        }
        List result = (List)new SmartList();
        Iterator iterator = ((YAMLFile)psiFile).getDocuments().iterator();
        while (iterator.hasNext()) {
            YAMLDocument document;
            YAMLDocument yAMLDocument = document = (YAMLDocument)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLDocument, (String)"document");
            UtilKt.addIfNotNull((List)result, (Object)new QsConfigYamlAccessor(yAMLDocument, null, 2, null).findExistingKey(key));
            YAMLValue topLevelValue = document.getTopLevelValue();
            if (!(topLevelValue instanceof YAMLMapping)) continue;
            Iterator iterator2 = ((YAMLMapping)topLevelValue).getKeyValues().iterator();
            while (iterator2.hasNext()) {
                YAMLKeyValue keyValue;
                YAMLKeyValue yAMLKeyValue = keyValue = (YAMLKeyValue)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"keyValue");
                String string = yAMLKeyValue.getKeyText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"keyValue.keyText");
                if (!StringsKt.startsWith$default((CharSequence)string, (char)'%', (boolean)false, (int)2, null)) continue;
                UtilKt.addIfNotNull((List)result, (Object)new QsConfigYamlAccessor(keyValue, null, 2, null).findExistingKey(key));
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Collection<LookupElement> getKeyVariants(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof YAMLFile)) {
            return CollectionsKt.emptyList();
        }
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        Iterator iterator = ((YAMLFile)psiFile).getDocuments().iterator();
        while (iterator.hasNext()) {
            YAMLDocument document;
            YAMLDocument yAMLDocument = document = (YAMLDocument)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLDocument, (String)"document");
            QsConfigYamlAccessor accessor = new QsConfigYamlAccessor(yAMLDocument, null, 2, null);
            for (YAMLKeyValue yamlKeyValue : accessor.getAllKeys()) {
                YAMLValue yamlValue = yamlKeyValue.getValue();
                if (!(yamlValue instanceof YAMLScalar) && !(yamlValue instanceof YAMLSequence)) continue;
                String qualifiedKey = QsConfigUtils.INSTANCE.trimProfile(QsYamlUtils.INSTANCE.getQualifiedConfigKeyName(yamlKeyValue));
                result.add(LookupElementBuilder.create((Object)yamlKeyValue, (String)qualifiedKey).withRenderer(ConfigYamlUtils.getYamlPlaceholderLookupRenderer()));
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Collection<QsProfileTarget> getProfiles(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof YAMLFile)) {
            return CollectionsKt.emptyList();
        }
        Set result = new HashSet();
        Iterator iterator = ((YAMLFile)psiFile).getDocuments().iterator();
        while (iterator.hasNext()) {
            YAMLDocument document;
            YAMLDocument yAMLDocument = document = (YAMLDocument)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLDocument, (String)"document");
            result.addAll(QsYamlUtils.INSTANCE.getProfiles(yAMLDocument));
        }
        return result;
    }

    @Override
    public boolean processConfigValues(@NotNull QsConfigValueSearcher.QsConfigValueSearchParams params, @NotNull Processor<? super QsConfigValueSearcher.QsConfigValueResult> processor2) {
        PsiReference profileReference;
        YAMLKeyValue keyValue;
        Iterator iterator;
        YAMLMapping searchElement;
        YAMLDocument document;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        YAMLFile yAMLFile = (YAMLFile)ObjectUtils.tryCast((Object)params.getConfigFile(), YAMLFile.class);
        if (yAMLFile == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFile, (String)"ObjectUtils.tryCast(para\u2026lass.java) ?: return true");
        YAMLFile yamlFile = yAMLFile;
        String string = params.getConfigKey().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.configKey.name");
        String keyName = string;
        Processor keyValueProcessor2 = new Processor(keyName, processor2, params){
            final /* synthetic */ String $keyName;
            final /* synthetic */ Processor $processor;
            final /* synthetic */ QsConfigValueSearcher.QsConfigValueSearchParams $params;

            public final boolean process(@NotNull YAMLKeyValue yamlKeyValue) {
                Intrinsics.checkNotNullParameter((Object)yamlKeyValue, (String)"yamlKeyValue");
                ProgressManager.checkCanceled();
                String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConfigYamlUtils.getQuali\u2026nfigKeyName(yamlKeyValue)");
                String qualifiedKeyName = QsConfigUtils.INSTANCE.trimProfile(string);
                if (Intrinsics.areEqual((Object)qualifiedKeyName, (Object)this.$keyName)) {
                    PsiElement psiElement = yamlKeyValue.getKey();
                    if (psiElement == null) {
                        return true;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"yamlKeyValue.key ?: return@Processor true");
                    PsiElement keyElement = psiElement;
                    YAMLValue valueElement = yamlKeyValue.getValue();
                    if (valueElement instanceof YAMLSequence || valueElement instanceof YAMLMapping) {
                        return true;
                    }
                    return this.$processor.process((Object)new QsConfigValueSearcher.QsConfigValueResult(keyElement, (PsiElement)valueElement, yamlKeyValue.getValueText(), this.$params));
                }
                return true;
            }
            {
                this.$keyName = string;
                this.$processor = processor2;
                this.$params = qsConfigValueSearchParams;
            }
        };
        List list = yamlFile.getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"yamlFile.documents");
        Iterator iterator2 = CollectionsKt.asReversedMutable((List)list).iterator();
        while (iterator2.hasNext()) {
            YAMLDocument yAMLDocument = document = (YAMLDocument)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLDocument, (String)"document");
            YAMLValue yAMLValue = yAMLDocument.getTopLevelValue();
            if (!(yAMLValue instanceof YAMLMapping)) {
                yAMLValue = null;
            }
            if ((YAMLMapping)yAMLValue == null) {
                continue;
            }
            iterator = searchElement.getKeyValues().iterator();
            while (iterator.hasNext()) {
                String profile;
                YAMLKeyValue yAMLKeyValue = keyValue = (YAMLKeyValue)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"keyValue");
                if (QsConfigUtils.INSTANCE.createProfileReference((PsiElement)yAMLKeyValue) == null) {
                    continue;
                }
                TextRange textRange = profileReference.getRangeInElement();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"profileReference.rangeInElement");
                if (textRange.isEmpty()) continue;
                TextRange textRange2 = profileReference.getRangeInElement();
                PsiElement psiElement = profileReference.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"profileReference.element");
                Intrinsics.checkNotNullExpressionValue((Object)textRange2.substring(psiElement.getText()), (String)"profileReference.rangeIn\u2026leReference.element.text)");
                if (!Intrinsics.areEqual((Object)profile, (Object)params.getActiveProfile()) || ConfigYamlAccessor.processAllKeysReversed((YAMLPsiElement)((YAMLPsiElement)keyValue), (Processor)keyValueProcessor2)) continue;
                return false;
            }
        }
        List list2 = yamlFile.getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"yamlFile.documents");
        iterator2 = CollectionsKt.asReversedMutable((List)list2).iterator();
        while (iterator2.hasNext()) {
            YAMLDocument yAMLDocument = document = (YAMLDocument)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLDocument, (String)"document");
            YAMLValue yAMLValue = yAMLDocument.getTopLevelValue();
            if (!(yAMLValue instanceof YAMLMapping)) {
                yAMLValue = null;
            }
            if ((YAMLMapping)yAMLValue == null) {
                continue;
            }
            iterator = searchElement.getKeyValues().iterator();
            while (iterator.hasNext()) {
                YAMLKeyValue yAMLKeyValue = keyValue = (YAMLKeyValue)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"keyValue");
                profileReference = QsConfigUtils.INSTANCE.createProfileReference((PsiElement)yAMLKeyValue);
                if (profileReference != null || ConfigYamlAccessor.processAllKeysReversed((YAMLPsiElement)((YAMLPsiElement)keyValue), (Processor)keyValueProcessor2)) continue;
                return false;
            }
        }
        return true;
    }

    public QsYamlConfigFileContributor() {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YAMLFileType.YML");
        super((FileType)yAMLFileType);
    }
}

