/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsMetaConfigKeyManager;
import com.intellij.quarkus.config.properties.QsPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertyKeyMetaConfigKeyReference;", "Lcom/intellij/microservices/config/MetaConfigKeyReference;", "Lcom/intellij/psi/PsiElement;", "element", "property", "Lcom/intellij/lang/properties/psi/Property;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/properties/psi/Property;)V", "calculateDefaultRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getProfilePrefix", "", "getReferenceDisplayText", "getVariants", "", "", "()[Ljava/lang/Object;", "intellij.quarkus"})
public final class QsPropertyKeyMetaConfigKeyReference
extends MetaConfigKeyReference<PsiElement> {
    private final Property property;

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        ConfigKeyParts parts;
        MetaConfigKey configKey;
        TextRange defaultRange = super.calculateDefaultRangeInElement();
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        String string = defaultRange.substring(psiElement.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultRange.substring(element.text)");
        String keyText = string;
        String trimmedText = QsConfigUtils.INSTANCE.trimProfile(keyText);
        if (trimmedText.length() < keyText.length()) {
            defaultRange = defaultRange.cutOut(TextRange.create((int)(keyText.length() - trimmedText.length()), (int)keyText.length()));
        }
        if ((configKey = this.getResolvedKey()) != null && !configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL}) && (parts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)trimmedText, (boolean)false)) != null) {
            TextRange textRange = TextRange.allOf((String)parts.getConfigKey());
            TextRange textRange2 = defaultRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"defaultRange");
            TextRange textRange3 = textRange.shiftRight(textRange2.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"TextRange.allOf(parts.co\u2026defaultRange.startOffset)");
            return textRange3;
        }
        TextRange textRange = defaultRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"defaultRange");
        return textRange;
    }

    @NotNull
    public String getReferenceDisplayText() {
        String string = this.property.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.text");
        return QsConfigUtils.INSTANCE.trimProfile(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        Iterable $this$mapNotNullTo$iv$iv;
        String profile = this.getProfilePrefix();
        PropertiesFile propertiesFile = this.property.getPropertiesFile();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesFile, (String)"property.propertiesFile");
        List list = propertiesFile.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"property.propertiesFile.properties");
        Object $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IProperty p1 = (IProperty)element$iv$iv;
            boolean bl2 = false;
            if (p1.getKey() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        $this$mapNotNull$iv = profile;
        $i$f$mapNotNull = false;
        if ($this$mapNotNull$iv.length() > 0) {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = properties;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                if (!StringsKt.startsWith$default((String)string, (String)profile, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                String string2;
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                int n = profile.length();
                boolean bl6 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                collection.add(string);
            }
            properties = (List)destination$iv$iv;
        }
        Set existingKeys = CollectionsKt.toSet((Iterable)properties);
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        MetaConfigKeyManager metaConfigKeyManager = this.getConfigKeyManager();
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKeyManager, (String)"configKeyManager");
        return QsPropertiesUtils.INSTANCE.getMetaConfigKeyVariants(psiElement, metaConfigKeyManager, existingKeys);
    }

    private final String getProfilePrefix() {
        TextRange defaultRange = super.calculateDefaultRangeInElement();
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        String string = defaultRange.substring(psiElement.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultRange.substring(element.text)");
        String keyText = string;
        String trimmedText = QsConfigUtils.INSTANCE.trimProfile(keyText);
        String string2 = keyText;
        int n = 0;
        int n2 = keyText.length() - trimmedText.length();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string4;
    }

    public QsPropertyKeyMetaConfigKeyReference(@NotNull PsiElement element, @NotNull Property property) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        MetaConfigKeyManager metaConfigKeyManager = QsMetaConfigKeyManager.INSTANCE;
        String string = ((IProperty)property).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(property as IProperty).name");
        super(metaConfigKeyManager, element, QsConfigUtils.INSTANCE.trimProfile(string));
        this.property = property;
    }
}

