/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertiesSpellcheckingStrategy;", "Lcom/intellij/spellchecker/tokenizer/SpellcheckingStrategy;", "()V", "getTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "element", "Lcom/intellij/psi/PsiElement;", "isMyContext", "", "intellij.quarkus"})
public final class QsPropertiesSpellcheckingStrategy
extends SpellcheckingStrategy {
    @NotNull
    public Tokenizer<?> getTokenizer(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
        Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
        return tokenizer;
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PropertyKeyImpl)) {
            return false;
        }
        Project project = ((PropertyKeyImpl)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(project)) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        return file instanceof PropertiesFile && QsConfigUtils.INSTANCE.isConfigFile(file);
    }
}

