/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.references.PropertiesCompletionContributor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsConfigValueSearcher;
import com.intellij.quarkus.config.profiles.QsProfileTarget;
import com.intellij.quarkus.config.properties.QsPropertiesUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertiesConfigFileContributor;", "Lcom/intellij/quarkus/config/QsConfigFileContributor;", "()V", "findKeys", "", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "getKeyVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getProfiles", "Lcom/intellij/quarkus/config/profiles/QsProfileTarget;", "processConfigValues", "", "params", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "Companion", "intellij.quarkus"})
public final class QsPropertiesConfigFileContributor
extends QsConfigFileContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<PsiElement> findKeys(@NotNull PsiFile psiFile, @NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof PropertiesFile)) {
            psiFile2 = null;
        }
        if ((object = (PropertiesFile)psiFile2) == null || (object = object.getProperties()) == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(psiFile as? PropertiesF\u2026ies ?: return emptyList()");
        Object properties = object;
        List result = (List)new SmartList();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            IProperty property = (IProperty)iterator.next();
            IProperty iProperty = property;
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"property");
            String string = iProperty.getUnescapedKey();
            if (string == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.unescapedKey ?: continue");
            if (!Intrinsics.areEqual((Object)key, (Object)QsConfigUtils.INSTANCE.trimProfile(string))) continue;
            PsiElement psiElement = property.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"property.psiElement");
            result.add(psiElement);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<LookupElement> getKeyVariants(@NotNull PsiFile psiFile) {
        Collection destination$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof PropertiesFile)) {
            psiFile2 = null;
        }
        if ((object = (PropertiesFile)psiFile2) != null && (object = object.getProperties()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LookupElementBuilder lookupElementBuilder;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IProperty it = (IProperty)element$iv$iv;
                boolean bl2 = false;
                IProperty iProperty = it;
                Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"it");
                String key = iProperty.getKey();
                if ((key == null ? null : LookupElementBuilder.create((Object)it, (String)QsConfigUtils.INSTANCE.trimProfile(key)).withRenderer(PropertiesCompletionContributor.LOOKUP_ELEMENT_RENDERER)) == null) continue;
                lookupElementBuilder = lookupElementBuilder;
                boolean bl3 = false;
                boolean bl4 = false;
                LookupElementBuilder it$iv$iv = lookupElementBuilder;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<QsProfileTarget> getProfiles(@NotNull PsiFile psiFile) {
        Collection destination$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof PropertiesFile)) {
            psiFile2 = null;
        }
        if ((object = (PropertiesFile)psiFile2) != null && (object = object.getProperties()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PropertyKeyImpl element;
                QsProfileTarget qsProfileTarget;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IProperty it = (IProperty)element$iv$iv;
                boolean bl2 = false;
                IProperty iProperty = it;
                Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"it");
                PsiElement psiElement = iProperty.getPsiElement();
                if (!(psiElement instanceof PropertyImpl)) {
                    psiElement = null;
                }
                PropertyImpl propertyImpl = (PropertyImpl)psiElement;
                if (propertyImpl == null) {
                    QsProfileTarget qsProfileTarget2;
                    qsProfileTarget = qsProfileTarget2 = null;
                } else if (QsPropertiesUtils.INSTANCE.getPropertyKey(propertyImpl) == null) {
                    qsProfileTarget = null;
                } else if (QsConfigUtils.INSTANCE.createProfileReference((PsiElement)element) == null) {
                    qsProfileTarget = null;
                } else {
                    PsiReference profileReference;
                    TextRange textRange = profileReference.getRangeInElement();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"profileReference.rangeInElement");
                    if (textRange.isEmpty()) {
                        qsProfileTarget = null;
                    } else {
                        PsiElement psiElement2 = profileReference.getElement();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"profileReference.element");
                        TextRange textRange2 = profileReference.getRangeInElement();
                        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"profileReference.rangeInElement");
                        qsProfileTarget = new QsProfileTarget(psiElement2, textRange2);
                    }
                }
                if (qsProfileTarget == null) continue;
                QsProfileTarget qsProfileTarget3 = qsProfileTarget;
                boolean bl3 = false;
                boolean bl4 = false;
                QsProfileTarget it$iv$iv = qsProfileTarget3;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean processConfigValues(@NotNull QsConfigValueSearcher.QsConfigValueSearchParams params, @NotNull Processor<? super QsConfigValueSearcher.QsConfigValueResult> processor2) {
        String propertyName;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        PropertiesFile propertiesFile = (PropertiesFile)ObjectUtils.tryCast((Object)params.getConfigFile(), PropertiesFile.class);
        if (propertiesFile == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)propertiesFile, (String)"ObjectUtils.tryCast(para\u2026lass.java) ?: return true");
        PropertiesFile propertiesFile2 = propertiesFile;
        List list = propertiesFile2.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"propertiesFile.properties");
        List properties = CollectionsKt.asReversedMutable((List)list);
        if (properties.isEmpty()) {
            return true;
        }
        String string = params.getConfigKey().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.configKey.name");
        String keyName = string;
        for (IProperty property : properties) {
            String profile;
            String string2;
            ProgressManager.checkCanceled();
            IProperty iProperty = property;
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"property");
            if (iProperty.getName() == null) {
                continue;
            }
            String propertyKey = QsConfigUtils.INSTANCE.trimProfile(propertyName);
            CharSequence charSequence = propertyKey;
            boolean bl = false;
            if (charSequence.length() == 0) continue;
            if (propertyKey.length() == propertyName.length()) {
                string2 = null;
            } else {
                String string3 = propertyName;
                int n = 1;
                int n2 = propertyName.length() - propertyKey.length() - 1;
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, n2);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            if (Intrinsics.areEqual(profile = string2, (Object)params.getActiveProfile()) ^ true || !Intrinsics.areEqual((Object)propertyKey, (Object)keyName) || processor2.process((Object)QsPropertiesConfigFileContributor.Companion.createResult(property, params))) continue;
            return false;
        }
        for (IProperty property : properties) {
            ProgressManager.checkCanceled();
            IProperty iProperty = property;
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"property");
            if (iProperty.getName() == null) {
                continue;
            }
            if (QsConfigUtils.INSTANCE.trimProfile(propertyName).length() != propertyName.length() || !Intrinsics.areEqual((Object)propertyName, (Object)keyName) || processor2.process((Object)QsPropertiesConfigFileContributor.Companion.createResult(property, params))) continue;
            return false;
        }
        return true;
    }

    public QsPropertiesConfigFileContributor() {
        LanguageFileType languageFileType = PropertiesFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"PropertiesFileType.INSTANCE");
        super((FileType)languageFileType);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertiesConfigFileContributor$Companion;", "", "()V", "createResult", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "property", "Lcom/intellij/lang/properties/IProperty;", "params", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "intellij.quarkus"})
    public static final class Companion {
        private final QsConfigValueSearcher.QsConfigValueResult createResult(IProperty property, QsConfigValueSearcher.QsConfigValueSearchParams params) {
            PsiElement psiElement = property.getPsiElement();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.lang.properties.psi.impl.PropertyImpl");
            }
            PropertyImpl propertyImpl = (PropertyImpl)psiElement;
            PropertyKeyImpl propertyKeyImpl = QsPropertiesUtils.INSTANCE.getPropertyKey(propertyImpl);
            Intrinsics.checkNotNull((Object)propertyKeyImpl);
            PropertyKeyImpl key = propertyKeyImpl;
            return new QsConfigValueSearcher.QsConfigValueResult((PsiElement)key, (PsiElement)QsPropertiesUtils.INSTANCE.getPropertyValue(propertyImpl), propertyImpl.getValue(), params);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

