/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.RelaxedNames;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigKeyNameBinder;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsMetaConfigKey;
import com.intellij.quarkus.config.jam.MicroprofileConfigProperty;
import com.intellij.quarkus.config.jam.QsConfigGroup;
import com.intellij.quarkus.config.jam.QsConfigItem;
import com.intellij.quarkus.config.jam.QsConfigProperties;
import com.intellij.quarkus.config.jam.QsConfigRoot;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J,\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/quarkus/config/QsMetaConfigKeyManager;", "Lcom/intellij/microservices/config/MetaConfigKeyManager;", "()V", "keyRecursionGuard", "Lcom/intellij/openapi/util/RecursionGuard;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "collectConfigPropertiesClassKeys", "", "allKeys", "", "Lcom/intellij/quarkus/config/QsMetaConfigKey;", "psiClass", "Lcom/intellij/psi/PsiClass;", "prefix", "", "namingStrategy", "Lcom/intellij/quarkus/config/jam/QsConfigProperties$NamingStrategy;", "collectConfigPropertiesKeys", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "jamService", "Lcom/intellij/jam/JamService;", "collectConfigRootKeys", "psiField", "Lcom/intellij/psi/PsiField;", "parentName", "collectKeys", "", "Lcom/intellij/microservices/config/MetaConfigKey;", "module", "Lcom/intellij/openapi/module/Module;", "inLibraries", "", "getAllMetaConfigKeys", "getConfigKeyNameBinder", "Lcom/intellij/microservices/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "getModuleScope", "getPropertyName", "name", "intellij.quarkus"})
public final class QsMetaConfigKeyManager
extends MetaConfigKeyManager {
    private static final RecursionGuard<Object> keyRecursionGuard;
    @NotNull
    public static final QsMetaConfigKeyManager INSTANCE;

    @NotNull
    public List<MetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (module == null || !QuarkusUtils.INSTANCE.hasQuarkusLibrary(module)) {
            return CollectionsKt.emptyList();
        }
        List libraryKeys2 = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, new CachedValueProvider(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final CachedValueProvider.Result<List<MetaConfigKey>> compute() {
                return CachedValueProvider.Result.create((Object)QsMetaConfigKeyManager.access$collectKeys(QsMetaConfigKeyManager.INSTANCE, this.$module, true), (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.$module.getProject())});
            }
            {
                this.$module = module;
            }
        });
        List sourceKeys2 = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, new CachedValueProvider(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final CachedValueProvider.Result<List<MetaConfigKey>> compute() {
                return CachedValueProvider.Result.create((Object)QsMetaConfigKeyManager.access$collectKeys(QsMetaConfigKeyManager.INSTANCE, this.$module, false), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)this.$module.getProject())});
            }
            {
                this.$module = module;
            }
        });
        List list = ContainerUtil.concat((List)libraryKeys2, (List)sourceKeys2);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.concat(libraryKeys, sourceKeys)");
        return list;
    }

    private final GlobalSearchScope getModuleScope(Module module, boolean inLibraries) {
        GlobalSearchScope globalSearchScope;
        GlobalSearchScope globalSearchScope2 = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"GlobalSearchScope.moduleRuntimeScope(module, true)");
        GlobalSearchScope moduleScope = globalSearchScope2;
        GlobalSearchScope globalSearchScope3 = ProjectScope.getLibrariesScope((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"ProjectScope.getLibrariesScope(module.project)");
        GlobalSearchScope librariesScope = globalSearchScope3;
        if (inLibraries) {
            GlobalSearchScope globalSearchScope4 = moduleScope.intersectWith(librariesScope);
            globalSearchScope = globalSearchScope4;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope4, (String)"moduleScope.intersectWith(librariesScope)");
        } else {
            GlobalSearchScope globalSearchScope5 = moduleScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)librariesScope));
            globalSearchScope = globalSearchScope5;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope5, (String)"moduleScope.intersectWit\u2026notScope(librariesScope))");
        }
        return globalSearchScope;
    }

    private final List<MetaConfigKey> collectKeys(Module module, boolean inLibraries) {
        JamService jamService;
        GlobalSearchScope moduleScope;
        List allKeys;
        block3: {
            block2: {
                allKeys = new ArrayList();
                moduleScope = this.getModuleScope(module, inLibraries);
                jamService = JamService.getJamService((Project)module.getProject());
                if (inLibraries) break block2;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block3;
            }
            JamService jamService2 = jamService;
            Intrinsics.checkNotNullExpressionValue((Object)jamService2, (String)"jamService");
            this.collectConfigRootKeys(allKeys, moduleScope, jamService2);
        }
        JamService jamService3 = jamService;
        Intrinsics.checkNotNullExpressionValue((Object)jamService3, (String)"jamService");
        this.collectConfigPropertiesKeys(allKeys, moduleScope, jamService3);
        return allKeys;
    }

    private final void collectConfigRootKeys(List<QsMetaConfigKey> allKeys, GlobalSearchScope scope, JamService jamService) {
        List roots = jamService.getJamClassElements((JamMemberMeta)QsConfigRoot.Companion.getCLASS_META(), "io.quarkus.runtime.annotations.ConfigRoot", scope);
        for (QsConfigRoot root : roots) {
            PsiField[] psiFieldArray = root.getPsiElement().getAllFields();
            int n = psiFieldArray.length;
            for (int i = 0; i < n; ++i) {
                PsiField field;
                PsiField psiField = field = psiFieldArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"field");
                this.collectConfigRootKeys(psiField, root.getName(), allKeys, jamService);
            }
        }
    }

    public final void collectConfigRootKeys(@NotNull PsiField psiField, @NotNull String parentName, @NotNull List<QsMetaConfigKey> allKeys, @NotNull JamService jamService) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiField, (String)"psiField");
        Intrinsics.checkNotNullParameter((Object)parentName, (String)"parentName");
        Intrinsics.checkNotNullParameter(allKeys, (String)"allKeys");
        Intrinsics.checkNotNullParameter((Object)jamService, (String)"jamService");
        if (psiField.hasModifier(JvmModifier.STATIC)) {
            return;
        }
        QsConfigItem item = (QsConfigItem)jamService.getJamElement((PsiElement)psiField, new JamMemberMeta[]{(JamMemberMeta)QsConfigItem.Companion.getFIELD_META()});
        Object object2 = item;
        if (object2 == null || (object2 = ((QsConfigItem)object2).getName()) == null) {
            String string = RelaxedNames.camelCaseToHyphen((String)psiField.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RelaxedNames.camelCaseToHyphen(psiField.name)");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            object2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        }
        Object itemName = object2;
        if (StringsKt.isBlank((CharSequence)((CharSequence)itemName))) {
            object = parentName;
        } else {
            CharSequence charSequence = parentName;
            boolean bl = false;
            object = charSequence.length() == 0 ? itemName : parentName + '.' + (String)itemName;
        }
        String fullName = object;
        PsiType psiType = psiField.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"psiField.type");
        PsiType type = QsConfigUtils.INSTANCE.unwrapOptional(psiType);
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (psiClass != null && jamService.getJamElement(QsConfigGroup.Companion.getCLASS_META().getJamKey(), (PsiElement)psiClass) != null) {
            for (PsiField groupField : psiClass.getAllFields()) {
                keyRecursionGuard.doPreventingRecursion((Object)groupField, false, new Computable(groupField, fullName, allKeys, jamService){
                    final /* synthetic */ PsiField $groupField;
                    final /* synthetic */ String $fullName;
                    final /* synthetic */ List $allKeys;
                    final /* synthetic */ JamService $jamService;

                    public final void compute() {
                        PsiField psiField = this.$groupField;
                        Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"groupField");
                        QsMetaConfigKeyManager.INSTANCE.collectConfigRootKeys(psiField, this.$fullName, this.$allKeys, this.$jamService);
                    }
                    {
                        this.$groupField = psiField;
                        this.$fullName = string;
                        this.$allKeys = list;
                        this.$jamService = jamService;
                    }
                });
            }
        } else if (item != null) {
            CharSequence groupField = fullName;
            boolean bl = false;
            if (groupField.length() > 0) {
                PsiField declaration = item.getPsiElement();
                allKeys.add(new QsMetaConfigKey((PsiModifierListOwner)declaration, fullName, item.getDefaultValue(), type));
            }
        }
    }

    private final void collectConfigPropertiesKeys(List<QsMetaConfigKey> allKeys, GlobalSearchScope scope, JamService jamService) {
        List configPropertiesList = jamService.getJamClassElements((JamMemberMeta)QsConfigProperties.Companion.getCLASS_META(), "io.quarkus.arc.config.ConfigProperties", scope);
        for (QsConfigProperties configProperties : configPropertiesList) {
            String prefix = configProperties.getPrefix();
            QsConfigProperties.NamingStrategy namingStrategy = configProperties.getNamingStrategy();
            PsiClass psiClass = configProperties.getPsiElement();
            if (psiClass.isInterface()) {
                for (PsiMethod method : psiClass.getAllMethods()) {
                    String string;
                    MicroprofileConfigProperty configProperty;
                    JvmParameter[] jvmParameterArray;
                    if (method.hasModifier(JvmModifier.STATIC) || !method.hasModifier(JvmModifier.PUBLIC)) continue;
                    PsiMethod psiMethod = method;
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"method");
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethod.getParameters(), (String)"method.parameters");
                    boolean bl = false;
                    JvmParameter[] jvmParameterArray2 = jvmParameterArray;
                    boolean bl2 = false;
                    if (!(jvmParameterArray2.length == 0)) continue;
                    PsiClass psiClass2 = method.getContainingClass();
                    if (psiClass2 == null) continue;
                    if (!psiClass2.isInterface()) {
                        continue;
                    }
                    PsiType psiType = method.getReturnType();
                    if (psiType == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"method.returnType ?: continue");
                    PsiType type = QsConfigUtils.INSTANCE.unwrapOptional(psiType);
                    MicroprofileConfigProperty microprofileConfigProperty = configProperty = (MicroprofileConfigProperty)jamService.getJamElement((PsiElement)method, new JamMemberMeta[]{(JamMemberMeta)MicroprofileConfigProperty.Companion.getMETHOD_META()});
                    String configName = microprofileConfigProperty != null ? microprofileConfigProperty.getName() : null;
                    CharSequence charSequence = configName;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        String string2 = PropertyUtilBase.getPropertyName((PsiMethod)method);
                        if (string2 == null) {
                            string2 = method.getName();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PropertyUtilBase.getProp\u2026me(method) ?: method.name");
                        string = this.getPropertyName(string2, namingStrategy);
                    } else {
                        string = configName;
                    }
                    String name = string;
                    String fullName = prefix + '.' + name;
                    MicroprofileConfigProperty microprofileConfigProperty2 = configProperty;
                    allKeys.add(new QsMetaConfigKey((PsiModifierListOwner)method, fullName, microprofileConfigProperty2 != null ? microprofileConfigProperty2.getDefaultValue() : null, type));
                }
                continue;
            }
            this.collectConfigPropertiesClassKeys(allKeys, psiClass, prefix, namingStrategy);
        }
    }

    private final void collectConfigPropertiesClassKeys(List<QsMetaConfigKey> allKeys, PsiClass psiClass, String prefix, QsConfigProperties.NamingStrategy namingStrategy) {
        for (PsiField psiField : psiClass.getFields()) {
            Object object;
            String name;
            if (psiField.hasModifier(JvmModifier.STATIC)) continue;
            PsiField psiField2 = psiField;
            Intrinsics.checkNotNullExpressionValue((Object)psiField2, (String)"psiField");
            Intrinsics.checkNotNullExpressionValue((Object)psiField2.getName(), (String)"psiField.name");
            PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)psiClass, (String)name, (boolean)false, (boolean)false);
            PsiModifierListOwner declaration = null;
            if (setter != null) {
                if (!setter.hasModifier(JvmModifier.PUBLIC)) continue;
                declaration = (PsiModifierListOwner)setter;
            } else {
                if (!psiField.hasModifier(JvmModifier.PUBLIC) || psiField.hasModifier(JvmModifier.FINAL)) continue;
                declaration = (PsiModifierListOwner)psiField;
            }
            String fullName = prefix + '.' + this.getPropertyName(name, namingStrategy);
            PsiType psiType = psiField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"psiField.type");
            PsiType type = QsConfigUtils.INSTANCE.unwrapOptional(psiType);
            PsiClass fieldClass = PsiTypesUtil.getPsiClass((PsiType)type);
            if (fieldClass != null) {
                ProjectFileIndex fileIndex;
                PsiFile psiFile = psiClass.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiClass.containingFile");
                PsiFile psiFile2 = psiFile.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"psiClass.containingFile.originalFile");
                VirtualFile parentFile = psiFile2.getVirtualFile();
                PsiFile psiFile3 = fieldClass.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"fieldClass.containingFile");
                PsiFile psiFile4 = psiFile3.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"fieldClass.containingFile.originalFile");
                VirtualFile fieldTypeFile = psiFile4.getVirtualFile();
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)psiClass.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(psiClass.project)");
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager.getFileIndex(), (String)"ProjectRootManager.getIn\u2026iClass.project).fileIndex");
                if (parentFile != null && fieldTypeFile != null && Intrinsics.areEqual((Object)fileIndex.getSourceRootForFile(parentFile), (Object)fileIndex.getSourceRootForFile(fieldTypeFile))) {
                    keyRecursionGuard.doPreventingRecursion((Object)fieldClass, false, new Computable(allKeys, fieldClass, fullName, namingStrategy){
                        final /* synthetic */ List $allKeys;
                        final /* synthetic */ PsiClass $fieldClass;
                        final /* synthetic */ String $fullName;
                        final /* synthetic */ QsConfigProperties.NamingStrategy $namingStrategy;

                        public final void compute() {
                            QsMetaConfigKeyManager.access$collectConfigPropertiesClassKeys(QsMetaConfigKeyManager.INSTANCE, this.$allKeys, this.$fieldClass, this.$fullName, this.$namingStrategy);
                        }
                        {
                            this.$allKeys = list;
                            this.$fieldClass = psiClass;
                            this.$fullName = string;
                            this.$namingStrategy = namingStrategy;
                        }
                    });
                    continue;
                }
            }
            String defaultValue = (object = (UField)UastContextKt.toUElement((PsiElement)((PsiElement)psiField), UField.class)) != null && (object = object.getUastInitializer()) != null && (object = object.evaluate()) != null ? object.toString() : null;
            allKeys.add(new QsMetaConfigKey(declaration, fullName, defaultValue, type));
        }
    }

    private final String getPropertyName(String name, QsConfigProperties.NamingStrategy namingStrategy) {
        String string;
        if (namingStrategy == QsConfigProperties.NamingStrategy.KEBAB_CASE) {
            String string2 = RelaxedNames.camelCaseToHyphen((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RelaxedNames.camelCaseToHyphen(name)");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = name;
        }
        return string;
    }

    @NotNull
    public MetaConfigKeyManager.ConfigKeyNameBinder getConfigKeyNameBinder(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return QsConfigKeyNameBinder.INSTANCE;
    }

    private QsMetaConfigKeyManager() {
    }

    static {
        QsMetaConfigKeyManager qsMetaConfigKeyManager;
        INSTANCE = qsMetaConfigKeyManager = new QsMetaConfigKeyManager();
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)"QsMetaConfigKeyRecursionGuard");
        Intrinsics.checkNotNullExpressionValue((Object)recursionGuard, (String)"RecursionManager.createG\u2026ConfigKeyRecursionGuard\")");
        keyRecursionGuard = recursionGuard;
    }

    public static final /* synthetic */ List access$collectKeys(QsMetaConfigKeyManager $this, Module module, boolean inLibraries) {
        return $this.collectKeys(module, inLibraries);
    }

    public static final /* synthetic */ void access$collectConfigPropertiesClassKeys(QsMetaConfigKeyManager $this, List allKeys, PsiClass psiClass, String prefix, QsConfigProperties.NamingStrategy namingStrategy) {
        $this.collectConfigPropertiesClassKeys(allKeys, psiClass, prefix, namingStrategy);
    }
}

