/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.QsMetaConfigKeyManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\rR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/config/QsConfigValueSearcher;", "", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "", "configKey", "", "activeProfile", "(Lcom/intellij/openapi/module/Module;ZLjava/lang/String;Ljava/lang/String;)V", "findValueText", "process", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "QsConfigValueResult", "QsConfigValueSearchParams", "intellij.quarkus"})
public final class QsConfigValueSearcher {
    private final Module module;
    private final boolean includeTests;
    private final String configKey;
    private final String activeProfile;

    @Nullable
    public final String findValueText() {
        CommonProcessors.FindFirstProcessor<QsConfigValueResult> processor2 = new CommonProcessors.FindFirstProcessor<QsConfigValueResult>(){

            protected boolean accept(@NotNull QsConfigValueResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                return result.getValueText() != null;
            }
        };
        this.process((Processor<? super QsConfigValueResult>)((Processor)processor2));
        QsConfigValueResult qsConfigValueResult = (QsConfigValueResult)processor2.getFoundValue();
        return qsConfigValueResult != null ? qsConfigValueResult.getValueText() : null;
    }

    public final boolean process(@NotNull Processor<? super QsConfigValueResult> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        MetaConfigKey metaConfigKey = QsMetaConfigKeyManager.INSTANCE.findApplicationMetaConfigKey(this.module, this.configKey);
        if (metaConfigKey == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"QsMetaConfigKeyManager.f\u2026configKey) ?: return true");
        MetaConfigKey metaConfigKey2 = metaConfigKey;
        List<Pair<VirtualFile, QsConfigFileContributor>> configs = QsConfigFileContributor.Companion.findConfigFiles(this.module, this.includeTests);
        PsiManager psiManager = PsiManager.getInstance((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(module.project)");
        PsiManager psiManager2 = psiManager;
        for (Pair<VirtualFile, QsConfigFileContributor> config : configs) {
            PsiFile configPsiFile;
            if (psiManager2.findFile((VirtualFile)config.getFirst()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)configPsiFile, (String)"psiManager.findFile(config.first) ?: continue");
            QsConfigValueSearchParams params = new QsConfigValueSearchParams(this.module, configPsiFile, this.activeProfile, metaConfigKey2);
            if (((QsConfigFileContributor)config.getSecond()).processConfigValues(params, processor2)) continue;
            return false;
        }
        return true;
    }

    public QsConfigValueSearcher(@NotNull Module module, boolean includeTests, @NotNull String configKey, @NotNull String activeProfile) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter((Object)activeProfile, (String)"activeProfile");
        this.module = module;
        this.includeTests = includeTests;
        this.configKey = configKey;
        this.activeProfile = activeProfile;
    }

    public /* synthetic */ QsConfigValueSearcher(Module module, boolean bl, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = "dev";
        }
        this(module, bl, string, string2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "", "module", "Lcom/intellij/openapi/module/Module;", "configFile", "Lcom/intellij/psi/PsiFile;", "activeProfile", "", "configKey", "Lcom/intellij/microservices/config/MetaConfigKey;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiFile;Ljava/lang/String;Lcom/intellij/microservices/config/MetaConfigKey;)V", "getActiveProfile", "()Ljava/lang/String;", "getConfigFile", "()Lcom/intellij/psi/PsiFile;", "getConfigKey", "()Lcom/intellij/microservices/config/MetaConfigKey;", "getModule", "()Lcom/intellij/openapi/module/Module;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.quarkus"})
    public static final class QsConfigValueSearchParams {
        @NotNull
        private final Module module;
        @NotNull
        private final PsiFile configFile;
        @NotNull
        private final String activeProfile;
        @NotNull
        private final MetaConfigKey configKey;

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final PsiFile getConfigFile() {
            return this.configFile;
        }

        @NotNull
        public final String getActiveProfile() {
            return this.activeProfile;
        }

        @NotNull
        public final MetaConfigKey getConfigKey() {
            return this.configKey;
        }

        public QsConfigValueSearchParams(@NotNull Module module, @NotNull PsiFile configFile, @NotNull String activeProfile, @NotNull MetaConfigKey configKey) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)activeProfile, (String)"activeProfile");
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            this.module = module;
            this.configFile = configFile;
            this.activeProfile = activeProfile;
            this.configKey = configKey;
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @NotNull
        public final PsiFile component2() {
            return this.configFile;
        }

        @NotNull
        public final String component3() {
            return this.activeProfile;
        }

        @NotNull
        public final MetaConfigKey component4() {
            return this.configKey;
        }

        @NotNull
        public final QsConfigValueSearchParams copy(@NotNull Module module, @NotNull PsiFile configFile, @NotNull String activeProfile, @NotNull MetaConfigKey configKey) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            Intrinsics.checkNotNullParameter((Object)activeProfile, (String)"activeProfile");
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            return new QsConfigValueSearchParams(module, configFile, activeProfile, configKey);
        }

        public static /* synthetic */ QsConfigValueSearchParams copy$default(QsConfigValueSearchParams qsConfigValueSearchParams, Module module, PsiFile psiFile, String string, MetaConfigKey metaConfigKey, int n, Object object) {
            if ((n & 1) != 0) {
                module = qsConfigValueSearchParams.module;
            }
            if ((n & 2) != 0) {
                psiFile = qsConfigValueSearchParams.configFile;
            }
            if ((n & 4) != 0) {
                string = qsConfigValueSearchParams.activeProfile;
            }
            if ((n & 8) != 0) {
                metaConfigKey = qsConfigValueSearchParams.configKey;
            }
            return qsConfigValueSearchParams.copy(module, psiFile, string, metaConfigKey);
        }

        @NotNull
        public String toString() {
            return "QsConfigValueSearchParams(module=" + this.module + ", configFile=" + this.configFile + ", activeProfile=" + this.activeProfile + ", configKey=" + this.configKey + ")";
        }

        public int hashCode() {
            Module module = this.module;
            PsiFile psiFile = this.configFile;
            String string = this.activeProfile;
            MetaConfigKey metaConfigKey = this.configKey;
            return (((module != null ? module.hashCode() : 0) * 31 + (psiFile != null ? psiFile.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (metaConfigKey != null ? metaConfigKey.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QsConfigValueSearchParams)) break block3;
                    QsConfigValueSearchParams qsConfigValueSearchParams = (QsConfigValueSearchParams)object;
                    if (!Intrinsics.areEqual((Object)this.module, (Object)qsConfigValueSearchParams.module) || !Intrinsics.areEqual((Object)this.configFile, (Object)qsConfigValueSearchParams.configFile) || !Intrinsics.areEqual((Object)this.activeProfile, (Object)qsConfigValueSearchParams.activeProfile) || !Intrinsics.areEqual((Object)this.configKey, (Object)qsConfigValueSearchParams.configKey)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J5\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "", "keyElement", "Lcom/intellij/psi/PsiElement;", "valueElement", "valueText", "", "params", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;)V", "getKeyElement", "()Lcom/intellij/psi/PsiElement;", "getParams", "()Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "getValueElement", "getValueText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.quarkus"})
    public static final class QsConfigValueResult {
        @NotNull
        private final PsiElement keyElement;
        @Nullable
        private final PsiElement valueElement;
        @Nullable
        private final String valueText;
        @NotNull
        private final QsConfigValueSearchParams params;

        @NotNull
        public final PsiElement getKeyElement() {
            return this.keyElement;
        }

        @Nullable
        public final PsiElement getValueElement() {
            return this.valueElement;
        }

        @Nullable
        public final String getValueText() {
            return this.valueText;
        }

        @NotNull
        public final QsConfigValueSearchParams getParams() {
            return this.params;
        }

        public QsConfigValueResult(@NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, @NotNull QsConfigValueSearchParams params) {
            Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.keyElement = keyElement;
            this.valueElement = valueElement;
            this.valueText = valueText;
            this.params = params;
        }

        @NotNull
        public final PsiElement component1() {
            return this.keyElement;
        }

        @Nullable
        public final PsiElement component2() {
            return this.valueElement;
        }

        @Nullable
        public final String component3() {
            return this.valueText;
        }

        @NotNull
        public final QsConfigValueSearchParams component4() {
            return this.params;
        }

        @NotNull
        public final QsConfigValueResult copy(@NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, @NotNull QsConfigValueSearchParams params) {
            Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return new QsConfigValueResult(keyElement, valueElement, valueText, params);
        }

        public static /* synthetic */ QsConfigValueResult copy$default(QsConfigValueResult qsConfigValueResult, PsiElement psiElement, PsiElement psiElement2, String string, QsConfigValueSearchParams qsConfigValueSearchParams, int n, Object object) {
            if ((n & 1) != 0) {
                psiElement = qsConfigValueResult.keyElement;
            }
            if ((n & 2) != 0) {
                psiElement2 = qsConfigValueResult.valueElement;
            }
            if ((n & 4) != 0) {
                string = qsConfigValueResult.valueText;
            }
            if ((n & 8) != 0) {
                qsConfigValueSearchParams = qsConfigValueResult.params;
            }
            return qsConfigValueResult.copy(psiElement, psiElement2, string, qsConfigValueSearchParams);
        }

        @NotNull
        public String toString() {
            return "QsConfigValueResult(keyElement=" + this.keyElement + ", valueElement=" + this.valueElement + ", valueText=" + this.valueText + ", params=" + this.params + ")";
        }

        public int hashCode() {
            PsiElement psiElement = this.keyElement;
            PsiElement psiElement2 = this.valueElement;
            String string = this.valueText;
            QsConfigValueSearchParams qsConfigValueSearchParams = this.params;
            return (((psiElement != null ? psiElement.hashCode() : 0) * 31 + (psiElement2 != null ? psiElement2.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (qsConfigValueSearchParams != null ? ((Object)qsConfigValueSearchParams).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QsConfigValueResult)) break block3;
                    QsConfigValueResult qsConfigValueResult = (QsConfigValueResult)object;
                    if (!Intrinsics.areEqual((Object)this.keyElement, (Object)qsConfigValueResult.keyElement) || !Intrinsics.areEqual((Object)this.valueElement, (Object)qsConfigValueResult.valueElement) || !Intrinsics.areEqual((Object)this.valueText, (Object)qsConfigValueResult.valueText) || !Intrinsics.areEqual((Object)this.params, (Object)qsConfigValueResult.params)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

