/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.microservices.config.ConfigPlaceholderReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.quarkus.QuarkusIcons;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.profiles.QsProfilePsiReference;
import com.intellij.quarkus.config.profiles.QsProfileTarget;
import com.intellij.quarkus.config.profiles.QsProfileTargetKt;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0014J*\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00180 J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/quarkus/config/QsConfigUtils;", "", "()V", "MAP_DOT_TAIL", "Lcom/intellij/codeInsight/TailType;", "createPlaceholderReferences", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "createProfileReference", "findProfileTargets", "", "Lcom/intellij/quarkus/config/profiles/QsProfileTarget;", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "", "findProfiles", "", "getConfigFileIcon", "Ljavax/swing/Icon;", "file", "Lcom/intellij/psi/PsiFile;", "getMapDotTail", "isConfigFile", "isConfigFileName", "fileName", "processConfigFiles", "", "processor", "Lcom/intellij/util/PairProcessor;", "Lcom/intellij/quarkus/config/QsConfigFileContributor;", "trimProfile", "text", "unwrapOptional", "Lcom/intellij/psi/PsiType;", "type", "intellij.quarkus"})
public final class QsConfigUtils {
    private static TailType MAP_DOT_TAIL;
    @NotNull
    public static final QsConfigUtils INSTANCE;

    public final boolean isConfigFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return QsConfigUtils.getConfigFileIcon(file) != null;
    }

    @JvmStatic
    @Nullable
    public static final Icon getConfigFileIcon(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getVirtualFile() == null) {
            return null;
        }
        Module fileModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (fileModule == null || !QuarkusUtils.INSTANCE.hasQuarkusLibrary(fileModule)) {
            return null;
        }
        return (Icon)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), (CachedValueProvider)new CachedValueProvider(file){
            final /* synthetic */ PsiFile $file;

            @Nullable
            public final CachedValueProvider.Result<Icon> compute() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.$file));
                if (module != null && !module.isDisposed()) {
                    VirtualFile virtualFile = this.$file.getVirtualFile();
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    Object[] objectArray = moduleRootManager.getSourceRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleRootManager.getInstance(module).sourceRoots");
                    Object[] sourceRoots = objectArray;
                    for (QsConfigFileContributor contributor : (QsConfigFileContributor[])QsConfigFileContributor.Companion.getEP_NAME().getExtensions()) {
                        if (!Intrinsics.areEqual((Object)contributor.getFileType(), (Object)this.$file.getFileType())) continue;
                        VirtualFile virtualFile2 = virtualFile;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile");
                        String string = virtualFile2.getNameWithoutExtension();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.nameWithoutExtension");
                        if (!QsConfigUtils.INSTANCE.isConfigFileName(string) || !ArraysKt.contains((Object[])sourceRoots, (Object)virtualFile.getParent())) continue;
                        return CachedValueProvider.Result.create((Object)QuarkusIcons.Quarkus, (Object[])new Object[]{this.$file, ProjectRootManager.getInstance((Project)this.$file.getProject())});
                    }
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{this.$file, ProjectRootManager.getInstance((Project)this.$file.getProject())});
            }
            {
                this.$file = psiFile;
            }
        });
    }

    public final boolean isConfigFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return Intrinsics.areEqual((Object)fileName, (Object)"application");
    }

    @Nullable
    public final PsiReference createProfileReference(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = ElementManipulators.getValueText((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ElementManipulators.getValueText(element)");
        String text = string;
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0 || text.charAt(0) != '%') {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026t(element) ?: return null");
        Module module2 = module;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)text, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (separatorIndex < 0) {
            separatorIndex = text.length();
        }
        int startOffset = ElementManipulators.getOffsetInElement((PsiElement)element);
        TextRange textRange = TextRange.create((int)(startOffset + 1), (int)(startOffset + separatorIndex));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.create(startOf\u2026tOffset + separatorIndex)");
        return (PsiReference)new QsProfilePsiReference(element, textRange, module2);
    }

    @NotNull
    public final Collection<String> findProfiles(@NotNull Module module, boolean includeTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        LinkedHashSet<String> names = new LinkedHashSet<String>((Collection)QsProfileTargetKt.getPREDEFINED_PROFILES());
        for (QsProfileTarget target : QsConfigUtils.findProfileTargets(module, includeTests)) {
            names.add(target.getName());
        }
        return names;
    }

    @JvmStatic
    private static final Collection<QsProfileTarget> findProfileTargets(Module module, boolean includeTests) {
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, new CachedValueProvider(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final CachedValueProvider.Result<Map<Boolean, List<QsProfileTarget>>> compute() {
                ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap((Function)new Function(this){
                    final /* synthetic */ findProfileTargets.1 this$0;

                    public final ArrayList<QsProfileTarget> fun(Boolean withTests) {
                        Set result = new HashSet<E>();
                        Module module = this.this$0.$module;
                        Boolean bl = withTests;
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"withTests");
                        QsConfigUtils.INSTANCE.processConfigFiles(module, bl, (PairProcessor<QsConfigFileContributor, PsiFile>)new PairProcessor(result){
                            final /* synthetic */ Set $result;

                            public final boolean process(@NotNull QsConfigFileContributor contributor, @NotNull PsiFile psiFile) {
                                Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
                                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                                this.$result.addAll(contributor.getProfiles(psiFile));
                                return true;
                            }
                            {
                                this.$result = set;
                            }
                        });
                        return new ArrayList<QsProfileTarget>(result);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026ArrayList(result)\n      }");
                Map map2 = concurrentMap;
                return CachedValueProvider.Result.create((Object)map2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            {
                this.$module = module;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026MODIFICATION_COUNT)\n    }");
        return (Collection)MapsKt.getValue((Map)((Map)object), (Object)includeTests);
    }

    @NotNull
    public final PsiReference[] createPlaceholderReferences(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiReference[] psiReferenceArray = ConfigPlaceholderReference.createPlaceholderReferences((PsiElement)element, (BiFunction)createPlaceholderReferences.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"ConfigPlaceholderReferen\u2026()\n        .build()\n    }");
        return psiReferenceArray;
    }

    @NotNull
    public final String trimProfile(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0 || text.charAt(0) != '%') {
            return text;
        }
        int separatorIndex = StringsKt.indexOf$default((CharSequence)text, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (separatorIndex < 0) {
            return "";
        }
        String string = text;
        int n = separatorIndex + 1;
        boolean bl2 = false;
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        return string2;
    }

    @NotNull
    public final PsiType unwrapOptional(@NotNull PsiType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof PsiClassType && ((PsiClassType)type).getParameterCount() == 1) {
            String string = ((PsiClassType)type).getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.canonicalText");
            if (StringsKt.startsWith$default((String)string, (String)"java.util.Optional<", (boolean)false, (int)2, null)) {
                PsiType psiType = ((PsiClassType)type).getParameters()[0];
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"type.parameters[0]");
                return psiType;
            }
        }
        return type;
    }

    public final void processConfigFiles(@NotNull Module module, boolean includeTests, @NotNull PairProcessor<QsConfigFileContributor, PsiFile> processor2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(module.project)");
        PsiManager psiManager2 = psiManager;
        for (QsConfigFileContributor contributor : QsConfigFileContributor.Companion.getEP_NAME().getExtensionList()) {
            for (VirtualFile virtualFile : contributor.findConfigFiles(module, includeTests)) {
                PsiFile psiFile;
                if (psiManager2.findFile(virtualFile) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiManager.findFile(virtualFile) ?: continue");
                if (processor2.process((Object)contributor, (Object)psiFile)) continue;
                return;
            }
        }
    }

    @NotNull
    public final TailType getMapDotTail() {
        TailType tail = MAP_DOT_TAIL;
        if (tail != null) {
            return tail;
        }
        MAP_DOT_TAIL = tail = (TailType)new CharTailType('.'){

            public int processTail(@NotNull Editor editor, int tailOffset) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                int offset = super.processTail(editor, tailOffset);
                Project project = editor.getProject();
                Intrinsics.checkNotNull((Object)project);
                AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
                return offset;
            }
        };
        return tail;
    }

    private QsConfigUtils() {
    }

    static {
        QsConfigUtils qsConfigUtils;
        INSTANCE = qsConfigUtils = new QsConfigUtils();
    }
}

