/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.config.RelaxedNames;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.jam.QsConfigItem;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/quarkus/config/QsConfigKeyReferenceSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "()V", "getConfigRootKeyEffectiveSearchScope", "Lcom/intellij/psi/search/SearchScope;", "parameters", "psiField", "Lcom/intellij/psi/PsiField;", "processConfigPropertiesKey", "", "processConfigRootKey", "name", "", "processQuery", "consumer", "Lcom/intellij/util/Processor;", "intellij.quarkus"})
public final class QsConfigKeyReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parameters.project");
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(project)) {
            return;
        }
        PsiElement psiElement = parameters.getElementToSearch();
        if (!(psiElement instanceof PsiField)) {
            psiElement = null;
        }
        PsiField psiField = (PsiField)psiElement;
        if (psiField == null) {
            return;
        }
        PsiField psiField2 = psiField;
        if (psiField2.hasModifier(JvmModifier.STATIC)) {
            return;
        }
        QsConfigItem item = (QsConfigItem)JamService.getJamService((Project)parameters.getProject()).getJamElement((PsiElement)psiField2, new JamMemberMeta[]{(JamMemberMeta)QsConfigItem.Companion.getFIELD_META()});
        if (item != null) {
            this.processConfigRootKey(parameters, psiField2, item.getName());
        } else {
            this.processConfigPropertiesKey(parameters, psiField2);
        }
    }

    private final void processConfigRootKey(ReferencesSearch.SearchParameters parameters, PsiField psiField, String name) {
        SearchScope searchScope = QsConfigFileContributor.Companion.getReferenceSearchScope(this.getConfigRootKeyEffectiveSearchScope(parameters, psiField));
        parameters.getOptimizer().searchWord(name, searchScope, (short)255, true, (PsiElement)psiField);
    }

    private final SearchScope getConfigRootKeyEffectiveSearchScope(ReferencesSearch.SearchParameters parameters, PsiField psiField) {
        if (parameters.isIgnoreAccessScope() || psiField.hasModifier(JvmModifier.PUBLIC)) {
            SearchScope searchScope = parameters.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"parameters.effectiveSearchScope");
            return searchScope;
        }
        PsiClass psiClass = psiField.getContainingClass();
        if (psiClass == null) {
            SearchScope searchScope = parameters.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"parameters.effectiveSearchScope");
            return searchScope;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiField.containingClass\u2026ters.effectiveSearchScope");
        PsiClass psiClass2 = psiClass;
        if (!psiClass2.isValid()) {
            SearchScope searchScope = parameters.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"parameters.effectiveSearchScope");
            return searchScope;
        }
        SearchScope searchScope = PsiSearchHelper.getInstance((Project)psiClass2.getProject()).getUseScope((PsiElement)psiClass2);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"PsiSearchHelper.getInsta\u2026ct).getUseScope(psiClass)");
        SearchScope useScope = searchScope;
        SearchScope searchScope2 = parameters.getScopeDeterminedByUser().intersectWith(useScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"parameters.scopeDetermin\u2026r.intersectWith(useScope)");
        return searchScope2;
    }

    private final void processConfigPropertiesKey(ReferencesSearch.SearchParameters parameters, PsiField psiField) {
        if (!psiField.hasModifier(JvmModifier.PUBLIC) || psiField.hasModifier(JvmModifier.FINAL)) {
            return;
        }
        PsiClass psiClass = psiField.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiField.containingClass ?: return");
        PsiClass psiClass2 = psiClass;
        if (!psiClass2.isValid()) {
            return;
        }
        String string = psiField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiField.name");
        String name = string;
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)psiClass2, (String)name, (boolean)false, (boolean)false);
        if (setter != null) {
            return;
        }
        String string2 = RelaxedNames.camelCaseToHyphen((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RelaxedNames.camelCaseToHyphen(name)");
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        String hyphenedName = string5;
        if (Intrinsics.areEqual((Object)hyphenedName, (Object)name) ^ true) {
            SearchScope searchScope = parameters.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"parameters.effectiveSearchScope");
            SearchScope searchScope2 = QsConfigFileContributor.Companion.getReferenceSearchScope(searchScope);
            parameters.getOptimizer().searchWord(hyphenedName, searchScope2, (short)255, true, (PsiElement)psiField);
        }
    }

    public QsConfigKeyReferenceSearcher() {
        super(true);
    }
}

