/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.type;

import javax.annotation.Nonnull;
import org.fest.reflect.exception.ReflectionError;
import org.fest.util.Preconditions;

public final class TypeLoader {
    private final String name;
    private final ClassLoader classLoader;

    TypeLoader(@Nonnull String name, @Nonnull ClassLoader classLoader) {
        this.name = name;
        this.classLoader = Preconditions.checkNotNull(classLoader);
    }

    public Class<?> load() {
        try {
            return this.loadType();
        }
        catch (Throwable t) {
            String format = "Unable to load class '%s' using ClassLoader %s";
            throw new ReflectionError(String.format(format, this.name, this.classLoader), t);
        }
    }

    @Nonnull
    public <T> Class<? extends T> loadAs(@Nonnull Class<T> superType) {
        Preconditions.checkNotNull(superType);
        try {
            return Preconditions.checkNotNull(this.loadType().asSubclass(superType));
        }
        catch (Throwable t) {
            String format = "Unable to load class '%s' as %s using ClassLoader %s";
            throw new ReflectionError(String.format(format, this.name, superType.getName(), this.classLoader), t);
        }
    }

    @Nonnull
    private Class<?> loadType() throws ClassNotFoundException {
        return Preconditions.checkNotNull(this.classLoader.loadClass(this.name));
    }
}

