/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.method;

import javax.annotation.Nonnull;
import org.fest.reflect.method.MethodInvoker;
import org.fest.reflect.method.ParameterTypes;
import org.fest.reflect.method.ReturnType;
import org.fest.reflect.method.ReturnTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

public final class MethodName {
    private final String value;

    @InternalApi
    public MethodName(@Nonnull String name) {
        this.value = Preconditions.checkNotNullOrEmpty(name);
    }

    @Nonnull
    public <T> ReturnType<T> withReturnType(@Nonnull Class<T> type) {
        return new ReturnType<T>(Preconditions.checkNotNullOrEmpty(this.value), type);
    }

    @Nonnull
    public <T> ReturnTypeRef<T> withReturnType(@Nonnull TypeRef<T> type) {
        return new ReturnTypeRef<T>(this.value, type);
    }

    @Nonnull
    public ParameterTypes<Void> withParameterTypes(Class<?> ... parameterTypes) {
        return new ParameterTypes<Void>(this.value, Void.class, parameterTypes);
    }

    @Nonnull
    public MethodInvoker<Void> in(@Nonnull Object target) {
        return new MethodInvoker<Void>(this.value, Void.class, new Class[0], target);
    }
}

