/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.innerclass;

import javax.annotation.Nonnull;
import org.fest.reflect.exception.ReflectionError;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class InnerClassFinder {
    private final Class<?> declaringClass;
    private final String innerClassName;

    InnerClassFinder(@Nonnull Class<?> declaringClass, @Nonnull String innerClassName) {
        this.declaringClass = Preconditions.checkNotNull(declaringClass);
        this.innerClassName = Preconditions.checkNotNullOrEmpty(innerClassName);
    }

    @Nonnull
    public Class<?> get() {
        String namespace = this.declaringClass.getName();
        String expectedInnerClassName = this.expectedInnerClassName(namespace);
        for (Class<?> innerClass : this.declaringClass.getDeclaredClasses()) {
            if (!innerClass.getName().equals(expectedInnerClassName)) continue;
            return innerClass;
        }
        String format = "Failed to find static inner class %s in %s";
        throw new ReflectionError(String.format(format, this.innerClassName, this.declaringClass.getName()));
    }

    private String expectedInnerClassName(String namespace) {
        return Strings.concat(namespace, "$", this.innerClassName);
    }
}

