/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Sets;
import org.fest.util.ToString;
import org.fest.util.VisibleForTesting;

public class IteratorAssert
extends ObjectGroupAssert<IteratorAssert, Iterator<?>> {
    protected IteratorAssert(@Nullable Iterator<?> actual) {
        super(IteratorAssert.class, IteratorAssert.wrap(actual));
    }

    @Nullable
    private static Iterator<?> wrap(@Nullable Iterator<?> actual) {
        if (actual == null) {
            return null;
        }
        return new PrettyPrintIterator(actual);
    }

    @Override
    @Nonnull
    protected IteratorAssert onProperty(@Nonnull String propertyName) {
        Preconditions.checkNotNull(propertyName);
        this.isNotNull();
        List<Object> subset = PropertySupport.instance().propertyValues(propertyName, Lists.newArrayList(this.contentOfActual()));
        return new IteratorAssert(subset.iterator());
    }

    @Override
    @Nullable
    protected Set<Object> actualAsSet() {
        if (this.actual == null) {
            return null;
        }
        return Sets.newLinkedHashSet(this.contentOfActual());
    }

    @Override
    @Nullable
    protected List<Object> actualAsList() {
        if (this.actual == null) {
            return null;
        }
        return Lists.newArrayList(this.contentOfActual());
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return this.contentOfActual().length;
    }

    @Nonnull
    private Object[] contentOfActual() {
        PrettyPrintIterator wrapped = (PrettyPrintIterator)this.actual;
        return wrapped.contents().toArray();
    }

    @VisibleForTesting
    static class PrettyPrintIterator
    implements Iterator<Object> {
        private final Iterator<?> wrapped;
        boolean wrappedWasConsumed;
        List<Object> wrappedContents;
        Iterator<Object> iterator;

        PrettyPrintIterator(@Nonnull Iterator<?> wrapped) {
            this.wrapped = wrapped;
        }

        @Nonnull
        List<Object> contents() {
            this.consumeIterator();
            return this.wrappedContents;
        }

        @Override
        public boolean hasNext() {
            this.consumeIterator();
            return this.iterator.hasNext();
        }

        @Override
        @Nullable
        public Object next() {
            this.consumeIterator();
            return this.iterator.next();
        }

        private synchronized void consumeIterator() {
            if (this.wrappedWasConsumed) {
                return;
            }
            this.wrappedContents = Lists.newArrayList(this.wrapped);
            this.wrappedWasConsumed = true;
            this.iterator = this.wrappedContents.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            this.consumeIterator();
            return ToString.toStringOf(this.wrappedContents);
        }
    }
}

