/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ComparisonFailureFactory;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.util.Arrays;
import org.fest.util.Objects;

public final class Fail {
    protected Fail() {
    }

    public static void fail() {
        Fail.fail(null);
    }

    protected static void failIfEqual(@Nullable String customErrorMessage, @Nullable Description descriptionOfActual, @Nullable Object actual, @Nullable Object other) {
        if (!Objects.areEqual(actual, other)) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(Formatting.format(descriptionOfActual, ErrorMessages.unexpectedEqual(actual, other)));
    }

    protected static void failIfNotEqual(@Nullable String customErrorMessage, @Nullable Description descriptionOfActual, @Nullable Object actual, @Nullable Object expected) {
        if (Objects.areEqual(actual, expected)) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        throw Fail.comparisonFailed(descriptionOfActual, actual, expected);
    }

    @Nonnull
    protected static AssertionError comparisonFailed(@Nullable Description description, @Nullable Object actual, @Nullable Object expected) {
        AssertionError comparisonFailure = ComparisonFailureFactory.comparisonFailure(Formatting.valueOf(description), expected, actual);
        if (comparisonFailure != null) {
            return comparisonFailure;
        }
        return Fail.failure(Formatting.format(description, ErrorMessages.unexpectedNotEqual(actual, expected)));
    }

    protected static void failIfActualIsNull(@Nullable String customErrorMessage, @Nullable Description description, @Nullable Object actual) {
        if (actual != null) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(description, Arrays.array("expecting actual value not to be null"));
    }

    protected static void failIfNull(@Nullable String customErrorMessage, @Nullable Description description, @Nullable Object o) {
        if (o != null) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(description, Arrays.array("expecting a non-null object, but it was null"));
    }

    protected static void failIfNotNull(@Nullable String customErrorMessage, @Nullable Description description, @Nullable Object o) {
        if (o == null) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(description, Arrays.array(Formatting.inBrackets(o), " should be null"));
    }

    protected static void failIfSame(@Nullable String customErrorMessage, @Nullable Description descriptionOfActual, @Nullable Object actual, @Nullable Object other) {
        if (actual != other) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(descriptionOfActual, Arrays.array("given objects are same:", Formatting.inBrackets(actual)));
    }

    protected static void failIfNotSame(@Nullable String customErrorMessage, @Nullable Description descriptionOfActual, @Nullable Object actual, @Nullable Object other) {
        if (actual == other) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(descriptionOfActual, Arrays.array("expected same instance but found:", Formatting.inBrackets(actual), " and:", Formatting.inBrackets(other)));
    }

    private static void fail(@Nullable Description description, @Nonnull Object[] message) {
        throw Fail.failure(Formatting.createMessageFrom(description, message));
    }

    protected static void failWithMessage(@Nullable String customErrorMessage) {
        if (customErrorMessage != null) {
            Fail.fail(customErrorMessage);
        }
    }

    protected static void failWithMessage(@Nullable String customErrorMessage, Throwable realCause) {
        if (customErrorMessage != null) {
            Fail.fail(customErrorMessage, realCause);
        }
    }

    public static void fail(String description, @Nullable Throwable realCause) {
        AssertionError error = Fail.failure(description);
        ((Throwable)((Object)error)).initCause(realCause);
        throw error;
    }

    @Nonnull
    public static AssertionError fail(@Nullable String message) {
        throw Fail.failure(message);
    }

    @Nonnull
    public static AssertionError failure(@Nullable String message) {
        return new AssertionError((Object)message);
    }
}

