/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.util.Arrays;

final class ErrorMessages {
    private ErrorMessages() {
    }

    @Nonnull
    static String unexpectedNotEqual(@Nullable Object actual, @Nullable Object expected) {
        return Formatting.format("expected:<%s> but was:<%s>", expected, actual);
    }

    @Nonnull
    static String unexpectedEqual(@Nullable Object actual, @Nullable Object o) {
        return ErrorMessages.assertionFailed(actual, " should not be equal to:", o);
    }

    @Nonnull
    static String unexpectedLessThanOrEqualTo(@Nullable Object actual, @Nullable Object value) {
        return ErrorMessages.assertionFailed(actual, " should be greater than:", value);
    }

    @Nonnull
    static String unexpectedLessThan(@Nullable Object actual, @Nullable Object value) {
        return ErrorMessages.assertionFailed(actual, " should be greater than or equal to:", value);
    }

    @Nonnull
    static String unexpectedGreaterThanOrEqualTo(@Nullable Object actual, @Nullable Object value) {
        return ErrorMessages.assertionFailed(actual, " should be less than:", value);
    }

    @Nonnull
    static String unexpectedGreaterThan(@Nullable Object actual, @Nullable Object value) {
        return ErrorMessages.assertionFailed(actual, " should be less than or equal to:", value);
    }

    @Nonnull
    static String unexpectedNotIn(@Nullable Object actual, @Nonnull Object other) {
        return ErrorMessages.assertionFailed(actual, " should be in:", other);
    }

    @Nonnull
    static String unexpectedIn(@Nullable Object actual, @Nonnull Object other) {
        return ErrorMessages.assertionFailed(actual, " should not be in:", other);
    }

    @Nonnull
    private static String assertionFailed(@Nullable Object actual, @Nonnull String reason, @Nullable Object expected) {
        return ErrorMessages.assertionFailed(null, actual, reason, expected);
    }

    @Nonnull
    private static String assertionFailed(@Nullable Description description, @Nullable Object actual, @Nonnull String reason, @Nullable Object expected) {
        return Formatting.createMessageFrom(description, Arrays.array("actual value:", Formatting.inBrackets(actual), reason, Formatting.inBrackets(expected)));
    }
}

