/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;

public abstract class Assert {
    private Description description;
    private String errorMessage;

    @Nullable
    public final String description() {
        return Formatting.valueOf(this.description);
    }

    protected final void description(@Nullable String d) {
        this.description(d == null ? null : new BasicDescription(d));
    }

    protected final void description(@Nullable Description d) {
        this.description = d;
    }

    @Nullable
    protected final Description rawDescription() {
        return this.description;
    }

    @Nonnull
    protected final String formattedErrorMessage(@Nonnull String message) {
        return Formatting.format(this.description, message);
    }

    protected final void replaceDefaultErrorMessagesWith(@Nullable String message) {
        this.errorMessage = message;
    }

    @Nullable
    protected final String customErrorMessage() {
        return this.errorMessage;
    }

    protected final void failIfCustomMessageIsSet() {
        Fail.failWithMessage(this.customErrorMessage());
    }

    protected final void failIfCustomMessageIsSet(@Nullable Throwable realCause) {
        Fail.failWithMessage(this.customErrorMessage(), realCause);
    }

    protected final void fail(@Nonnull String reason, @Nullable Throwable cause) {
        Fail.fail(this.formattedErrorMessage(reason), cause);
    }

    @Nonnull
    protected final AssertionError fail(@Nonnull String reason) {
        throw this.failure(reason);
    }

    @Nonnull
    protected final AssertionError failure(@Nonnull String reason) {
        return Fail.failure(this.formattedErrorMessage(reason));
    }

    public final boolean equals(Object obj) {
        throw new UnsupportedOperationException("'equals' is not supported...maybe you intended to call 'isEqualTo'");
    }

    public final int hashCode() {
        return 1;
    }
}

