/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.XmlDocument;
import com.android.resources.NamespaceReferenceRewriter;
import com.android.utils.PositionXmlParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XmlLoader {
    private XmlLoader() {
    }

    public static XmlDocument load(KeyResolver<String> selectors, PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertyResolver, String displayName, File xmlFile, InputStream inputStream, XmlDocument.Type type, String mainManifestPackageName, DocumentModel<ManifestModel.NodeTypes> model, boolean rewriteNamespaces) throws IOException, SAXException, ParserConfigurationException {
        Document domDocument = PositionXmlParser.parse((InputStream)inputStream);
        if (rewriteNamespaces) {
            Element rootElement = domDocument.getDocumentElement();
            String localPackage = rootElement.getAttribute("package");
            new NamespaceReferenceRewriter(localPackage, (t, n) -> localPackage).rewriteManifestNode((Node)rootElement, true);
        }
        return new XmlDocument(new SourceFile(xmlFile, displayName), selectors, systemPropertyResolver, domDocument.getDocumentElement(), type, mainManifestPackageName, model);
    }

    public static XmlDocument load(KeyResolver<String> selectors, PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertyResolver, SourceFile sourceFile, String xml, XmlDocument.Type type, String mainManifestPackageName, DocumentModel<ManifestModel.NodeTypes> model) throws IOException, SAXException, ParserConfigurationException {
        Document domDocument = PositionXmlParser.parse((String)xml);
        return new XmlDocument(sourceFile, selectors, systemPropertyResolver, domDocument.getDocumentElement(), type, mainManifestPackageName, model);
    }
}

