/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.kotlin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.testFramework.fixtures.kotlin.KtFlakyErrorWorkaround;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u000f\u001a\u00020\u00042\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u001c\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/testFramework/fixtures/kotlin/KtFlakyErrorWorkaround;", "", "setUp", "Lkotlin/Function0;", "", "tearDown", "repeatCount", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;I)V", "actual", "", "Ljava/lang/AssertionError;", "Lkotlin/AssertionError;", "getActual", "(Ljava/lang/AssertionError;)Ljava/lang/String;", "repeatTest", "repeatCondition", "Lkotlin/Function1;", "", "", "body", "wrapFlaky", "actualMessagePattern", "Lkotlin/text/Regex;", "Ljava/lang/Runnable;", "intellij.java.testFramework"})
public final class KtFlakyErrorWorkaround {
    private final Function0<Unit> setUp;
    private final Function0<Unit> tearDown;
    private final int repeatCount;

    public final void wrapFlaky(@NotNull Regex actualMessagePattern, @NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter((Object)actualMessagePattern, (String)"actualMessagePattern");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.repeatTest((Function1<? super Throwable, Boolean>)((Function1)new Function1<Throwable, Boolean>(this, actualMessagePattern){
            final /* synthetic */ KtFlakyErrorWorkaround this$0;
            final /* synthetic */ Regex $actualMessagePattern;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!(e instanceof AssertionError)) return false;
                CharSequence charSequence = KtFlakyErrorWorkaround.access$getActual$p(this.this$0, (AssertionError)((Object)e));
                Regex regex = this.$actualMessagePattern;
                boolean bl = false;
                if (!regex.containsMatchIn(charSequence)) return false;
                return true;
            }
            {
                this.this$0 = ktFlakyErrorWorkaround;
                this.$actualMessagePattern = regex;
                super(1);
            }
        }), body);
    }

    public final void wrapFlaky(@NotNull Regex actualMessagePattern, @NotNull Runnable body) {
        Intrinsics.checkNotNullParameter((Object)actualMessagePattern, (String)"actualMessagePattern");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.wrapFlaky(actualMessagePattern, (Function0<Unit>)((Function0)new Function0<Unit>(body){
            final /* synthetic */ Runnable $body;

            public final void invoke() {
                this.$body.run();
            }
            {
                this.$body = runnable;
                super(0);
            }
        }));
    }

    public final void repeatTest(@NotNull Function1<? super Throwable, Boolean> repeatCondition, @NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(repeatCondition, (String)"repeatCondition");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean repeat = false;
        int repeatedTimes = 0;
        do {
            try {
                body.invoke();
                repeat = false;
            }
            catch (Throwable e) {
                if (((Boolean)repeatCondition.invoke((Object)e)).booleanValue()) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KtFlakyErrorWorkaround.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn("Workaround hit! " + e.getClass() + " on try: " + repeatedTimes);
                    repeat = true;
                    if (++repeatedTimes > this.repeatCount) {
                        $i$f$logger = false;
                        Logger logger2 = Logger.getInstance(KtFlakyErrorWorkaround.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                        logger2.error("Workaround: hit too many times: " + repeatedTimes + ", max is " + this.repeatCount);
                        throw e;
                    }
                    this.tearDown.invoke();
                    this.setUp.invoke();
                    continue;
                }
                throw e;
            }
        } while (repeat);
    }

    public static /* synthetic */ void repeatTest$default(KtFlakyErrorWorkaround ktFlakyErrorWorkaround, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = repeatTest.1.INSTANCE;
        }
        ktFlakyErrorWorkaround.repeatTest((Function1<? super Throwable, Boolean>)function1, (Function0<Unit>)function0);
    }

    private final String getActual(AssertionError $this$actual) {
        String string;
        AssertionError assertionError = $this$actual;
        if (assertionError instanceof org.junit.ComparisonFailure) {
            String string2 = ((org.junit.ComparisonFailure)((Object)$this$actual)).getActual();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.actual");
        } else if (assertionError instanceof ComparisonFailure) {
            String string3 = ((ComparisonFailure)$this$actual).getActual();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.actual");
        } else {
            string = "";
        }
        return string;
    }

    public KtFlakyErrorWorkaround(@NotNull Function0<Unit> setUp, @NotNull Function0<Unit> tearDown, int repeatCount) {
        Intrinsics.checkNotNullParameter(setUp, (String)"setUp");
        Intrinsics.checkNotNullParameter(tearDown, (String)"tearDown");
        this.setUp = setUp;
        this.tearDown = tearDown;
        this.repeatCount = repeatCount;
    }

    public /* synthetic */ KtFlakyErrorWorkaround(Function0 function0, Function0 function02, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 5;
        }
        this((Function0<Unit>)function0, (Function0<Unit>)function02, n);
    }

    public static final /* synthetic */ String access$getActual$p(KtFlakyErrorWorkaround $this, AssertionError $this$access_u24actual_u24p) {
        return $this.getActual($this$access_u24actual_u24p);
    }
}

