/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.RGB;

public class RGBA
extends RGB {
    static final String functionname = "rgba";
    private String output = null;
    String fname;
    CssValue va;

    public static final CssValue filterAlpha(ApplContext ac, CssValue val) throws InvalidParamException {
        if (val.getRawType() != 19) {
            if (val.getType() == 5) {
                BigDecimal pp;
                CssCheckableValue v = val.getCheckableValue();
                if (!v.isPositive()) {
                    ac.getFrame().addWarning("out-of-range", val.toString());
                    CssNumber nb = new CssNumber();
                    nb.setIntValue(0);
                    return nb;
                }
                if (val.getRawType() == 5 && (pp = ((CssNumber)val).value).compareTo(BigDecimal.ONE) > 0) {
                    ac.getFrame().addWarning("out-of-range", val.toString());
                    CssNumber nb = new CssNumber();
                    nb.setIntValue(1);
                    return nb;
                }
            } else if (val.getType() == 4) {
                float p;
                CssCheckableValue v = val.getCheckableValue();
                if (!v.isPositive()) {
                    ac.getFrame().addWarning("out-of-range", val.toString());
                    CssNumber nb = new CssNumber();
                    nb.setIntValue(0);
                    return nb;
                }
                if (val.getRawType() == 4 && (double)(p = ((CssPercentage)val).floatValue()) > 100.0) {
                    ac.getFrame().addWarning("out-of-range", val.toString());
                    return new CssPercentage(100);
                }
            }
        }
        return val;
    }

    public final void setAlpha(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.va = RGBA.filterAlpha(ac, val);
    }

    public boolean equals(RGBA other) {
        if (other != null) {
            return super.equals(other) && this.va.equals(other.va);
        }
        return false;
    }

    public RGBA() {
        this.fname = functionname;
    }

    public RGBA(String fname) {
        this.fname = fname;
    }

    public RGBA(int r, int g, int b, float a) {
        super(r, g, b);
        CssNumber n = new CssNumber();
        n.setFloatValue(a);
        this.va = n;
        this.setPercent(false);
    }

    @Override
    public String toString() {
        if (this.output == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fname).append('(');
            sb.append(this.vr).append(", ");
            sb.append(this.vg).append(", ");
            sb.append(this.vb).append(", ");
            sb.append(this.va).append(')');
            this.output = sb.toString();
        }
        return this.output;
    }
}

