/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.HWB;
import org.w3c.css.values.RGBA;

public class LCH {
    String output = null;
    CssValue vl;
    CssValue vc;
    CssValue vh;
    CssValue alpha;
    boolean faSet = false;

    public static final CssValue filterL(ApplContext ac, CssValue val) throws InvalidParamException {
        if (val.getRawType() != 19 && val.getType() == 5) {
            BigDecimal pp;
            CssCheckableValue v = val.getCheckableValue();
            if (!v.isPositive()) {
                ac.getFrame().addWarning("out-of-range", val.toString());
                CssNumber nb = new CssNumber();
                nb.setIntValue(0);
                return nb;
            }
            if (val.getRawType() == 5 && (pp = ((CssNumber)val).value).compareTo(HWB.s100) > 0) {
                ac.getFrame().addWarning("out-of-range", val.toString());
                CssNumber nb = new CssNumber();
                nb.setValue(HWB.s100);
                return nb;
            }
        }
        return val;
    }

    public static final CssValue filterC(ApplContext ac, CssValue val) throws InvalidParamException {
        CssCheckableValue v;
        if (val.getRawType() != 19 && val.getType() == 5 && !(v = val.getCheckableValue()).isPositive()) {
            ac.getFrame().addWarning("out-of-range", val.toString());
            CssNumber nb = new CssNumber();
            nb.setValue(BigDecimal.ZERO);
            return nb;
        }
        return val;
    }

    public static final CssValue filterH(ApplContext ac, CssValue val) throws InvalidParamException {
        if (val.getRawType() != 19 && val.getType() == 5) {
            BigDecimal pp;
            CssCheckableValue v = val.getCheckableValue();
            if (!v.isPositive()) {
                ac.getFrame().addWarning("out-of-range", val.toString());
                CssNumber nb = new CssNumber();
                nb.setIntValue(0);
                return nb;
            }
            if (val.getRawType() == 5 && (pp = ((CssNumber)val).value).compareTo(CssAngle.deg360) > 0) {
                ac.getFrame().addWarning("out-of-range", val.toString());
                CssNumber nb = new CssNumber();
                nb.setValue(CssAngle.deg360);
                return nb;
            }
        }
        return val;
    }

    public final void setL(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vl = LCH.filterL(ac, val);
    }

    public final void setC(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vc = LCH.filterC(ac, val);
    }

    public final void setH(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vh = LCH.filterH(ac, val);
    }

    public final void setAlpha(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.faSet = true;
        this.alpha = RGBA.filterAlpha(ac, val);
    }

    public String toString() {
        if (this.output == null) {
            StringBuilder sb = new StringBuilder("lch(");
            sb.append(this.vl).append(" ");
            sb.append(this.vc).append(" ");
            sb.append(this.vh);
            if (this.faSet) {
                sb.append(", ").append(this.alpha);
            }
            sb.append(")");
            this.output = sb.toString();
        }
        return this.output;
    }
}

