/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ArtifactSyncTracker
implements Disposable {
    private final Project myProject;
    private Map<CommonStrategy, ServerSync> myServerToSync;

    ArtifactSyncTracker(@NotNull Project project) {
        if (project == null) {
            ArtifactSyncTracker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.registerExtensionPointListeners();
    }

    private void registerExtensionPointListeners() {
        AppServerIntegration.EXTENSION_POINT.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<AppServerIntegration>(){

            public void extensionAdded(@NotNull AppServerIntegration extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ArtifactSyncTracker.this.updateServersList();
            }

            public void extensionRemoved(@NotNull AppServerIntegration extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ArtifactSyncTracker.this.updateServersList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/view/ArtifactSyncTracker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    private Map<CommonStrategy, ServerSync> getServerToSync(boolean forceUpdate) {
        Map<CommonStrategy, ServerSync> oldServerToSync = this.myServerToSync;
        if (oldServerToSync != null && !forceUpdate) {
            return oldServerToSync;
        }
        HashMap<CommonStrategy, ServerSync> result = new HashMap<CommonStrategy, ServerSync>();
        this.processServers((Consumer<? super CommonStrategy>)((Consumer)server -> result.put((CommonStrategy)server, oldServerToSync != null && oldServerToSync.containsKey(server) ? (ServerSync)oldServerToSync.get(server) : new ServerSync())));
        this.myServerToSync = result;
        return result;
    }

    public void dispose() {
        if (this.myServerToSync != null) {
            this.myServerToSync.clear();
        }
        this.myServerToSync = null;
    }

    List<CommonStrategy> updateNotSyncedServers(CompileContext compileContext) {
        Artifact[] compiledArtifacts = ArtifactCompileScope.getArtifacts((CompileScope)compileContext.getCompileScope());
        if (compiledArtifacts == null || compiledArtifacts.length == 0) {
            return Collections.emptyList();
        }
        List<Artifact> compiledArtifactsList = Arrays.asList(compiledArtifacts);
        SmartList notSyncedServers = new SmartList();
        this.processServers((Consumer<? super CommonStrategy>)((Consumer)arg_0 -> this.lambda$updateNotSyncedServers$1(compiledArtifactsList, (List)notSyncedServers, arg_0)));
        return notSyncedServers;
    }

    void updateServersList() {
        this.getServerToSync(true);
    }

    boolean isArtifactSynced(@NotNull CommonStrategy server, @Nullable Artifact artifact) {
        if (server == null) {
            ArtifactSyncTracker.$$$reportNull$$$0(1);
        }
        return this.findOrCreateServerSync(server).isArtifactSynced(artifact);
    }

    void updateDeploymentSync(@NotNull CommonStrategy server, DeploymentModel model, DeploymentStatus newStatus) {
        Artifact artifact;
        if (server == null) {
            ArtifactSyncTracker.$$$reportNull$$$0(2);
        }
        if ((artifact = model.getArtifact()) != null && newStatus == DeploymentStatus.DEPLOYED) {
            this.findOrCreateServerSync(server).markArtifactSynced(artifact);
        }
    }

    @NotNull
    private ServerSync findOrCreateServerSync(@NotNull CommonStrategy server) {
        Map<CommonStrategy, ServerSync> serverToSync;
        if (server == null) {
            ArtifactSyncTracker.$$$reportNull$$$0(3);
        }
        if ((serverToSync = this.getServerToSync(false)).containsKey(server)) {
            ServerSync serverSync = serverToSync.get(server);
            if (serverSync == null) {
                ArtifactSyncTracker.$$$reportNull$$$0(4);
            }
            return serverSync;
        }
        serverToSync = this.getServerToSync(true);
        if (serverToSync.containsKey(server)) {
            ServerSync serverSync = serverToSync.get(server);
            if (serverSync == null) {
                ArtifactSyncTracker.$$$reportNull$$$0(5);
            }
            return serverSync;
        }
        ServerSync result = new ServerSync();
        serverToSync.put(server, result);
        ServerSync serverSync = result;
        if (serverSync == null) {
            ArtifactSyncTracker.$$$reportNull$$$0(6);
        }
        return serverSync;
    }

    private void processServers(Consumer<? super CommonStrategy> consumer) {
        for (RunnerAndConfigurationSettings configuration : RunManager.getInstance((Project)this.myProject).getAllSettings()) {
            CommonStrategy impl;
            RunConfiguration runConfiguration = configuration.getConfiguration();
            if (!(runConfiguration instanceof CommonStrategy) || (impl = (CommonStrategy)runConfiguration).getIntegration() == null) continue;
            consumer.consume((Object)impl);
        }
    }

    private /* synthetic */ void lambda$updateNotSyncedServers$1(List compiledArtifactsList, List notSyncedServers, CommonStrategy server) {
        if (this.findOrCreateServerSync(server).markArtifactsUnsynced(compiledArtifactsList)) {
            notSyncedServers.add(server);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/view/ArtifactSyncTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/view/ArtifactSyncTracker";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateServerSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isArtifactSynced";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDeploymentSync";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateServerSync";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ServerSync {
        private final Set<Artifact> mySyncedArtifacts = new HashSet<Artifact>();

        ServerSync() {
        }

        boolean markArtifactsUnsynced(Collection<Artifact> unsyncedArtifacts) {
            return this.mySyncedArtifacts.removeAll(unsyncedArtifacts);
        }

        void markArtifactSynced(Artifact syncedArtifact) {
            this.mySyncedArtifacts.add(syncedArtifact);
        }

        boolean isArtifactSynced(Artifact artifact) {
            return this.mySyncedArtifacts.contains(artifact);
        }
    }
}

