/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.restOperations;

import com.intellij.jam.JavaLibraryUtils;
import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.mvc.webClient.restOperations.RestOperation;
import com.intellij.spring.mvc.webClient.restOperations.RestOperationsConstants;
import com.intellij.spring.mvc.webClient.restOperations.RestOperationsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0014\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a8\u0006&"}, d2={"Lcom/intellij/spring/mvc/webClient/restOperations/RestOperationsUtils;", "", "()V", "addMethods", "", "javaPsiFacade", "Lcom/intellij/psi/JavaPsiFacade;", "restOperations", "", "Lorg/jetbrains/annotations/NonNls;", "apiSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "methods", "", "Lcom/intellij/psi/PsiMethod;", "stringReceiverMethod", "Lkotlin/Function1;", "", "findRestOperationsApiClasses", "", "Lcom/intellij/psi/PsiClass;", "project", "Lcom/intellij/openapi/project/Project;", "restOperationsSearchScope", "findRestOperationsUrlMethods", "findTestRestTemplateApiClasses", "findTestRestTemplateUrlMethods", "getRestOperationsApiClasses", "query", "Lcom/intellij/microservices/cache/ScopedCacheValueHolder;", "getRestOperationsMethods", "getTestRestTemplateApiClasses", "getTestRestTemplateMethods", "isRestOperationsAvailable", "module", "Lcom/intellij/openapi/module/Module;", "isTestRestTemplateAvailable", "stringReceiver", "intellij.spring.mvc.impl"})
public final class RestOperationsUtils {
    @NotNull
    public static final RestOperationsUtils INSTANCE;

    @JvmStatic
    public static final boolean isRestOperationsAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.web.client.RestOperations") || JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.web.client.AsyncRestOperations");
    }

    @JvmStatic
    public static final boolean isTestRestTemplateAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.springframework.boot.test.web.client.TestRestTemplate");
    }

    @JvmStatic
    public static final boolean isTestRestTemplateAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.boot.test.web.client.TestRestTemplate");
    }

    @JvmStatic
    public static final boolean isRestOperationsAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.springframework.web.client.RestOperations") || JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.springframework.web.client.AsyncRestOperations");
    }

    @NotNull
    public final List<PsiMethod> getRestOperationsMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, new CachedValueProvider(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<List<PsiMethod>> compute() {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
                List methods = RestOperationsUtils.access$findRestOperationsUrlMethods(RestOperationsUtils.INSTANCE, this.$project, globalSearchScope);
                return CachedValueProvider.Result.createSingleDependency((Object)methods, (Object)ProjectRootManager.getInstance((Project)this.$project));
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026Instance(project))\n    })");
        return (List)object;
    }

    @NotNull
    public final List<PsiMethod> getTestRestTemplateMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, new CachedValueProvider(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<List<PsiMethod>> compute() {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
                List methods = RestOperationsUtils.access$findTestRestTemplateUrlMethods(RestOperationsUtils.INSTANCE, this.$project, globalSearchScope);
                return CachedValueProvider.Result.createSingleDependency((Object)methods, (Object)ProjectRootManager.getInstance((Project)this.$project));
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026Instance(project))\n    })");
        return (List)object;
    }

    @NotNull
    public final List<PsiClass> getRestOperationsApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(new CachedValueProvider(query){
            final /* synthetic */ ScopedCacheValueHolder $query;

            @Nullable
            public final CachedValueProvider.Result<List<PsiClass>> compute() {
                List classes = RestOperationsUtils.access$findRestOperationsApiClasses(RestOperationsUtils.INSTANCE, this.$query.getProject(), this.$query.getApiSearchScope());
                return CachedValueProvider.Result.createSingleDependency((Object)classes, (Object)ProjectRootManager.getInstance((Project)this.$query.getProject()));
            }
            {
                this.$query = scopedCacheValueHolder;
            }
        });
    }

    @NotNull
    public final List<PsiClass> getTestRestTemplateApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(new CachedValueProvider(query){
            final /* synthetic */ ScopedCacheValueHolder $query;

            @Nullable
            public final CachedValueProvider.Result<List<PsiClass>> compute() {
                List classes = RestOperationsUtils.access$findTestRestTemplateApiClasses(RestOperationsUtils.INSTANCE, this.$query.getProject(), this.$query.getApiSearchScope());
                return CachedValueProvider.Result.createSingleDependency((Object)classes, (Object)ProjectRootManager.getInstance((Project)this.$query.getProject()));
            }
            {
                this.$query = scopedCacheValueHolder;
            }
        });
    }

    private final List<PsiClass> findRestOperationsApiClasses(Project project, GlobalSearchScope restOperationsSearchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        PsiClass[] psiClassArray = javaPsiFacade.findClasses("org.springframework.web.client.RestOperations", restOperationsSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"javaPsiFacade.findClasse\u2026estOperationsSearchScope)");
        spreadBuilder.addSpread((Object)psiClassArray);
        PsiClass[] psiClassArray2 = javaPsiFacade.findClasses("org.springframework.web.client.AsyncRestOperations", restOperationsSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray2, (String)"javaPsiFacade.findClasse\u2026estOperationsSearchScope)");
        spreadBuilder.addSpread((Object)psiClassArray2);
        return CollectionsKt.mutableListOf((Object[])((PsiClass[])spreadBuilder.toArray((Object[])new PsiClass[spreadBuilder.size()])));
    }

    private final List<PsiClass> findTestRestTemplateApiClasses(Project project, GlobalSearchScope restOperationsSearchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClassArray = javaPsiFacade.findClasses("org.springframework.boot.test.web.client.TestRestTemplate", restOperationsSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"javaPsiFacade.findClasse\u2026estOperationsSearchScope)");
        return CollectionsKt.mutableListOf((Object[])Arrays.copyOf(psiClassArray, psiClassArray.length));
    }

    private final List<PsiMethod> findRestOperationsUrlMethods(Project project, GlobalSearchScope apiSearchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        boolean bl = false;
        List methods = new ArrayList();
        JavaPsiFacade javaPsiFacade2 = javaPsiFacade;
        Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade2, (String)"javaPsiFacade");
        this.addMethods(javaPsiFacade2, "org.springframework.web.client.RestOperations", apiSearchScope, methods, this.stringReceiver());
        this.addMethods(javaPsiFacade, "org.springframework.web.client.AsyncRestOperations", apiSearchScope, methods, this.stringReceiver());
        return methods;
    }

    private final List<PsiMethod> findTestRestTemplateUrlMethods(Project project, GlobalSearchScope apiSearchScope) {
        boolean bl = false;
        List methods = new ArrayList();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(project)");
        this.addMethods(javaPsiFacade, "org.springframework.boot.test.web.client.TestRestTemplate", apiSearchScope, methods, this.stringReceiver());
        return methods;
    }

    private final Function1<PsiMethod, Boolean> stringReceiver() {
        return stringReceiver.1.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMethods(JavaPsiFacade javaPsiFacade, String restOperations, GlobalSearchScope apiSearchScope, List<PsiMethod> methods, Function1<? super PsiMethod, Boolean> stringReceiverMethod2) {
        for (PsiClass httpUrlClass : javaPsiFacade.findClasses(restOperations, apiSearchScope)) {
            for (RestOperation restOperationsMethod : RestOperationsConstants.INSTANCE.getREST_OPERATIONS_METHODS()) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullExpressionValue((Object)httpUrlClass.findMethodsByName(restOperationsMethod.getMethod(), true), (String)"httpUrlClass.findMethods\u2026tionsMethod.method, true)");
                List<PsiMethod> list = methods;
                boolean $i$f$filter = false;
                void var14_14 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)stringReceiverMethod2.invoke((Object)element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                list.addAll(list2);
            }
        }
    }

    private RestOperationsUtils() {
    }

    static {
        RestOperationsUtils restOperationsUtils;
        INSTANCE = restOperationsUtils = new RestOperationsUtils();
    }

    public static final /* synthetic */ List access$findRestOperationsUrlMethods(RestOperationsUtils $this, Project project, GlobalSearchScope apiSearchScope) {
        return $this.findRestOperationsUrlMethods(project, apiSearchScope);
    }

    public static final /* synthetic */ List access$findTestRestTemplateUrlMethods(RestOperationsUtils $this, Project project, GlobalSearchScope apiSearchScope) {
        return $this.findTestRestTemplateUrlMethods(project, apiSearchScope);
    }

    public static final /* synthetic */ List access$findRestOperationsApiClasses(RestOperationsUtils $this, Project project, GlobalSearchScope restOperationsSearchScope) {
        return $this.findRestOperationsApiClasses(project, restOperationsSearchScope);
    }

    public static final /* synthetic */ List access$findTestRestTemplateApiClasses(RestOperationsUtils $this, Project project, GlobalSearchScope restOperationsSearchScope) {
        return $this.findTestRestTemplateApiClasses(project, restOperationsSearchScope);
    }
}

