/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.restOperations;

import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.mvc.webClient.restOperations.RestOperationsUtils;
import com.intellij.spring.mvc.webClient.restOperations.RestTemplatesModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/mvc/webClient/restOperations/RestOperationsModel;", "Lcom/intellij/spring/mvc/webClient/restOperations/RestTemplatesModel;", "()V", "getApiClasses", "", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/cache/ScopedCacheValueHolder;", "getApiMethods", "Lcom/intellij/psi/PsiMethod;", "project", "Lcom/intellij/openapi/project/Project;", "getUrlApiMethods", "module", "Lcom/intellij/openapi/module/Module;", "getWebClientPackage", "", "intellij.spring.mvc.impl"})
public final class RestOperationsModel
extends RestTemplatesModel {
    @NotNull
    public static final RestOperationsModel INSTANCE;

    @Override
    @NotNull
    protected List<PsiMethod> getUrlApiMethods(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        return RestOperationsUtils.INSTANCE.getRestOperationsMethods(project);
    }

    @Override
    @NotNull
    public List<PsiClass> getApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return RestOperationsUtils.INSTANCE.getRestOperationsApiClasses(query);
    }

    @Override
    @NotNull
    public List<PsiMethod> getApiMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RestOperationsUtils.INSTANCE.getRestOperationsMethods(project);
    }

    @Override
    @NotNull
    protected String getWebClientPackage() {
        return "org.springframework.web.client";
    }

    private RestOperationsModel() {
    }

    static {
        RestOperationsModel restOperationsModel;
        INSTANCE = restOperationsModel = new RestOperationsModel();
    }
}

