/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.mockMvc;

import com.intellij.jam.JavaLibraryUtils;
import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcConstants;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcMethod;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spring/mvc/webClient/mockMvc/MockMvcUtils;", "", "()V", "findMockMvcApiClasses", "", "Lcom/intellij/psi/PsiClass;", "project", "Lcom/intellij/openapi/project/Project;", "mockMvcSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findUrlMethods", "Lcom/intellij/psi/PsiMethod;", "apiSearchScope", "getMockMvcApiClasses", "query", "Lcom/intellij/microservices/cache/ScopedCacheValueHolder;", "getMockMvcBuildersApiMethods", "isMockMvcAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "intellij.spring.mvc.impl"})
public final class MockMvcUtils {
    @NotNull
    public static final MockMvcUtils INSTANCE;

    @JvmStatic
    public static final boolean isMockMvcAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.test.web.servlet.MockMvc");
    }

    @JvmStatic
    public static final boolean isMockMvcAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.springframework.test.web.servlet.MockMvc");
    }

    @NotNull
    public final List<PsiClass> getMockMvcApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(new CachedValueProvider(query){
            final /* synthetic */ ScopedCacheValueHolder $query;

            @Nullable
            public final CachedValueProvider.Result<List<PsiClass>> compute() {
                List classes = MockMvcUtils.access$findMockMvcApiClasses(MockMvcUtils.INSTANCE, this.$query.getProject(), this.$query.getApiSearchScope());
                return CachedValueProvider.Result.createSingleDependency((Object)classes, (Object)ProjectRootManager.getInstance((Project)this.$query.getProject()));
            }
            {
                this.$query = scopedCacheValueHolder;
            }
        });
    }

    private final List<PsiClass> findMockMvcApiClasses(Project project, GlobalSearchScope mockMvcSearchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClassArray = javaPsiFacade.findClasses("org.springframework.test.web.servlet.request.MockMvcRequestBuilders", mockMvcSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"javaPsiFacade.findClasse\u2026DERS, mockMvcSearchScope)");
        return CollectionsKt.mutableListOf((Object[])Arrays.copyOf(psiClassArray, psiClassArray.length));
    }

    @NotNull
    public final List<PsiMethod> getMockMvcBuildersApiMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, new CachedValueProvider(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<List<PsiMethod>> compute() {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
                List methods = MockMvcUtils.access$findUrlMethods(MockMvcUtils.INSTANCE, this.$project, globalSearchScope);
                return CachedValueProvider.Result.createSingleDependency((Object)methods, (Object)ProjectRootManager.getInstance((Project)this.$project));
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026Instance(project))\n    })");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiMethod> findUrlMethods(Project project, GlobalSearchScope apiSearchScope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Function1 stringReceiverMethod2 = findUrlMethods.stringReceiverMethod.1.INSTANCE;
        boolean bl = false;
        List methods = new ArrayList();
        for (PsiClass psiClass : javaPsiFacade.findClasses("org.springframework.test.web.servlet.request.MockMvcRequestBuilders", apiSearchScope)) {
            PsiMethod[] psiMethodArray;
            PsiMethod[] $this$filterTo$iv$iv;
            PsiMethod[] psiMethodArray2;
            List list;
            PsiMethod[] $this$filter$iv2;
            List list2;
            for (MockMvcMethod mockMvcMethod : MockMvcConstants.INSTANCE.getHTTP_METHOD_NAMES()) {
                void $this$filterTo$iv$iv2;
                Intrinsics.checkNotNullExpressionValue((Object)psiClass.findMethodsByName(mockMvcMethod.getMethod(), true), (String)"psiClass.findMethodsByName(method.method, true)");
                list2 = methods;
                boolean $i$f$filter = false;
                void var14_21 = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv2) {
                    if (!((Boolean)stringReceiverMethod2.invoke((Object)element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                list2.addAll(list);
            }
            Collection collection = methods;
            Object[] objectArray = psiClass.findMethodsByName("request", true);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"psiClass.findMethodsByName(REQUEST_METHOD, true)");
            CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)psiClass.findMethodsByName("fileUpload", true), (String)"psiClass.findMethodsByNa\u2026FILE_UPLOAD_METHOD, true)");
            list2 = methods;
            boolean $i$f$filter = false;
            $this$filter$iv2 = psiMethodArray2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void var18_27 : $this$filterTo$iv$iv) {
                if (!((Boolean)stringReceiverMethod2.invoke((Object)var18_27)).booleanValue()) continue;
                destination$iv$iv.add(var18_27);
            }
            list = (List)destination$iv$iv;
            list2.addAll(list);
            Intrinsics.checkNotNullExpressionValue((Object)psiClass.findMethodsByName("multipart", true), (String)"psiClass.findMethodsByName(MULTIPART_METHOD, true)");
            list2 = methods;
            $i$f$filter = false;
            $this$filterTo$iv$iv = psiMethodArray;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (PsiMethod psiMethod : $this$filterTo$iv$iv) {
                if (!((Boolean)stringReceiverMethod2.invoke((Object)psiMethod)).booleanValue()) continue;
                destination$iv$iv.add(psiMethod);
            }
            list = (List)destination$iv$iv;
            list2.addAll(list);
        }
        return methods;
    }

    private MockMvcUtils() {
    }

    static {
        MockMvcUtils mockMvcUtils;
        INSTANCE = mockMvcUtils = new MockMvcUtils();
    }

    public static final /* synthetic */ List access$findMockMvcApiClasses(MockMvcUtils $this, Project project, GlobalSearchScope mockMvcSearchScope) {
        return $this.findMockMvcApiClasses(project, mockMvcSearchScope);
    }

    public static final /* synthetic */ List access$findUrlMethods(MockMvcUtils $this, Project project, GlobalSearchScope apiSearchScope) {
        return $this.findUrlMethods(project, apiSearchScope);
    }
}

