/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.mockMvc;

import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.mvc.webClient.SpringWebClientModel;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcConstants;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcMethod;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0014J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0004H\u0014\u00a8\u0006\u0018"}, d2={"Lcom/intellij/spring/mvc/webClient/mockMvc/MockMvcModel;", "Lcom/intellij/spring/mvc/webClient/SpringWebClientModel;", "()V", "findBaseUrl", "", "uExpression", "Lorg/jetbrains/uast/UExpression;", "findHttpMethod", "urlNode", "Lorg/jetbrains/uast/UCallExpression;", "getApiClasses", "", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/cache/ScopedCacheValueHolder;", "getApiMethods", "Lcom/intellij/psi/PsiMethod;", "project", "Lcom/intellij/openapi/project/Project;", "getPackageBlackList", "getUrlApiMethods", "module", "Lcom/intellij/openapi/module/Module;", "getWebClientPackage", "intellij.spring.mvc.impl"})
public final class MockMvcModel
extends SpringWebClientModel {
    @NotNull
    public static final MockMvcModel INSTANCE;

    @Override
    @Nullable
    public String findHttpMethod(@NotNull UCallExpression urlNode) {
        String methodName;
        Intrinsics.checkNotNullParameter((Object)urlNode, (String)"urlNode");
        PsiMethod psiMethod = urlNode.resolve();
        String string = methodName = psiMethod != null ? psiMethod.getName() : null;
        if (methodName == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"request")) {
            UExpression expressionType = urlNode.getArgumentForParameter(0);
            if (expressionType instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)expressionType).getResolvedName();
            }
            if (expressionType instanceof UQualifiedReferenceExpression) {
                return ((UQualifiedReferenceExpression)expressionType).getResolvedName();
            }
        } else {
            for (MockMvcMethod mockMvcMethod : MockMvcConstants.INSTANCE.getHTTP_METHOD_NAMES()) {
                if (!Intrinsics.areEqual((Object)mockMvcMethod.getMethod(), (Object)methodName)) continue;
                return mockMvcMethod.getType();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String findBaseUrl(@Nullable UExpression uExpression) {
        return "";
    }

    @Override
    @NotNull
    protected List<PsiMethod> getUrlApiMethods(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        return MockMvcUtils.INSTANCE.getMockMvcBuildersApiMethods(project);
    }

    @Override
    @NotNull
    public List<PsiClass> getApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return MockMvcUtils.INSTANCE.getMockMvcApiClasses(query);
    }

    @Override
    @NotNull
    public List<PsiMethod> getApiMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MockMvcUtils.INSTANCE.getMockMvcBuildersApiMethods(project);
    }

    @Override
    @NotNull
    protected List<String> getPackageBlackList() {
        return MockMvcConstants.INSTANCE.getPACKAGE_SEARCH_BLACK_LIST();
    }

    @Override
    @NotNull
    protected String getWebClientPackage() {
        return "org.springframework.test.web.servlet";
    }

    private MockMvcModel() {
    }

    static {
        MockMvcModel mockMvcModel;
        INSTANCE = mockMvcModel = new MockMvcModel();
    }
}

