/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.mockMvc;

import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.functional.webClient.WebClientFramework;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcModel;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spring/mvc/webClient/mockMvc/MockMvcFramework;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientFramework;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "myHoldersSearcher", "Lcom/intellij/microservices/cache/SourceTestLibSearcher;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "group", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "intellij.spring.mvc.impl"})
public final class MockMvcFramework
extends WebClientFramework {
    private final SourceTestLibSearcher<WebClientHolder> myHoldersSearcher = new SourceTestLibSearcher("SPRING_MOCK_MVC_FILES", (Function2)new Function2<Module, GlobalSearchScope, List<? extends WebClientHolder>>(MockMvcModel.INSTANCE){

        @NotNull
        public final List<WebClientHolder> invoke(@NotNull Module p1, @NotNull GlobalSearchScope p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            return ((MockMvcModel)this.receiver).findHolders(p1, p2);
        }
    });
    @NotNull
    private final FrameworkPresentation presentation;

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @Override
    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_MOCK_TYPE;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!MockMvcUtils.isMockMvcAvailable(project)) {
            return EndpointsProvider.Status.UNAVAILABLE;
        }
        if (MockMvcModel.INSTANCE.hasUsages(project)) {
            return EndpointsProvider.Status.HAS_ENDPOINTS;
        }
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public Iterable<WebClientHolder> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!MockMvcUtils.isMockMvcAvailable(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.myHoldersSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<WebClientUrl> getEndpoints(@NotNull WebClientHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return MockMvcModel.INSTANCE.getEndpoints(group);
    }

    public MockMvcFramework() {
        String string = SpringMvcBundle.message("spring.test.mock.mvc.endpoints.view.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpringMvcBundle.message(\u2026vc.endpoints.view.title\")");
        this.presentation = new FrameworkPresentation("Spring-MockMvc", string, SpringApiIcons.SpringWeb);
    }
}

