/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient;

import com.intellij.microservices.cache.ProjectCacheValueHolder;
import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalSearchers;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\r2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H&J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010#\u001a\u00020\u0012J\u0014\u0010$\u001a\u0004\u0018\u00010\t2\b\u0010%\u001a\u0004\u0018\u00010\u000bH\u0004J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\rH$J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0006\u0010\u0013\u001a\u00020\u0014H$J\b\u0010*\u001a\u00020\tH$J\u0018\u0010+\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0004H\u0002J\u001c\u0010-\u001a\u00020.2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J$\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\t2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u00101\u001a\u00020.2\u0006\u0010\u0005\u001a\u00020\u0006J&\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00042\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001007H\u0002J\u0016\u00108\u001a\u00020\u00042\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002J!\u0010:\u001a\u0002H;\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0=H\u0002\u00a2\u0006\u0002\u0010>\u00a8\u0006?"}, d2={"Lcom/intellij/spring/mvc/webClient/SpringWebClientModel;", "", "()V", "excludePackages", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "findBaseUrl", "", "uExpression", "Lorg/jetbrains/uast/UExpression;", "findEndpoints", "", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "holderPsi", "Lcom/intellij/psi/PsiElement;", "findHolders", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "module", "Lcom/intellij/openapi/module/Module;", "findHoldersUnderProgress", "apiMethods", "Lcom/intellij/psi/PsiMethod;", "findHttpMethod", "urlNode", "Lorg/jetbrains/uast/UCallExpression;", "findUrl", "uriMethodCall", "getApiClasses", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/cache/ScopedCacheValueHolder;", "getApiMethods", "getEndpoints", "group", "getExpressionValue", "argument", "getPackageBlackList", "getUastScope", "originalScope", "getUrlApiMethods", "getWebClientPackage", "getWebClientScope", "baseScope", "hasApiClassUsages", "", "hasClassNameUsage", "className", "hasUsages", "searchMethodHolders", "", "method", "webClientScope", "holders", "", "unionScope", "scopes", "withProgress", "T", "function", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.spring.mvc.impl"})
public abstract class SpringWebClientModel {
    public final boolean hasUsages(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = (ScopedCacheValueHolder)new ProjectCacheValueHolder(project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
        return this.hasApiClassUsages(scopedCacheValueHolder, globalSearchScope);
    }

    @NotNull
    public final List<WebClientHolder> findHolders(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return (List)this.withProgress((Function0)new Function0<List<? extends WebClientHolder>>(this, module, scope){
            final /* synthetic */ SpringWebClientModel this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ GlobalSearchScope $scope;

            @NotNull
            public final List<WebClientHolder> invoke() {
                return SpringWebClientModel.access$findHoldersUnderProgress(this.this$0, this.$module, this.$scope);
            }
            {
                this.this$0 = springWebClientModel;
                this.$module = module;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
    }

    private final List<WebClientHolder> findHoldersUnderProgress(Module module, GlobalSearchScope scope) {
        return this.findHoldersUnderProgress(this.getUrlApiMethods(module), module, scope);
    }

    @NotNull
    protected abstract List<PsiMethod> getUrlApiMethods(@NotNull Module var1);

    private final boolean hasApiClassUsages(ScopedCacheValueHolder<?> query, GlobalSearchScope scope) {
        boolean bl;
        block5: {
            List<PsiClass> apiClasses = this.getApiClasses(query);
            if (apiClasses.isEmpty()) {
                return false;
            }
            GlobalSearchScope webClientScope = this.getWebClientScope(query.getProject(), scope);
            if (Intrinsics.areEqual((Object)webClientScope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
                return false;
            }
            Iterable $this$any$iv = apiClasses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiClass clazz = (PsiClass)element$iv;
                    boolean bl2 = false;
                    String className = clazz.getName();
                    if (!(className != null && this.hasClassNameUsage(className, query, scope))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public abstract List<PsiClass> getApiClasses(@NotNull ScopedCacheValueHolder<?> var1);

    @NotNull
    public final List<WebClientUrl> getEndpoints(@NotNull WebClientHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PsiElement psiElement = group.getPsiElement();
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        Project project2 = project;
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiElement.containingFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
        if (ProjectScope.getLibrariesScope((Project)project2).contains(virtualFile)) {
            Object object = cachedValuesManager.getCachedValue((UserDataHolder)psiElement, new CachedValueProvider(this, psiElement, project2){
                final /* synthetic */ SpringWebClientModel this$0;
                final /* synthetic */ PsiElement $psiElement;
                final /* synthetic */ Project $project;

                @Nullable
                public final CachedValueProvider.Result<List<WebClientUrl>> compute() {
                    return CachedValueProvider.Result.createSingleDependency((Object)SpringWebClientModel.access$findEndpoints(this.this$0, this.$psiElement), (Object)ProjectRootManager.getInstance((Project)this.$project));
                }
                {
                    this.this$0 = springWebClientModel;
                    this.$psiElement = psiElement;
                    this.$project = project;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cachedValuesManager.getC\u2026stance(project))\n      })");
            return (List)object;
        }
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)psiElement, new CachedValueProvider(this, psiElement){
            final /* synthetic */ SpringWebClientModel this$0;
            final /* synthetic */ PsiElement $psiElement;

            @Nullable
            public final CachedValueProvider.Result<List<WebClientUrl>> compute() {
                return CachedValueProvider.Result.createSingleDependency((Object)SpringWebClientModel.access$findEndpoints(this.this$0, this.$psiElement), (Object)PsiModificationTracker.MODIFICATION_COUNT);
            }
            {
                this.this$0 = springWebClientModel;
                this.$psiElement = psiElement;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cachedValuesManager.getC\u2026ODIFICATION_COUNT)\n    })");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebClientUrl> findEndpoints(PsiElement holderPsi) {
        void $this$flatMapTo$iv$iv;
        if (UastContextKt.toUElement((PsiElement)holderPsi) == null) {
            return CollectionsKt.emptyList();
        }
        Project project = holderPsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holderPsi.project");
        List<PsiMethod> apiMethods = this.getApiMethods(project);
        if (apiMethods.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        HashSet methodCalls = new HashSet();
        for (PsiMethod apiMethod : apiMethods) {
            methodCalls.addAll(SpringMvcFunctionalSearchers.findMethodCalls(apiMethod, (SearchScope)new LocalSearchScope(holderPsi)));
        }
        Iterable $this$flatMap$iv = methodCalls;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            UCallExpression it = (UCallExpression)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findUrl(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public abstract List<PsiMethod> getApiMethods(@NotNull Project var1);

    private final boolean hasClassNameUsage(String className, ScopedCacheValueHolder<?> query, GlobalSearchScope scope) {
        CacheManager cacheManager = CacheManager.getInstance((Project)query.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"CacheManager.getInstance(query.project)");
        CacheManager cacheManager2 = cacheManager;
        VirtualFile[] virtualFileArray = cacheManager2.getVirtualFilesWithWord(className, (short)1, scope, true);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"cacheManager.getVirtualF\u2026ext.IN_CODE, scope, true)");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        boolean bl = false;
        VirtualFile[] virtualFileArray3 = virtualFileArray2;
        boolean bl2 = false;
        return !(virtualFileArray3.length == 0);
    }

    private final List<WebClientUrl> findUrl(UCallExpression uriMethodCall) {
        String string;
        String httpMethod;
        if (uriMethodCall.getValueArgumentCount() == 0) {
            return CollectionsKt.emptyList();
        }
        UExpression uExpression = uriMethodCall.getArgumentForParameter(0);
        if (uExpression == null) {
            return CollectionsKt.emptyList();
        }
        UExpression argument = uExpression;
        PsiElement psiElement = argument.getSourcePsi();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement sourcePsi = psiElement;
        String string2 = this.getExpressionValue(argument);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String calculatedUri = string2;
        ArrayList<WebClientUrl> urlCollector = new ArrayList<WebClientUrl>();
        String string3 = this.findHttpMethod(uriMethodCall);
        if (string3 == null) {
            string3 = httpMethod = "GET";
        }
        if ((string = this.findBaseUrl((UExpression)UastUtils.getOutermostQualified((UExpression)((UExpression)uriMethodCall)))) == null) {
            string = "";
        }
        String baseUrl = string;
        urlCollector.add(new WebClientUrl(sourcePsi, baseUrl + calculatedUri, httpMethod));
        return urlCollector;
    }

    @Nullable
    public abstract String findBaseUrl(@Nullable UExpression var1);

    @Nullable
    public abstract String findHttpMethod(@NotNull UCallExpression var1);

    @Nullable
    protected final String getExpressionValue(@Nullable UExpression argument) {
        if (argument == null) {
            return null;
        }
        String exactValue = UastUtils.evaluateString((UExpression)argument);
        if (exactValue != null) {
            return exactValue;
        }
        UStringConcatenationsFacade uStringConcatenationsFacade = UStringConcatenationsFacade.Companion.createFromUExpression$default((UStringConcatenationsFacade.Companion)UStringConcatenationsFacade.Companion, (UExpression)argument, (boolean)false, (int)2, null);
        if (uStringConcatenationsFacade == null) {
            return null;
        }
        UStringConcatenationsFacade concatenationsFacade = uStringConcatenationsFacade;
        if (!concatenationsFacade.getUastOperands().iterator().hasNext()) {
            return null;
        }
        return EndpointsViewUtils.getEndpointUrlPresentation((PartiallyKnownString)concatenationsFacade.asPartiallyKnownString());
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebClientHolder> findHoldersUnderProgress(List<? extends PsiMethod> apiMethods, Module module, GlobalSearchScope scope) {
        void $this$mapTo$iv$iv;
        if (apiMethods.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        GlobalSearchScope webClientScope = this.getWebClientScope(project, scope);
        if (Intrinsics.areEqual((Object)webClientScope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return CollectionsKt.emptyList();
        }
        HashSet holders = new HashSet();
        for (PsiMethod psiMethod : apiMethods) {
            this.searchMethodHolders(psiMethod, webClientScope, holders);
        }
        Iterable iterable = holders;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            WebClientHolder webClientHolder = new WebClientHolder((PsiElement)it);
            collection.add(webClientHolder);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void searchMethodHolders(PsiMethod method, GlobalSearchScope webClientScope, Set<PsiElement> holders) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        CacheManager cacheManager = CacheManager.getInstance((Project)method.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"CacheManager.getInstance(method.project)");
        CacheManager cacheManager2 = cacheManager;
        VirtualFile[] methodIdFiles = cacheManager2.getVirtualFilesWithWord(method.getName(), (short)1, webClientScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)methodIdFiles, (String)"methodIdFiles");
        VirtualFile[] virtualFileArray = methodIdFiles;
        Set<PsiElement> set = holders;
        boolean $i$f$mapNotNull = false;
        void var8_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var13_14 = $this$forEach$iv$iv$iv;
        int n = ((void)var13_14).length;
        for (int j = 0; j < n; ++j) {
            PsiFile psiFile;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var13_14[j];
            boolean bl = false;
            void virtualFile = element$iv$iv;
            boolean bl2 = false;
            if (PsiManager.getInstance((Project)method.getProject()).findFile((VirtualFile)virtualFile) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiFile it$iv$iv = psiFile;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        set.addAll(list);
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope getUastScope(GlobalSearchScope originalScope) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = UastLanguagePlugin.Companion.getInstances();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LanguageFileType languageFileType = it.getLanguage().getAssociatedFileType();
            collection.add(languageFileType);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LanguageFileType[] languageFileTypeArray = thisCollection$iv.toArray(new LanguageFileType[0]);
        if (languageFileTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        LanguageFileType[] fileTypes = languageFileTypeArray;
        FileType[] fileTypeArray = (FileType[])fileTypes;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)originalScope, (FileType[])Arrays.copyOf(fileTypeArray, fileTypeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.getSco\u2026riginalScope, *fileTypes)");
        return globalSearchScope;
    }

    private final GlobalSearchScope unionScope(List<? extends GlobalSearchScope> scopes) {
        GlobalSearchScope globalSearchScope;
        if (scopes.isEmpty()) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope2;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"EMPTY_SCOPE");
        } else {
            GlobalSearchScope globalSearchScope3 = GlobalSearchScope.union((Collection)scopes);
            globalSearchScope = globalSearchScope3;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"GlobalSearchScope.union(scopes)");
        }
        return globalSearchScope;
    }

    private final <T> T withProgress(Function0<? extends T> function) {
        ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
        if (progressIndicator != null && progressIndicator.isRunning()) {
            return (T)function.invoke();
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        Object object = function;
        if (object != null) {
            Function0<? extends T> function0 = object;
            object = new Computable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ Object compute() {
                    return this.function.invoke();
                }
            };
        }
        return (T)progressManager.runProcess((Computable)object, (ProgressIndicator)new EmptyProgressIndicator());
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope excludePackages(Project project, GlobalSearchScope scope) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Iterable iterable = this.getPackageBlackList();
        SpringWebClientModel springWebClientModel = this;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GlobalSearchScope globalSearchScope;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String pkg = (String)element$iv$iv;
            boolean bl2 = false;
            if (javaPsiFacade.findPackage(pkg) != null) {
                PsiPackage psiPackage;
                boolean bl3 = false;
                boolean bl4 = false;
                PsiPackage it = psiPackage;
                boolean bl5 = false;
                globalSearchScope = PackageScope.packageScope((PsiPackage)it, (boolean)false);
            } else {
                globalSearchScope = null;
            }
            if (globalSearchScope == null) continue;
            GlobalSearchScope globalSearchScope2 = globalSearchScope;
            boolean bl6 = false;
            boolean bl7 = false;
            GlobalSearchScope it$iv$iv = globalSearchScope2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        GlobalSearchScope excludedPackagesScope = springWebClientModel.unionScope(list);
        GlobalSearchScope globalSearchScope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)excludedPackagesScope));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"scope.intersectWith(Glob\u2026e(excludedPackagesScope))");
        return globalSearchScope;
    }

    @NotNull
    protected abstract List<String> getPackageBlackList();

    @NotNull
    protected abstract String getWebClientPackage();

    private final GlobalSearchScope getWebClientScope(Project project, GlobalSearchScope baseScope) {
        GlobalSearchScope nonBlackListScope = this.excludePackages(project, this.getUastScope(baseScope));
        CacheManager cacheManager = CacheManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"CacheManager.getInstance(project)");
        CacheManager cacheManager2 = cacheManager;
        Object[] containingFiles = cacheManager2.getVirtualFilesWithWord(this.getWebClientPackage(), (short)1, nonBlackListScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)containingFiles, (String)"containingFiles");
        Object[] objectArray = containingFiles;
        boolean bl = false;
        if (objectArray.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"EMPTY_SCOPE");
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)ArraysKt.toList((Object[])containingFiles));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.filesS\u2026containingFiles.toList())");
        return globalSearchScope;
    }

    public static final /* synthetic */ List access$findHoldersUnderProgress(SpringWebClientModel $this, Module module, GlobalSearchScope scope) {
        return $this.findHoldersUnderProgress(module, scope);
    }

    public static final /* synthetic */ List access$findEndpoints(SpringWebClientModel $this, PsiElement holderPsi) {
        return $this.findEndpoints(holderPsi);
    }
}

