/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ViewReference
extends PsiReferenceBase.Poly<PsiElement>
implements EmptyResolveMessageProvider,
HighlightedReference {
    private static final Logger LOG = Logger.getInstance(ViewReference.class);
    private ViewResolver myResolver;
    private final List<? extends ViewResolver> myResolvers;

    ViewReference(PsiElement element, List<? extends ViewResolver> resolvers, TextRange range, boolean soft) {
        super(element, range, soft);
        this.myResolvers = resolvers;
    }

    public Object @NotNull [] getVariants() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            if (EMPTY_ARRAY == null) {
                ViewReference.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<LookupElement> allViews = new ArrayList<LookupElement>();
        for (ViewResolver viewResolver : this.myResolvers) {
            allViews.addAll(viewResolver.getAllResolverViews());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(allViews);
        if (objectArray == null) {
            ViewReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ViewReference.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(this.myResolver != null, (Object)("Trying to bind a non-resolved reference? Resolvers: " + this.myResolvers + ", element: " + element));
        String newName = this.myResolver.bindToElement(element);
        return newName == null ? this.getElement() : ElementManipulators.handleContentChange((PsiElement)this.getElement(), (String)newName);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ViewReference.$$$reportNull$$$0(3);
        }
        return super.handleElementRename(this.myResolver.handleElementRename(newElementName));
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = this.myResolvers.isEmpty() ? SpringMvcBundle.message("ViewReference.no.view.resolvers.found", new Object[0]) : SpringMvcBundle.message("ViewReference.cannot.resolve.mvc.view", new Object[0]);
        if (string == null) {
            ViewReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            String viewName = this.getCanonicalText();
            for (ViewResolver viewResolver : this.myResolvers) {
                Set<PsiElement> resolvedViews = viewResolver.resolveView(viewName);
                if (resolvedViews.size() <= 0) continue;
                this.myResolver = viewResolver;
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(resolvedViews);
                if (resolveResultArray == null) {
                    ViewReference.$$$reportNull$$$0(5);
                }
                return resolveResultArray;
            }
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            ViewReference.$$$reportNull$$$0(6);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/ViewReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/ViewReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

