/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.mvc.views.WithPrefixSuffix;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class UrlBasedViewResolver
extends WithPrefixSuffix {
    @NotNull
    private final Module myModule;
    @NotNull
    private final String myPath;
    @NotNull
    private final String myPrefix;
    @NotNull
    private final String mySuffix;
    @NotNull
    private final String myID;
    @NotNull
    private final String myPathAndPrefix;

    public UrlBasedViewResolver(@NotNull Module module, @NotNull String ID, @Nullable String path, @Nullable String prefix, @Nullable String suffix) {
        if (module == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(0);
        }
        if (ID == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(1);
        }
        this.myModule = module;
        this.myID = ID;
        this.myPath = StringUtil.notNullize((String)path);
        this.myPrefix = StringUtil.notNullize((String)prefix);
        this.mySuffix = StringUtil.notNullize((String)suffix);
        this.myPathAndPrefix = this.myPath + this.myPrefix;
    }

    private boolean isClasspathPrefix() {
        return StringUtil.startsWith((CharSequence)this.myPathAndPrefix, (CharSequence)"classpath:");
    }

    @Override
    @NotNull
    @TestOnly
    public String getID() {
        String string = this.myID;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public Set<PsiElement> resolveView(String viewName) {
        if (this.isClasspathPrefix()) {
            PsiElement viewForClasspath = this.resolveViewForClasspath(viewName);
            Set<Object> set = viewForClasspath == null ? Collections.emptySet() : Collections.singleton(viewForClasspath);
            if (set == null) {
                UrlBasedViewResolver.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<PsiElement> set = this.getWebDirectoryElements(this.calculatePath(viewName)).stream().map(element -> element.getOriginalFile()).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(5);
        }
        return module;
    }

    @NotNull
    private Set<WebDirectoryElement> getWebDirectoryElements(String path) {
        HashSet<WebDirectoryElement> elements = new HashSet<WebDirectoryElement>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)this.getModule())) {
            ContainerUtil.addIfNotNull(elements, (Object)WebUtil.getWebUtil().findWebDirectoryElement(path, webFacet));
        }
        HashSet<WebDirectoryElement> hashSet = elements;
        if (hashSet == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private String calculatePath(String viewName) {
        return UrlBasedViewResolver.joinPaths(this.myPath, UrlBasedViewResolver.joinPaths(this.myPrefix, viewName + this.mySuffix, false), true);
    }

    private static String joinPaths(@NotNull String path, String fileName, boolean forceSlash) {
        if (path == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(7);
        }
        if (path.isEmpty()) {
            return fileName;
        }
        if (path.endsWith("/") && fileName.startsWith("/")) {
            return path + fileName.substring(1);
        }
        if (forceSlash && !path.endsWith("/") && !fileName.startsWith("/")) {
            return path + "/" + fileName;
        }
        return path + fileName;
    }

    @Nullable
    private PsiElement resolveViewForClasspath(String viewName) {
        SpringResourcesBuilder builder2 = SpringResourcesBuilder.create((Module)this.getModule(), (String)this.calculatePath(viewName), (int)1);
        PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(builder2);
        Collection items = SpringResourcesUtil.getInstance().getResourceItems(references, Conditions.alwaysTrue());
        return (PsiElement)ContainerUtil.getFirstItem((Collection)items);
    }

    @Override
    @NotNull
    public List<LookupElement> getAllResolverViews() {
        if (this.isClasspathPrefix()) {
            return this.getAllViewsForClasspath();
        }
        Set<WebDirectoryElement> webDirectoryElements = this.getWebDirectoryElements(this.calculatePath(this.myPathAndPrefix));
        LinkedList<LookupElement> lookupElements = new LinkedList<LookupElement>();
        for (WebDirectoryElement webDirectoryElement : webDirectoryElements) {
            lookupElements.addAll(UrlBasedViewResolver.getLookupElements(webDirectoryElement, this.mySuffix));
        }
        LinkedList<LookupElement> linkedList = lookupElements;
        if (linkedList == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(8);
        }
        return linkedList;
    }

    private static List<LookupElement> getLookupElements(@NotNull WebDirectoryElement element, @NotNull String suffix) {
        if (element == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(9);
        }
        if (suffix == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(10);
        }
        return ContainerUtil.mapNotNull((Object[])element.getChildren(), (Function)((NullableFunction)webDirectoryElement -> {
            String name = webDirectoryElement.getName();
            if (!name.endsWith(suffix)) {
                return null;
            }
            name = name.substring(0, name.length() - suffix.length());
            return LookupElementBuilder.create((String)name).withIcon(webDirectoryElement.getIcon(0)).withTailText(" (" + webDirectoryElement.getPath() + ")", true);
        }));
    }

    @NotNull
    private List<LookupElement> getAllViewsForClasspath() {
        SpringResourcesBuilder builder2 = SpringResourcesBuilder.create((Module)this.getModule(), (String)this.myPathAndPrefix, (int)1).endingSlashNotAllowed(false);
        PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(builder2);
        Collection directories = SpringResourcesUtil.getInstance().getResourceItems(references, PsiFileSystemItem::isDirectory);
        SmartList variants = new SmartList();
        for (PsiFileSystemItem directory : directories) {
            for (VirtualFile file : directory.getVirtualFile().getChildren()) {
                PsiFile psiFile;
                String fileName = file.getName();
                if (!fileName.endsWith(this.mySuffix) || (psiFile = PsiManager.getInstance((Project)this.getModule().getProject()).findFile(file)) == null) continue;
                String viewName = fileName.substring(0, fileName.length() - this.mySuffix.length());
                variants.add(LookupElementBuilder.create((String)viewName).withIcon(psiFile.getIcon(0)).withTailText(" (" + fileName + ")", true));
            }
        }
        SmartList smartList = variants;
        if (smartList == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    @Override
    public String bindToElement(PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        WebDirectoryElement webDirectoryElement = WebUtil.findWebDirectoryByFile((PsiFileSystemItem)((PsiFile)element));
        if (webDirectoryElement == null) {
            return null;
        }
        String path = webDirectoryElement.getPath();
        if (path.startsWith(this.myPathAndPrefix) && path.endsWith(this.mySuffix)) {
            return path.substring(this.myPathAndPrefix.length(), path.length() - this.mySuffix.length());
        }
        return path;
    }

    @Override
    @NotNull
    public String handleElementRename(String path) {
        String string = path = StringUtil.trimEnd((String)path, (String)this.mySuffix);
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(12);
        }
        return string;
    }

    public Collection<PsiFileSystemItem> getRoots() {
        HashSet<PsiFileSystemItem> elements = new HashSet<PsiFileSystemItem>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)this.myModule)) {
            ContainerUtil.addIfNotNull(elements, (Object)WebUtil.getWebUtil().findWebDirectoryElement(this.myPathAndPrefix, webFacet));
        }
        return elements;
    }

    @Nullable
    String encode(String name) {
        if (name.endsWith(this.mySuffix) && name.length() > this.mySuffix.length()) {
            return name.substring(0, name.length() - this.mySuffix.length());
        }
        return null;
    }

    String decode(String name) {
        return name + this.mySuffix;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder().append("UrlBasedViewResolver{");
        if (!this.myPath.isEmpty()) {
            builder2.append("myPath='").append(this.myPath).append("', ");
        }
        return builder2.append("myPrefix='").append(this.myPrefix).append('\'').append(", mySuffix='").append(this.mySuffix).append('\'').append('}').toString();
    }

    public boolean isAbsolutePathRequired() {
        return false;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuffix() {
        String string = this.mySuffix;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(15);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlBasedViewResolver)) {
            return false;
        }
        UrlBasedViewResolver resolver = (UrlBasedViewResolver)o;
        if (!this.getModule().equals(resolver.getModule())) {
            return false;
        }
        if (!this.getPath().equals(resolver.getPath())) {
            return false;
        }
        if (!this.getPrefix().equals(resolver.getPrefix())) {
            return false;
        }
        return this.getSuffix().equals(resolver.getSuffix());
    }

    public int hashCode() {
        int result = this.getModule().hashCode();
        result = 31 * result + this.getPath().hashCode();
        result = 31 * result + this.getPrefix().hashCode();
        result = 31 * result + this.getSuffix().hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/UrlBasedViewResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/UrlBasedViewResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebDirectoryElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResolverViews";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViewsForClasspath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "joinPaths";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

