/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.spring.mvc.SpringMVCReference;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.spring.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.mvc.views.ViewReference;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SpringMVCViewReferenceProvider
extends PsiReferenceProvider {
    private final boolean mySoft;
    private static final List<String> OUR_PREFIXES = Arrays.asList("redirect:", "forward:");

    public SpringMVCViewReferenceProvider() {
        this(true);
    }

    public SpringMVCViewReferenceProvider(boolean soft) {
        this.mySoft = soft;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Set<ViewResolver> allResolvers;
        Module module;
        if (element == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringMVCViewReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        String text = range.substring(element.getText());
        SmartList references = new SmartList();
        boolean prefixed = SpringMVCViewReferenceProvider.isPrefixed(text);
        if (prefixed) {
            range = SpringMVCViewReferenceProvider.adjustRange(range, text, OUR_PREFIXES);
            text = range.substring(element.getText());
            if (GlobalPathReferenceProvider.isWebReferenceUrl((String)range.substring(element.getText()))) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new WebReference(element, range)};
                if (psiReferenceArray == null) {
                    SpringMVCViewReferenceProvider.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }
        }
        if ((allResolvers = SpringMvcService.getInstance().getViewResolvers(module)).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringMVCViewReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList resolvers = new SmartList();
        for (ViewResolver viewResolver : allResolvers) {
            if (viewResolver instanceof UrlBasedViewResolver) {
                Collection<PsiFileSystemItem> roots = ((UrlBasedViewResolver)viewResolver).getRoots();
                for (PsiFileSystemItem root : roots) {
                    references.addAll(Arrays.asList(new UrlBasedViewResolverFileReferenceSet(root, element, text, range, (UrlBasedViewResolver)viewResolver, this.mySoft).getAllReferences()));
                }
            }
            resolvers.add(viewResolver);
        }
        if (prefixed) {
            for (ServletMappingInfo servletMappingInfo : SpringMvcUtils.getServletMappingInfos(module)) {
                references.add(new SpringMVCReference(element, range.getStartOffset(), range.substring(element.getText()), servletMappingInfo, this.mySoft));
            }
        }
        if (!prefixed && !resolvers.isEmpty()) {
            references.add(new ViewReference(element, (List<? extends ViewResolver>)resolvers, range, this.mySoft));
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    private static boolean isPrefixed(String text) {
        return OUR_PREFIXES.stream().anyMatch(prefix -> text.startsWith((String)prefix));
    }

    private static TextRange adjustRange(TextRange range, String text, List<String> prefixes) {
        return prefixes.stream().filter(prefix -> text.startsWith((String)prefix)).findAny().map(prefix -> new TextRange(range.getStartOffset() + prefix.length(), range.getEndOffset())).orElse(range);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/SpringMVCViewReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/SpringMVCViewReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UrlBasedViewResolverFileReferenceSet
    extends FileReferenceSet {
        private final UrlBasedViewResolver myViewResolver;
        private final boolean mySoft;

        private UrlBasedViewResolverFileReferenceSet(@NotNull PsiFileSystemItem root, @NotNull PsiElement element, String text, @NotNull TextRange range, @NotNull UrlBasedViewResolver viewResolver, boolean soft) {
            if (root == null) {
                UrlBasedViewResolverFileReferenceSet.$$$reportNull$$$0(0);
            }
            if (element == null) {
                UrlBasedViewResolverFileReferenceSet.$$$reportNull$$$0(1);
            }
            if (range == null) {
                UrlBasedViewResolverFileReferenceSet.$$$reportNull$$$0(2);
            }
            if (viewResolver == null) {
                UrlBasedViewResolverFileReferenceSet.$$$reportNull$$$0(3);
            }
            super(text, element, range.getStartOffset(), null, false);
            this.myViewResolver = viewResolver;
            this.mySoft = soft;
            this.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, psiFile -> !viewResolver.isAbsolutePathRequired() || this.isAbsolutePathReference() ? Collections.singletonList(root) : Collections.emptyList());
        }

        public FileReference createFileReference(final @NotNull TextRange range, final int index, final String text) {
            if (range == null) {
                UrlBasedViewResolverFileReferenceSet.$$$reportNull$$$0(4);
            }
            return new FileReference(this, range, index, text){

                protected String encode(String name, PsiElement psiElement) {
                    if (psiElement instanceof PsiFile) {
                        name = myViewResolver.encode(name);
                    }
                    return name == null ? null : super.encode(name, psiElement);
                }

                @NotNull
                public String decode(@NotNull String name) {
                    if (name == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.isLast()) {
                        name = myViewResolver.decode(name);
                    }
                    String string = super.decode(name);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                    String newName;
                    if (element == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return (newName = myViewResolver.bindToElement(element)) == null ? this.getElement() : ElementManipulators.handleContentChange((PsiElement)this.getElement(), (String)newName);
                }

                public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                    if (newElementName == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return super.handleElementRename(myViewResolver.handleElementRename(newElementName));
                }

                public String toString() {
                    return "UrlBasedViewResolverFileReference(" + text + ", " + range + ", " + index + ")";
                }

                @NotNull
                @Nls(capitalization=Nls.Capitalization.Sentence)
                public String getUnresolvedMessagePattern() {
                    String string = this.isLast() ? SpringMvcBundle.message("ViewReference.cannot.resolve.mvc.view", text) : super.getUnresolvedMessagePattern();
                    if (string == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 4: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "name";
                            break;
                        }
                        case 1: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/spring/mvc/views/SpringMVCViewReferenceProvider$UrlBasedViewResolverFileReferenceSet$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElementName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/spring/mvc/views/SpringMVCViewReferenceProvider$UrlBasedViewResolverFileReferenceSet$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "decode";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getUnresolvedMessagePattern";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "decode";
                            break;
                        }
                        case 1: 
                        case 4: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "bindToElement";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "handleElementRename";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        protected boolean isUrlEncoded() {
            return true;
        }

        protected boolean isSoft() {
            return this.mySoft;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewResolver";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/mvc/views/SpringMVCViewReferenceProvider$UrlBasedViewResolverFileReferenceSet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFileReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

