/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.velocity;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.mvc.model.xml.VelocityConfigurer;
import com.intellij.spring.mvc.views.TemplateViewResolverFactory;
import com.intellij.spring.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.WithPrefixSuffix;
import org.jetbrains.annotations.NotNull;

public class VelocityViewResolverFactory
extends TemplateViewResolverFactory {
    public VelocityViewResolverFactory() {
        super("org.springframework.web.servlet.view.velocity.VelocityViewResolver", "org.springframework.web.servlet.view.velocity.VelocityConfigurer", "resourceLoaderPath", ".vm");
    }

    @Override
    protected String getViewResolverRegistryMethodName() {
        return "velocity";
    }

    @Override
    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, WithPrefixSuffix resolver) {
        Module configurerModule = configurer.getModule();
        if (configurer instanceof VelocityConfigurer && configurerModule != null) {
            VelocityConfigurer velocityConfigurer = (VelocityConfigurer)configurer;
            String resourceLoaderPath = velocityConfigurer.getResourceLoaderPath().getStringValue();
            return new UrlBasedViewResolver(configurerModule, "VelocityViewResolverFactory", "", StringUtil.defaultIfEmpty((String)resourceLoaderPath, (String)"/WEB-INF/"), "");
        }
        ViewResolver viewResolver = super.handleCustomConfigurer(configurer, resolver);
        if (viewResolver == null) {
            VelocityViewResolverFactory.$$$reportNull$$$0(0);
        }
        return viewResolver;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/mvc/velocity/VelocityViewResolverFactory", "handleCustomConfigurer"));
    }
}

