/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.toolwindow.SpringMvcControllerPanel;
import com.intellij.spring.mvc.toolwindow.SpringMvcModulesPanel;
import com.intellij.spring.mvc.toolwindow.SpringMvcRequestMappingsPanel;
import com.intellij.spring.mvc.toolwindow.SpringMvcViewSettings;
import com.intellij.spring.toolWindow.SpringBaseView;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class SpringMvcView
extends SpringBaseView {
    private static final String TAB_ID = "MVC";

    SpringMvcView(Project project) {
        super(project);
        this.installToolbar();
        this.installContentListeners();
        this.installSettingsListener();
    }

    private void installContentListeners() {
        MessageBusConnection messageBusConnection = this.installProjectModuleListener();
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC, () -> this.myRootPanel.updatePanel());
    }

    protected FinderRecursivePanel<?> createRootPanel() {
        SpringMvcViewSettings settings = SpringMvcViewSettings.getInstance(this.myProject);
        if (settings.isShowModules()) {
            return new SpringMvcModulesPanel(this.myProject);
        }
        if (settings.isShowControllers()) {
            return new SpringMvcControllerPanel(this.myProject);
        }
        return new SpringMvcRequestMappingsPanel(this.myProject, "SpringMvcRequestMappingsPanel");
    }

    private void installToolbar() {
        final SpringMvcViewSettings settings = SpringMvcViewSettings.getInstance(this.myProject);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ToggleAction(SpringMvcBundle.message("SpringMvcView.show.modules", new Object[0]), null, AllIcons.Actions.GroupByModule){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return settings.isShowModules();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                settings.setShowModules(state);
                SpringMvcViewSettings.fireSettingsChanged(SpringMvcView.this.myProject, SpringMvcViewSettings.ChangeType.FULL);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/mvc/toolwindow/SpringMvcView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.add((AnAction)new ToggleAction(SpringMvcBundle.message("SpringMvcView.show.controllers", new Object[0]), null, SpringApiIcons.SpringBean){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return settings.isShowControllers();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                settings.setShowControllers(state);
                if (SpringMvcView.this.myRootPanel instanceof SpringMvcModulesPanel) {
                    SpringMvcViewSettings.fireSettingsChanged(SpringMvcView.this.myProject, SpringMvcViewSettings.ChangeType.REPLACE_CHILD_UPDATE);
                } else {
                    SpringMvcViewSettings.fireSettingsChanged(SpringMvcView.this.myProject, SpringMvcViewSettings.ChangeType.FULL);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/mvc/toolwindow/SpringMvcView$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new RequestMethodActionGroup(this.myProject, settings));
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ToggleAction(SpringMvcBundle.message("SpringMvcView.designer.properties.show.javadoc", new Object[0]), null, AllIcons.Toolwindows.Documentation){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return settings.isShowDoc();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                settings.setShowDoc(state);
                SpringMvcViewSettings.fireSettingsChanged(SpringMvcView.this.myProject, SpringMvcViewSettings.ChangeType.UPDATE_DETAILS);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/mvc/toolwindow/SpringMvcView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.addSeparator();
        group.add(this.getHelpAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("SpringMvcView", (ActionGroup)group, false);
        toolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(toolbar.getComponent());
    }

    private void installSettingsListener() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(SpringMvcViewSettings.TOPIC, changeType -> {
            if (changeType == SpringMvcViewSettings.ChangeType.FULL) {
                this.performFullUpdate();
            } else if (changeType == SpringMvcViewSettings.ChangeType.UPDATE_DETAILS) {
                this.performDetailsUpdate();
            } else if (changeType == SpringMvcViewSettings.ChangeType.UPDATE_LIST) {
                this.myRootPanel.updatePanel();
            } else if (changeType == SpringMvcViewSettings.ChangeType.REPLACE_CHILD_UPDATE) {
                this.myRootPanel.updateRightComponent(true);
            }
        });
    }

    static void selectIn(Project project, Object[] pathToSelect, boolean requestFocus) {
        SpringMvcView.select((Project)project, (Object[])pathToSelect, (boolean)requestFocus, (String)TAB_ID);
    }

    private static final class RequestMethodActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        private RequestMethodActionGroup(final @NotNull Project project, final SpringMvcViewSettings settings) {
            if (project == null) {
                RequestMethodActionGroup.$$$reportNull$$$0(0);
            }
            this.setPopup(true);
            this.getTemplatePresentation().setText(SpringMvcBundle.message("SpringMvcView.request.method", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.Method);
            for (final RequestMethod method : RequestMethod.values()) {
                @NlsSafe String name = method.name();
                this.add((AnAction)new ToggleAction(name){

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return settings.getRequestMethods().contains((Object)method);
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (state) {
                            settings.getRequestMethods().add(method);
                        } else {
                            settings.getRequestMethods().remove((Object)method);
                        }
                        SpringMvcViewSettings.fireSettingsChanged(project, SpringMvcViewSettings.ChangeType.UPDATE_LIST);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/spring/mvc/toolwindow/SpringMvcView$RequestMethodActionGroup$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isSelected";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setSelected";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/mvc/toolwindow/SpringMvcView$RequestMethodActionGroup", "<init>"));
        }
    }
}

