/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.services;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.SpringControllerClassInfo;
import com.intellij.spring.mvc.config.ServletFileSet;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.jam.SpringMvcUrlPathSpecification;
import com.intellij.spring.mvc.model.mappings.processors.AnnotatedRequestMappingsProcessor;
import com.intellij.spring.mvc.model.mappings.processors.WebMvcConfigurationRequestMappingProcessor;
import com.intellij.spring.mvc.model.mappings.processors.XmlDefinitionMappingProcessor;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringMvcUtils {
    public static boolean processVariables(PsiElement viewContext, Processor<? super PsiVariable> processor, @Nullable String nameHint) {
        return SpringMvcUtils.processVariables(processor, viewContext.getContainingFile().getOriginalFile(), nameHint);
    }

    public static boolean processVariables(@NotNull Processor<? super PsiVariable> processor, @NotNull PsiFile psiFile, @Nullable String nameHint) {
        Module module;
        if (processor == null) {
            SpringMvcUtils.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            SpringMvcUtils.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)psiFile)) == null) {
            return true;
        }
        Set<SpringBeanPointer<?>> controllers = SpringMvcService.getInstance().getControllers(module);
        if (controllers.isEmpty()) {
            return true;
        }
        Set<ViewResolver> resolvers = SpringMvcService.getInstance().getViewResolvers(module);
        for (SpringBeanPointer<?> pointer : controllers) {
            ProgressManager.checkCanceled();
            PsiClass beanClass = pointer.getBeanClass();
            if (beanClass == null || beanClass instanceof PsiCompiledElement) continue;
            MultiMap<String, PsiVariable> controllerVariables = SpringControllerClassInfo.getVariables(beanClass);
            if (nameHint != null && !ContainerUtil.exists((Iterable)controllerVariables.values(), variable -> nameHint.equals(variable.getName()))) continue;
            for (String view : controllerVariables.keySet()) {
                for (ViewResolver resolver : resolvers) {
                    ProgressManager.checkCanceled();
                    for (PsiElement resolvedView : resolver.resolveView(view)) {
                        Collection variables;
                        if (!psiFile.equals(resolvedView) || ContainerUtil.process((Iterable)(variables = controllerVariables.get((Object)view)), processor)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @NotNull
    public static Set<WebDirectoryElement> findWebDirectoryElements(@NotNull String path, Module module) {
        if (path == null) {
            SpringMvcUtils.$$$reportNull$$$0(2);
        }
        HashSet<WebDirectoryElement> elements = new HashSet<WebDirectoryElement>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            ContainerUtil.addIfNotNull(elements, (Object)WebUtil.getWebUtil().findWebDirectoryElement(path, webFacet));
        }
        HashSet<WebDirectoryElement> hashSet = elements;
        if (hashSet == null) {
            SpringMvcUtils.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    public static Set<ServletMappingInfo> getServletMappingInfos(@NotNull Module module) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(4);
        }
        HashSet<ServletMappingInfo> infos = new HashSet<ServletMappingInfo>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            for (CommonServletMapping mapping : webFacet.getWebModel().getServletMappings()) {
                infos.addAll(ServletMappingInfo.createMappingInfos((CommonServletMapping)mapping));
            }
        }
        HashSet<ServletMappingInfo> hashSet = infos;
        if (hashSet == null) {
            SpringMvcUtils.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public static List<UrlMappingElement> getUrlMappings(@NotNull Module module) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(6);
        }
        return SpringMvcUtils.getUrlMappings(module, SpringManager.getInstance((Project)module.getProject()).getAllModels(module));
    }

    @NotNull
    public static List<UrlMappingElement> getUrlMappings(@NotNull Module module, @NotNull Collection<SpringModel> models) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(7);
        }
        if (models == null) {
            SpringMvcUtils.$$$reportNull$$$0(8);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        SpringMvcUtils.processMappingDefinitions(module, models, (CommonProcessors.CollectProcessor<UrlMappingElement>)processor);
        return new ArrayList<UrlMappingElement>(processor.getResults());
    }

    @NotNull
    public static List<UrlMappingElement> getUrlMappingsWithoutSpringModel(@NotNull Module module) {
        ArrayList<UrlMappingElement> result;
        CommonProcessors.CollectProcessor processor;
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(9);
        }
        if (!AnnotatedRequestMappingsProcessor.processAnnotationMappings((Processor<UrlMappingElement>)(processor = new CommonProcessors.CollectProcessor(result = new ArrayList<UrlMappingElement>())), module)) {
            ArrayList<UrlMappingElement> arrayList = result;
            if (arrayList == null) {
                SpringMvcUtils.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        if (!SpringMvcFunctionalUtil.processRouterFunctionUrlMappingsWithoutSpringModel((Processor<UrlMappingElement>)processor, module)) {
            ArrayList<UrlMappingElement> arrayList = result;
            if (arrayList == null) {
                SpringMvcUtils.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        ArrayList<UrlMappingElement> arrayList = result;
        if (arrayList == null) {
            SpringMvcUtils.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static boolean processMappingDefinitions(@NotNull Module module, @NotNull Collection<SpringModel> models, @NotNull CommonProcessors.CollectProcessor<UrlMappingElement> processor) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(13);
        }
        if (models == null) {
            SpringMvcUtils.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            SpringMvcUtils.$$$reportNull$$$0(15);
        }
        if (!XmlDefinitionMappingProcessor.processXmlDefinitions(module, models, processor)) {
            return false;
        }
        if (!AnnotatedRequestMappingsProcessor.processAnnotationMappings(processor, module)) {
            return false;
        }
        if (!WebMvcConfigurationRequestMappingProcessor.processWebMvcSupport(processor, module, models)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterFunctionUrlMappings(processor, module, models);
    }

    @ApiStatus.Internal
    public static Collection<UrlMappingElement> getMatchingUrlMappings(@NotNull Module module, @NotNull UrlPath urlPath) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(16);
        }
        if (urlPath == null) {
            SpringMvcUtils.$$$reportNull$$$0(17);
        }
        List<UrlMappingElement> urlMappings = SpringMvcUtils.getUrlMappings(module, SpringManager.getInstance((Project)module.getProject()).getAllModels(module));
        String url = urlPath.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION);
        SmartList results = new SmartList(SpringMvcUtils.getResolvedResults(urlMappings, urlPath));
        for (ServletMappingInfo info : SpringMvcUtils.getServletMappingInfos(module)) {
            String servletInfoUrl;
            if (!results.isEmpty() || info.getType() != ServletMappingType.EXTENSION || info.matches(url) || (servletInfoUrl = info.addMapping(url)) == null || servletInfoUrl.equals(url)) continue;
            results.addAll(SpringMvcUtils.getResolvedResults(urlMappings, SpringMvcUrlPathSpecification.INSTANCE.parsePath(servletInfoUrl)));
        }
        return results;
    }

    @ApiStatus.Internal
    public static Set<UrlMappingElement> getBestMatchingUrlMappings(@NotNull Module module, @NotNull UrlPath urlPath) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(18);
        }
        if (urlPath == null) {
            SpringMvcUtils.$$$reportNull$$$0(19);
        }
        return UrlPathModelKt.filterBestUrlPathMatches(SpringMvcUtils.getMatchingUrlMappings(module, urlPath), mapping -> mapping.getUrlPath());
    }

    @NotNull
    private static List<UrlMappingElement> getResolvedResults(@NotNull List<UrlMappingElement> urlMappings, @NotNull UrlPath urlPath) {
        if (urlMappings == null) {
            SpringMvcUtils.$$$reportNull$$$0(20);
        }
        if (urlPath == null) {
            SpringMvcUtils.$$$reportNull$$$0(21);
        }
        SmartList results = new SmartList();
        for (UrlMappingElement mapping : urlMappings) {
            if (!mapping.getUrlPath().isCompatibleWith(urlPath)) continue;
            ContainerUtil.addIfNotNull((Collection)results, (Object)mapping);
        }
        SmartList smartList = results;
        if (smartList == null) {
            SpringMvcUtils.$$$reportNull$$$0(22);
        }
        return smartList;
    }

    @Nullable
    private static CommonServlet getServlet(@NotNull SpringModel model) {
        SpringFileSet springFileSet;
        if (model == null) {
            SpringMvcUtils.$$$reportNull$$$0(23);
        }
        if ((springFileSet = model.getFileSet()) instanceof ServletFileSet) {
            return ((ServletFileSet)springFileSet).getServlet();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/services/SpringMvcUtils";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlMappings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/services/SpringMvcUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findWebDirectoryElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServletMappingInfos";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlMappingsWithoutSpringModel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processVariables";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findWebDirectoryElements";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServletMappingInfos";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUrlMappings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUrlMappingsWithoutSpringModel";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processMappingDefinitions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingUrlMappings";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBestMatchingUrlMappings";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedResults";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getServlet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

