/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.services;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.mvc.config.ServletFileSet;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.CodeConfigurationViewResolverParser;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.spring.mvc.views.CustomTemplateViewResolverFactory;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.ViewResolverFactory;
import com.intellij.spring.mvc.views.ViewResolverRegistry;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcServiceImpl
extends SpringMvcService {
    @Override
    public Set<SpringBeanPointer<?>> getControllers(@NotNull Module module) {
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(0);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet pointers = new HashSet();
            PsiClass servletMvcController = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.mvc.Controller");
            if (servletMvcController != null) {
                for (SpringModel model : SpringMvcServiceImpl.getSpringModels(module)) {
                    pointers.addAll(SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)servletMvcController).withInheritors()));
                }
            }
            pointers.addAll(BeanService.getInstance().mapSpringBeans((Collection)SpringJamModel.getModel((Module)module).getControllers(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))));
            pointers.addAll(SpringMvcFunctionalUtil.getRouterFunctions(module));
            return CachedValueProvider.Result.create(pointers, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Override
    public Set<SpringBeanPointer<?>> getBeanControllers(@NotNull Module module) {
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(1);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            LinkedHashSet pointers = new LinkedHashSet();
            PsiClass servletMvcController = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.mvc.Controller");
            if (servletMvcController != null) {
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)servletMvcController).withInheritors();
                for (SpringModel model : SpringMvcServiceImpl.getSpringModels(module)) {
                    pointers.addAll(SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters));
                }
            }
            pointers.addAll(BeanService.getInstance().mapSpringBeans((Collection)SpringJamModel.getModel((Module)module).getControllers(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))));
            return CachedValueProvider.Result.create(pointers, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Override
    public Set<SpringBeanPointer<?>> getFunctionalRoutes(@NotNull Module module) {
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(2);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(SpringMvcFunctionalUtil.getRouterFunctions(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Override
    public Set<ViewResolver> getViewResolvers(@NotNull Module module) {
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(3);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)SpringMvcServiceImpl.getViewResolversStream(module).toImmutableSet(), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static Set<SpringModel> getSpringModels(@NotNull Module module) {
        Set<SpringModel> allModels;
        Set<SpringModel> servletModels;
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(4);
        }
        return (servletModels = (allModels = SpringManager.getInstance((Project)module.getProject()).getAllModels(module)).stream().filter(model -> model.getFileSet() instanceof ServletFileSet).collect(Collectors.toSet())).isEmpty() ? allModels : servletModels;
    }

    @ApiStatus.Internal
    public static StreamEx<ViewResolver> getViewResolversStream(@NotNull Module module) {
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(5);
        }
        CommonSpringModel[] models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module).toArray(new CommonSpringModel[0]);
        return (StreamEx)SpringMvcServiceImpl.getResolversFromBeans(module, models).append(SpringMvcServiceImpl.getResolversFromCode(module, models));
    }

    @Override
    public Set<UrlMappingElement> getUrlMappingsElements(@NotNull Module module) {
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(6);
        }
        return new HashSet<UrlMappingElement>(SpringMvcUtils.getUrlMappings(module));
    }

    @NotNull
    private static StreamEx<ViewResolver> getResolversFromBeans(@NotNull Module module, CommonSpringModel ... models) {
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(7);
        }
        PsiClass viewResolverClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.ViewResolver");
        PsiClass reactiveViewResolverClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.result.view.ViewResolver");
        StreamEx streamEx = StreamEx.of((Object[])ViewResolverRegistry.getInstance().getAllFactories()).flatMap(resolverFactory -> {
            if (resolverFactory instanceof CustomTemplateViewResolverFactory) {
                String customResolverClassName = ((CustomTemplateViewResolverFactory)resolverFactory).getCustomResolverClassName();
                return StreamEx.of(SpringMvcServiceImpl.getResolvers(resolverFactory, SpringCommonUtils.findLibraryClass((Module)module, (String)customResolverClassName), models));
            }
            return SpringMvcServiceImpl.getResolvers(resolverFactory, viewResolverClass, models).append(SpringMvcServiceImpl.getResolvers(resolverFactory, reactiveViewResolverClass, models));
        });
        if (streamEx == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(8);
        }
        return streamEx;
    }

    @NotNull
    private static StreamEx<ViewResolver> getResolvers(@NotNull ViewResolverFactory forFactories, @Nullable PsiClass viewResolverClass, CommonSpringModel ... models) {
        if (forFactories == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(9);
        }
        if (models == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(10);
        }
        if (viewResolverClass == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                SpringMvcServiceImpl.$$$reportNull$$$0(11);
            }
            return streamEx;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)viewResolverClass).withInheritors();
        StreamEx streamEx = StreamEx.of((Object[])models).flatMap(model -> StreamEx.of((Collection)SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters)).flatMap(bean -> SpringMvcServiceImpl.getViewResolvers(model, bean, forFactories)));
        if (streamEx == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(12);
        }
        return streamEx;
    }

    private static StreamEx<ViewResolver> getViewResolvers(@NotNull CommonSpringModel model, @NotNull SpringBeanPointer<?> pointer, ViewResolverFactory ... forFactories) {
        if (model == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(13);
        }
        if (pointer == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(14);
        }
        CommonSpringBean springBean = pointer.getSpringBean();
        return StreamEx.ofNullable((Object)PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(true))).flatMap(beanClass -> StreamEx.of((Object[])forFactories).flatCollection(factory -> factory.createResolvers(springBean, (PsiClass)beanClass, model)));
    }

    @NotNull
    private static StreamEx<ViewResolver> getResolversFromCode(@NotNull Module module, CommonSpringModel ... models) {
        PsiClass webMvcConfigurationSupportClass;
        if (module == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(15);
        }
        if ((webMvcConfigurationSupportClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport")) == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                SpringMvcServiceImpl.$$$reportNull$$$0(16);
            }
            return streamEx;
        }
        SpringModelSearchParameters.BeanClass mvcConfigurationSupportSearch = SpringModelSearchParameters.byClass((PsiClass)webMvcConfigurationSupportClass).withInheritors();
        StreamEx streamEx = StreamEx.of((Object[])models).flatCollection(model -> {
            SpringBeanPointer pointer;
            SmartList collectedResolvers = new SmartList();
            Iterator iterator = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)mvcConfigurationSupportSearch).iterator();
            while (iterator.hasNext() && !new CodeConfigurationViewResolverParser((CommonSpringModel)model, (SpringBeanPointer<?>)(pointer = (SpringBeanPointer)iterator.next()), (List<? super ViewResolver>)collectedResolvers).collect()) {
            }
            return collectedResolvers;
        });
        if (streamEx == null) {
            SpringMvcServiceImpl.$$$reportNull$$$0(17);
        }
        return streamEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/services/SpringMvcServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forFactories";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/services/SpringMvcServiceImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolversFromBeans";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvers";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolversFromCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControllers";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBeanControllers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionalRoutes";
                break;
            }
            case 3: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getViewResolvers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModels";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getViewResolversStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUrlMappingsElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolversFromBeans";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResolvers";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getResolversFromCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

