/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.providers;

import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.providers.SpringMvcServerProvider;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.spring.web.mvc.providers.SpringMvcOasConverters;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringMvcControllersFramework
extends SpringMvcServerProvider {
    public SpringMvcControllersFramework() {
        super("Spring-MVC-Controllers", "Spring MVC Controllers");
    }

    @NotNull
    public EndpointType getEndpointType() {
        EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
        if (endpointType == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(0);
        }
        return endpointType;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(1);
        }
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(project) && !SpringMvcLibraryUtil.hasWebfluxLibrary(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
            if (status == null) {
                SpringMvcControllersFramework.$$$reportNull$$$0(2);
            }
            return status;
        }
        if (SpringMvcLibraryUtil.isSpringMVCEnabled(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.HAS_ENDPOINTS;
            if (status == null) {
                SpringMvcControllersFramework.$$$reportNull$$$0(3);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.AVAILABLE;
        if (status == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(4);
        }
        return status;
    }

    @NotNull
    public Iterable<SpringBeanPointer<?>> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        if (project == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(6);
        }
        if (!(filter instanceof ModuleEndpointsFilter)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringMvcControllersFramework.$$$reportNull$$$0(7);
            }
            return list;
        }
        ModuleEndpointsFilter moduleFilter = (ModuleEndpointsFilter)filter;
        Module module = moduleFilter.getModule();
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(module) && !SpringMvcLibraryUtil.hasWebfluxLibrary(module)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringMvcControllersFramework.$$$reportNull$$$0(8);
            }
            return list;
        }
        Set<SpringBeanPointer<?>> allControllers = SpringMvcService.getInstance().getBeanControllers(module);
        Iterable iterable = moduleFilter.filterByScope(allControllers, SpringBeanPointer::getContainingFile);
        if (iterable == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(9);
        }
        return iterable;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(10);
        }
        ModificationTracker modificationTracker = SpringModificationTrackersManager.getInstance((Project)project).getEndpointsModificationTracker();
        if (modificationTracker == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(11);
        }
        return modificationTracker;
    }

    @Override
    @Nullable
    public Object getEndpointData(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint, @NotNull String dataId) {
        if (group == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(12);
        }
        if (endpoint == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(13);
        }
        if (dataId == null) {
            SpringMvcControllersFramework.$$$reportNull$$$0(14);
        }
        if (EndpointsProvider.OPENAPI_PATH.is(dataId)) {
            return SpringMvcOasConverters.getMvcHandlerOasModel(endpoint, this.getUrlTargetInfo(group, endpoint));
        }
        return super.getEndpointData(group, endpoint, dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/providers/SpringMvcControllersFramework";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointType";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/providers/SpringMvcControllersFramework";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointGroups";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointGroups";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

