/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.SpringControllerClassInfo;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

public final class SpringMvcRequestMappingRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public String getId() {
        return "SpringMvcRequestMappingRelatedItemLineMarkerProvider";
    }

    public String getName() {
        return SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.related.views", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.RequestMapping;
        if (icon == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        if (!SpringMvcLibraryUtil.isSpringMVCEnabled(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(final @NotNull PsiElement context, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        NavigatablePsiElement navigatablePsiElement;
        UElement parent;
        if (context == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (!((parent = UastUtils.getUParentForIdentifier((PsiElement)context)) instanceof UMethod)) {
            return;
        }
        final PsiMethod method = ((UMethod)parent).getJavaPsi();
        if (!SpringControllerUtils.isRequestHandlerCandidate(method)) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        if (!SpringControllerUtils.isRequestHandler(method)) {
            return;
        }
        final Set views = SpringControllerClassInfo.getViews((UMethod)parent).keySet();
        if (views.isEmpty()) {
            return;
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
        SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, views, (Processor<PsiElement>)findFirstProcessor);
        if (!findFirstProcessor.isFound()) {
            return;
        }
        PsiElement firstResult = (PsiElement)findFirstProcessor.getFoundValue();
        Object object = firstResult instanceof NavigatablePsiElement ? (NavigatablePsiElement)firstResult : (navigatablePsiElement = firstResult != null ? firstResult.getContainingFile() : null);
        if (navigatablePsiElement == null) {
            return;
        }
        GutterIconNavigationHandler<PsiElement> handler = new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                String methodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)2, (int)0);
                final String title = SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.request.mapping.title", methodName);
                BackgroundUpdaterTask updaterTask = new BackgroundUpdaterTask(context.getProject(), SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.request.mapping.task.title", methodName), null){

                    public String getCaption(int size) {
                        if (this.isFinished()) {
                            return SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.request.mapping.task.finished.caption", title, size);
                        }
                        return SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.request.mapping.task.caption", title, size);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.run(indicator);
                        SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, views, (Processor<PsiElement>)((Processor)file -> {
                            ProgressManager.checkCanceled();
                            if (((Boolean)ReadAction.compute(() -> !this.updateComponent((PsiElement)file))).booleanValue()) {
                                indicator.cancel();
                            }
                            return true;
                        }));
                    }

                    public void onSuccess() {
                        super.onSuccess();
                        PsiElement oneElement = this.getTheOnlyOneElement();
                        if (oneElement instanceof NavigatablePsiElement) {
                            ((NavigatablePsiElement)oneElement).navigate(true);
                            this.myPopup.cancel();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/spring/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider$1$1", "run"));
                    }
                };
                PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])new NavigatablePsiElement[]{navigatablePsiElement}, (String)updaterTask.getCaption(1), (String)title, (ListCellRenderer)new DefaultPsiElementCellRenderer(), (BackgroundUpdaterTask)updaterTask);
            }
        };
        SpringGutterIconBuilder.CustomNavigationHandlerBuilder builder2 = SpringGutterIconBuilder.CustomNavigationHandlerBuilder.createBuilder((Icon)SpringApiIcons.Gutter.RequestMapping, (String)SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.related.views", new Object[0]), (GutterIconNavigationHandler)handler, dom -> GotoRelatedItem.createItems(Collections.singleton(dom), (String)SpringMvcBundle.message("SpringMvcRequestMappingRelatedItemLineMarkerProvider.spring.view", new Object[0])));
        builder2.setTargets(NotNullLazyValue.lazy(() -> {
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, views, (Processor<PsiElement>)processor);
            return processor.getResults();
        }));
        result.add(builder2.withElementPresentation(SpringMvcBundle.message("request.mapping.gutter.views.name", new Object[0])).createSpringRelatedMergeableLineMarkerInfo(context));
    }

    private static boolean processViews(PsiElement context, Set<String> views, Processor<PsiElement> processor) {
        return (Boolean)ReadAction.compute(() -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            if (module == null) {
                return true;
            }
            Set<ViewResolver> resolvers = SpringMvcService.getInstance().getViewResolvers(module);
            for (String view : views) {
                for (ViewResolver resolver : resolvers) {
                    PsiElement element;
                    Set psiElements = (Set)ReadAction.compute(() -> resolver.resolveView(view));
                    Iterator iterator = psiElements.iterator();
                    if (!iterator.hasNext() || processor.process((Object)(element = (PsiElement)iterator.next()))) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

