/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.mappings.processors;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.mappings.UrlMappingPsiBasedElement;
import com.intellij.spring.mvc.model.xml.ViewControllerBase;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlDefinitionMappingProcessor {
    public static boolean processXmlDefinitions(@NotNull Module module, @NotNull Collection<SpringModel> models, @NotNull Processor<? super UrlMappingElement> processor) {
        if (module == null) {
            XmlDefinitionMappingProcessor.$$$reportNull$$$0(0);
        }
        if (models == null) {
            XmlDefinitionMappingProcessor.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            XmlDefinitionMappingProcessor.$$$reportNull$$$0(2);
        }
        for (SpringModel model : models) {
            for (LocalXmlModel localXmlModel : SpringModelVisitorUtils.getLocalXmlModels((CommonSpringModel)model)) {
                for (SpringBeanPointer<?> beanPointer : XmlDefinitionMappingProcessor.searchLocalBeans(localXmlModel, XmlDefinitionMappingProcessor.createSearchParams(module, "org.springframework.web.servlet.mvc.Controller"))) {
                    if (XmlDefinitionMappingProcessor.processMvcController(processor, beanPointer)) continue;
                    return false;
                }
                for (SpringBeanPointer<?> mapping : XmlDefinitionMappingProcessor.searchLocalBeans(localXmlModel, XmlDefinitionMappingProcessor.createSearchParams(module, "org.springframework.web.servlet.handler.SimpleUrlHandlerMapping"))) {
                    if (XmlDefinitionMappingProcessor.processSimpleMapping(processor, mapping)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processSimpleMapping(@NotNull Processor<? super UrlMappingElement> processor, SpringBeanPointer<?> mapping) {
        CommonSpringBean springBean;
        if (processor == null) {
            XmlDefinitionMappingProcessor.$$$reportNull$$$0(3);
        }
        if ((springBean = mapping.getSpringBean()) instanceof SpringBean) {
            SpringPropertyDefinition mappings;
            SpringPropertyDefinition urlMap = ((SpringBean)springBean).getProperty("urlMap");
            if (urlMap instanceof SpringProperty) {
                for (SpringEntry entry : ((SpringProperty)urlMap).getMap().getEntries()) {
                    String key = (String)entry.getKeyAttr().getValue();
                    if (key == null || processor.process((Object)new XmlDefinitionUrlMappingBaseElement(key, (GenericAttributeValue<String>)entry.getKeyAttr()))) continue;
                    return false;
                }
            }
            if ((mappings = ((SpringBean)springBean).getProperty("mappings")) == null) {
                return true;
            }
            PsiElement mappingPsiElement = mapping.getPsiElement();
            if (mappingPsiElement == null) {
                return true;
            }
            String value = mappings.getValueAsString();
            if (value != null) {
                try {
                    Properties properties = new Properties();
                    properties.load(new StringReader(value));
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        @NotNull String url = (String)entry.getKey();
                        if (processor.process((Object)new SpringBeanPointerUrlMappingBaseElement(url, mappingPsiElement.getNavigationElement(), mapping))) continue;
                        return false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if (mappings instanceof SpringProperty) {
                SpringProperty holder = (SpringProperty)mappings;
                for (Prop prop : holder.getProps().getProps()) {
                    String url = prop.getKey().getStringValue();
                    if (url == null || processor.process((Object)new XmlDefinitionUrlMappingBaseElement(url, (GenericAttributeValue<String>)prop.getKey()))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static Collection<SpringBeanPointer<?>> searchLocalBeans(@NotNull LocalXmlModel localXmlModel, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable SpringModelSearchParameters.BeanClass searchParameters) {
        if (localXmlModel == null) {
            XmlDefinitionMappingProcessor.$$$reportNull$$$0(4);
        }
        if (searchParameters == null) {
            return Collections.emptyList();
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        localXmlModel.processLocalBeansByClass(searchParameters, (Processor)processor);
        return processor.getResults();
    }

    private static boolean processMvcController(@NotNull Processor<? super UrlMappingElement> processor, SpringBeanPointer<?> beanPointer) {
        PomTarget target;
        PsiElement element;
        if (processor == null) {
            XmlDefinitionMappingProcessor.$$$reportNull$$$0(5);
        }
        if ((element = beanPointer.getPsiElement()) instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof SpringBeanPsiTarget) {
            String name;
            ViewControllerBase viewController;
            String path;
            CommonSpringBean bean = ((SpringBeanPsiTarget)target).getSpringBean();
            PsiElement navigationElement = element.getNavigationElement();
            if (bean instanceof ViewControllerBase ? (path = (viewController = (ViewControllerBase)bean).getPath().getStringValue()) != null && !processor.process((Object)new SpringBeanPointerUrlMappingBaseElement(path, navigationElement, beanPointer)) : (name = beanPointer.getName()) != null && !processor.process((Object)new SpringBeanPointerUrlMappingBaseElement(name, navigationElement, beanPointer))) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static SpringModelSearchParameters.BeanClass createSearchParams(@NotNull Module module, @NotNull String fqn) {
        PsiClass psiClass;
        if (module == null) {
            XmlDefinitionMappingProcessor.$$$reportNull$$$0(6);
        }
        if (fqn == null) {
            XmlDefinitionMappingProcessor.$$$reportNull$$$0(7);
        }
        if ((psiClass = SpringCommonUtils.findLibraryClass((Module)module, (String)fqn)) == null) {
            return null;
        }
        return SpringModelSearchParameters.byClass((PsiClass)psiClass).withInheritors();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localXmlModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/mvc/model/mappings/processors/XmlDefinitionMappingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processXmlDefinitions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processSimpleMapping";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "searchLocalBeans";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processMvcController";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createSearchParams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SpringBeanPointerUrlMappingBaseElement
    extends UrlMappingPsiBasedElement {
        @NotNull
        private final SpringBeanPointer<?> mySpringBeanPointer;

        private SpringBeanPointerUrlMappingBaseElement(@NotNull String url, @NotNull PsiElement navigationElement, @NotNull SpringBeanPointer<?> springBeanPointer) {
            if (url == null) {
                SpringBeanPointerUrlMappingBaseElement.$$$reportNull$$$0(0);
            }
            if (navigationElement == null) {
                SpringBeanPointerUrlMappingBaseElement.$$$reportNull$$$0(1);
            }
            if (springBeanPointer == null) {
                SpringBeanPointerUrlMappingBaseElement.$$$reportNull$$$0(2);
            }
            super(url, navigationElement, null, url, RequestMethod.EMPTY_ARRAY);
            this.mySpringBeanPointer = springBeanPointer;
        }

        @Override
        @Nullable
        public PomNamedTarget getPomTarget() {
            PsiElement domElement = this.mySpringBeanPointer.getPsiElement();
            if (domElement instanceof PomTargetPsiElement) {
                return this.toPomTarget(domElement);
            }
            return super.getPomTarget();
        }

        @Override
        public boolean isDefinedInBean(SpringBeanPointer<? extends CommonSpringBean> controllerSpringBeanPointer) {
            return this.mySpringBeanPointer.isReferenceTo(controllerSpringBeanPointer.getSpringBean());
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpringBeanPointerUrlMappingBaseElement element = (SpringBeanPointerUrlMappingBaseElement)o;
            return Objects.equals(this.mySpringBeanPointer.getPsiElement(), element.mySpringBeanPointer.getPsiElement()) && super.equals(o);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigationElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "springBeanPointer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/mvc/model/mappings/processors/XmlDefinitionMappingProcessor$SpringBeanPointerUrlMappingBaseElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class XmlDefinitionUrlMappingBaseElement
    extends UrlMappingPsiBasedElement {
        @NotNull
        private final DomAnchor<GenericAttributeValue<String>> anchor;

        private XmlDefinitionUrlMappingBaseElement(@NotNull String url, GenericAttributeValue<String> domElement) {
            if (url == null) {
                XmlDefinitionUrlMappingBaseElement.$$$reportNull$$$0(0);
            }
            super(url, (PsiElement)domElement.ensureXmlElementExists(), null, url, RequestMethod.EMPTY_ARRAY);
            this.anchor = DomService.getInstance().createAnchor(domElement);
        }

        @Override
        @Nullable
        public PomNamedTarget getPomTarget() {
            DomTarget domTarget;
            PsiElement psiElement = this.anchor.getPsiElement();
            if (psiElement instanceof PomTargetPsiElement) {
                return this.toPomTarget(psiElement);
            }
            GenericAttributeValue domElement = (GenericAttributeValue)this.anchor.retrieveDomElement();
            if (domElement != null && (domTarget = DomTarget.getTarget((DomElement)domElement)) != null) {
                return domTarget;
            }
            return super.getPomTarget();
        }

        @Override
        public boolean isDefinedInBean(SpringBeanPointer<? extends CommonSpringBean> controllerSpringBeanPointer) {
            CommonSpringBean targetBean;
            PomNamedTarget target = this.getPomTarget();
            return target != null && (targetBean = SpringBeanPomTargetUtils.getSpringBean((PomTarget)target)) instanceof DomSpringBean && Comparing.equal((Object)targetBean, (Object)controllerSpringBeanPointer.getSpringBean());
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XmlDefinitionUrlMappingBaseElement element = (XmlDefinitionUrlMappingBaseElement)o;
            return Objects.equals(this.anchor.getPsiElement(), element.anchor.getPsiElement()) && super.equals(o);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/spring/mvc/model/mappings/processors/XmlDefinitionMappingProcessor$XmlDefinitionUrlMappingBaseElement", "<init>"));
        }
    }
}

