/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.mappings.processors;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.model.jam.RequestMappingUtil;
import com.intellij.spring.mvc.model.mappings.UrlMappingPsiBasedElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotatedRequestMappingsProcessor {
    static final Key<CachedValue<List<Pair<RequestMapping.Method, Boolean>>>> REQUEST_MAPPINGS_CACHE = Key.create((String)"REQUEST_MAPPINGS_CACHE");

    public static boolean processAnnotationMappings(@NotNull Processor<UrlMappingElement> processor, @NotNull Module module) {
        if (processor == null) {
            AnnotatedRequestMappingsProcessor.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AnnotatedRequestMappingsProcessor.$$$reportNull$$$0(1);
        }
        return AnnotatedRequestMappingsProcessor.processAnnotationMappings(processor, AnnotatedRequestMappingsProcessor.getRequestMappingsFromAnnotations(module));
    }

    private static List<Pair<RequestMapping.Method, Boolean>> getRequestMappingsFromAnnotations(@NotNull Module module) {
        if (module == null) {
            AnnotatedRequestMappingsProcessor.$$$reportNull$$$0(2);
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, REQUEST_MAPPINGS_CACHE, () -> {
            JamService jamService = JamService.getJamService((Project)module.getProject());
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true);
            HashSet<PsiClass> cacheDependencies = new HashSet<PsiClass>();
            ArrayList<Pair> allMappings = new ArrayList<Pair>();
            Collection requestMappingAnnotations = MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"org.springframework.web.bind.annotation.RequestMapping", (boolean)false);
            for (PsiClass anno : requestMappingAnnotations) {
                if (anno.getQualifiedName() == null) continue;
                List mappings = jamService.getJamMethodElements(RequestMapping.METHOD_JAM_KEY, anno.getQualifiedName(), scope);
                for (RequestMapping.Method mapping : mappings) {
                    PsiClass containingClass = ((PsiMethod)mapping.getPsiElement()).getContainingClass();
                    if (containingClass == null) continue;
                    cacheDependencies.add(containingClass);
                    SpringController springController = (SpringController)SpringController.META.getJamElement((PsiModifierListOwner)containingClass);
                    allMappings.add(Pair.create((Object)mapping, (Object)(springController != null ? 1 : 0)));
                }
            }
            ContainerUtil.addAll(cacheDependencies, (Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies());
            return CachedValueProvider.Result.create(allMappings, (Object[])ArrayUtil.toObjectArray(cacheDependencies));
        }, false);
    }

    private static boolean processAnnotationMappings(@NotNull Processor<UrlMappingElement> processor, @NotNull List<Pair<RequestMapping.Method, Boolean>> requestMappings) {
        if (processor == null) {
            AnnotatedRequestMappingsProcessor.$$$reportNull$$$0(3);
        }
        if (requestMappings == null) {
            AnnotatedRequestMappingsProcessor.$$$reportNull$$$0(4);
        }
        for (Pair<RequestMapping.Method, Boolean> pair : requestMappings) {
            RequestMapping.Method mapping = (RequestMapping.Method)pair.first;
            Boolean inControllerClass = (Boolean)pair.second;
            if (inControllerClass.booleanValue()) {
                if (AnnotatedRequestMappingsProcessor.processMapping(processor, mapping.getClassLevelMapping(), mapping)) continue;
                return false;
            }
            PsiClass psiClass = ((PsiMethod)mapping.getPsiElement()).getContainingClass();
            assert (psiClass != null);
            for (PsiClass controllerClass : ClassInheritorsSearch.search((PsiClass)psiClass)) {
                if (SpringController.META.getJamElement((PsiModifierListOwner)controllerClass) == null || AnnotatedRequestMappingsProcessor.processMapping(processor, RequestMappingUtil.getClassLevelMapping(controllerClass), mapping)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processMapping(Processor<UrlMappingElement> processor, RequestMapping<PsiClass> classMapping, @NotNull RequestMapping.Method mapping) {
        if (mapping == null) {
            AnnotatedRequestMappingsProcessor.$$$reportNull$$$0(5);
        }
        RequestMethod[] method = mapping.getMethods();
        List<JamStringAttributeElement<String>> urls = mapping.getMappingUrls();
        if (urls.isEmpty() && classMapping != null) {
            AnnotatedRequestMappingsProcessor.processRequestMapping(processor, mapping, classMapping, null, null, method);
        }
        for (JamStringAttributeElement<String> url : urls) {
            String urlValue = url.getStringValue();
            if (!(classMapping != null ? !AnnotatedRequestMappingsProcessor.processRequestMapping(processor, mapping, classMapping, url, urlValue, method) : urlValue != null && !processor.process((Object)new UrlMappingPsiBasedElement(urlValue, (PsiElement)mapping.getPsiElement(), (PomTarget)new JamPomTarget((JamElement)mapping, url), urlValue, method)))) continue;
            return false;
        }
        return true;
    }

    private static boolean processRequestMapping(@NotNull Processor<UrlMappingElement> processor, RequestMapping<PsiMethod> mapping, RequestMapping<PsiClass> classMapping, @Nullable JamStringAttributeElement<String> url, @Nullable String urlValue, RequestMethod ... method) {
        List<JamStringAttributeElement<String>> classUrlAttributes;
        if (processor == null) {
            AnnotatedRequestMappingsProcessor.$$$reportNull$$$0(6);
        }
        if ((classUrlAttributes = classMapping.getMappingUrls()).isEmpty() && urlValue != null) {
            return processor.process((Object)new UrlMappingPsiBasedElement(urlValue, (PsiElement)mapping.getPsiElement(), (PomTarget)new JamPomTarget(mapping, url), urlValue, method));
        }
        for (JamStringAttributeElement<String> classUrl : classUrlAttributes) {
            UrlMappingBuilder builder2;
            String url1;
            String baseUrl = classUrl.getStringValue();
            if (baseUrl != null && urlValue == null) {
                UrlMappingPsiBasedElement psiBasedMapping = new UrlMappingPsiBasedElement(baseUrl, (PsiElement)mapping.getPsiElement(), (PomTarget)new JamPomTarget(classMapping, classUrl), baseUrl, method);
                if (processor.process((Object)psiBasedMapping)) continue;
                return false;
            }
            if (baseUrl == null) {
                baseUrl = "";
            }
            if (processor.process((Object)new UrlMappingPsiBasedElement(url1 = (builder2 = new UrlMappingBuilder(baseUrl).appendSegment(urlValue)).build(), (PsiElement)mapping.getPsiElement(), (PomTarget)new JamPomTarget(mapping, url), url1, method))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMappings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/mvc/model/mappings/processors/AnnotatedRequestMappingsProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAnnotationMappings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequestMappingsFromAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processRequestMapping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

