/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.microservices.mime.MimeTypeReference;
import com.intellij.microservices.uast.url.UrlPathReferenceJamConverter;
import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTarget;
import com.intellij.semantic.SemKey;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.model.jam.MVCPathVariable;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.model.jam.RequestMappingUtil;
import com.intellij.spring.mvc.model.jam.SpringMVCModelAttribute;
import com.intellij.spring.mvc.model.jam.SpringMvcUrlPathSpecification;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;

@Presentation(typeName="@RequestMapping", icon="com.intellij.spring.SpringApiIcons.RequestMapping")
public abstract class SpringRequestMapping<T extends PsiMember>
implements RequestMapping<T> {
    private static final JamStringAttributeMeta.Collection<String> VALUE_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new UrlPathReferenceJamConverter((FrameworkUrlPathSpecification)SpringMvcUrlPathSpecification.INSTANCE));
    private static final JamStringAttributeMeta.Collection<String> PATH_META = JamAttributeMeta.collectionString((String)"path", (JamConverter)new UrlPathReferenceJamConverter((FrameworkUrlPathSpecification)SpringMvcUrlPathSpecification.INSTANCE));
    private static final JamEnumAttributeMeta.Collection<RequestMethod> METHOD_META = new JamEnumAttributeMeta.Collection("method", RequestMethod.class);
    private static final JamStringAttributeMeta.Collection<String> CONSUMES_META = JamAttributeMeta.collectionString((String)"consumes", (JamConverter)new RequestMappingMimetypeConverter());
    private static final JamStringAttributeMeta.Collection<String> PRODUCES_META = JamAttributeMeta.collectionString((String)"produces", (JamConverter)new RequestMappingMimetypeConverter());
    private static final JamStringAttributeMeta.Collection<String> PARAMS_META = JamAttributeMeta.collectionString((String)"params");
    private static final JamStringAttributeMeta.Collection<String> HEADERS_META = JamAttributeMeta.collectionString((String)"headers");
    static final JamAnnotationMeta REQUEST_MAPPING_ANNO_META = new JamAnnotationMeta("org.springframework.web.bind.annotation.RequestMapping").addAttribute(VALUE_META).addAttribute(PATH_META).addAttribute(METHOD_META).addAttribute(CONSUMES_META).addAttribute(PRODUCES_META).addAttribute(PARAMS_META).addAttribute(HEADERS_META);
    private final Function<JamStringAttributeElement<String>, PsiTarget> myMapping = url -> url.getPsiLiteral() == null ? null : new JamPomTarget((JamElement)this, url);

    private List<String> mapToStringList(JamStringAttributeMeta.Collection<String> attributeMeta) {
        return SpringRequestMapping.mapToStringList((List)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), attributeMeta));
    }

    static List<String> mapToStringList(List<? extends JamStringAttributeElement<String>> stringAttributeElements) {
        return ContainerUtil.mapNotNull(stringAttributeElements, JamStringAttributeElement::getStringValue);
    }

    @Override
    public List<JamStringAttributeElement<String>> getMappingUrls() {
        PsiElementRef psiElementRef = PsiElementRef.real(this.getPsiElement());
        List valueElements = (List)REQUEST_MAPPING_ANNO_META.getAttribute(psiElementRef, VALUE_META);
        if (!valueElements.isEmpty()) {
            return valueElements;
        }
        return (List)REQUEST_MAPPING_ANNO_META.getAttribute(psiElementRef, PATH_META);
    }

    @Override
    @Nullable
    public PsiAnnotation getIdentifyingAnnotation() {
        return REQUEST_MAPPING_ANNO_META.getAnnotation(this.getPsiElement());
    }

    @Override
    public RequestMethod @NotNull [] getMethods() {
        List methods = ContainerUtil.mapNotNull((Collection)((Collection)REQUEST_MAPPING_ANNO_META.getAttribute(this.getPsiElement(), METHOD_META)), JamEnumAttributeElement::getValue);
        RequestMethod[] requestMethodArray = methods.toArray(RequestMethod.EMPTY_ARRAY);
        if (requestMethodArray == null) {
            SpringRequestMapping.$$$reportNull$$$0(0);
        }
        return requestMethodArray;
    }

    @Override
    public List<String> getUrls() {
        return SpringRequestMapping.mapToStringList(this.getMappingUrls());
    }

    @Override
    public List<String> getConsumes() {
        return this.mapToStringList(CONSUMES_META);
    }

    @Override
    public List<String> getProduces() {
        return this.mapToStringList(PRODUCES_META);
    }

    @Override
    public List<String> getParams() {
        return this.mapToStringList(PARAMS_META);
    }

    @Override
    public List<String> getHeaders() {
        return this.mapToStringList(HEADERS_META);
    }

    protected List<PsiTarget> getPomTargets() {
        return ContainerUtil.mapNotNull(this.getMappingUrls(), this.myMapping);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/mvc/model/jam/SpringRequestMapping", "getMethods"));
    }

    private static class RequestMappingMimetypeConverter
    extends JamConverter<String> {
        private RequestMappingMimetypeConverter() {
        }

        @Nullable
        public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
            return s;
        }

        public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<String> context, @NotNull PsiLanguageInjectionHost injectionHost) {
            UElement element;
            if (context == null) {
                RequestMappingMimetypeConverter.$$$reportNull$$$0(0);
            }
            if (injectionHost == null) {
                RequestMappingMimetypeConverter.$$$reportNull$$$0(1);
            }
            if ((element = UastContextKt.toUElement((PsiElement)injectionHost)) != null && element.getUastParent() instanceof UPolyadicExpression) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    RequestMappingMimetypeConverter.$$$reportNull$$$0(2);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PsiReference[] psiReferenceArray = MimeTypeReference.forElement((PsiElement)injectionHost);
            if (psiReferenceArray == null) {
                RequestMappingMimetypeConverter.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectionHost";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/mvc/model/jam/SpringRequestMapping$RequestMappingMimetypeConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/mvc/model/jam/SpringRequestMapping$RequestMappingMimetypeConverter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createReferences";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class MethodMapping
    extends SpringRequestMapping<PsiMethod>
    implements RequestMapping.Method {
        private static final SemKey<MethodMapping> JAM_KEY = METHOD_JAM_KEY.subKey("SpringMethodMapping", new SemKey[0]);
        static final JamMethodMeta<MethodMapping> META = new JamMethodMeta(null, MethodMapping.class, JAM_KEY).addAnnotation(REQUEST_MAPPING_ANNO_META).addChildrenQuery(MODEL_ATTRIBUTE_PARAMETERS_QUERY).addChildrenQuery(PATH_VARIABLE_PARAMETERS_QUERY).addPomTargetProducer((methodMapping, pomTargetConsumer) -> {
            for (PsiTarget target : methodMapping.getPomTargets()) {
                pomTargetConsumer.consume((Object)target);
            }
        });

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_PARAMETERS_QUERY.findChildren(PsiElementRef.real((PsiElement)((PsiMethod)this.getPsiElement())));
        }

        @Override
        public List<MVCPathVariable> getPathVariables() {
            return PATH_VARIABLE_PARAMETERS_QUERY.findChildren(PsiElementRef.real((PsiElement)((PsiMethod)this.getPsiElement())));
        }

        @Override
        public RequestMethod @NotNull [] getMethods() {
            RequestMethod[] requestMethodArray = RequestMappingUtil.getAllRequestMethods(this);
            if (requestMethodArray == null) {
                MethodMapping.$$$reportNull$$$0(0);
            }
            return requestMethodArray;
        }

        @Override
        public RequestMethod[] getLocalMethods() {
            return super.getMethods();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/mvc/model/jam/SpringRequestMapping$MethodMapping", "getMethods"));
        }
    }

    public static abstract class ClassMapping
    extends SpringRequestMapping<PsiClass> {
        private static final SemKey<ClassMapping> JAM_KEY = CLASS_JAM_KEY.subKey("SpringClassMapping", new SemKey[0]);
        static final JamClassMeta<ClassMapping> META = new JamClassMeta(null, ClassMapping.class, JAM_KEY).addAnnotation(REQUEST_MAPPING_ANNO_META).addChildrenQuery(MODEL_ATTRIBUTE_METHODS_QUERY).addPomTargetProducer((classMapping, pomTargetConsumer) -> {
            for (PsiTarget target : classMapping.getPomTargets()) {
                pomTargetConsumer.consume((Object)target);
            }
        });

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_METHODS_QUERY.findChildren(PsiElementRef.real((PsiElement)((PsiClass)this.getPsiElement())));
        }
    }
}

