/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.SpringMvcUrlResolver;
import com.intellij.spring.mvc.model.SpringMvcUrlTargetInfo;
import com.intellij.spring.mvc.model.SpringMvcUrlUtils;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Spring MVC", icon="com.intellij.spring.SpringApiIcons.RequestMapping")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/mvc/model/SpringMvcUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "modules", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/module/Module;", "getModules", "()Lkotlin/sequences/Sequence;", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.spring.mvc.impl"})
public final class SpringMvcUrlResolver
extends HttpUrlResolver {
    private final Project project;

    private final Sequence<Module> getModules() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(project).modules");
        return ArraysKt.asSequence((Object[])objectArray);
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap(this.getModules(), (Function1)((Function1)new Function1<Module, Sequence<? extends SpringMvcUrlTargetInfo>>(this, request){
            final /* synthetic */ SpringMvcUrlResolver this$0;
            final /* synthetic */ UrlResolveRequest $request;

            @NotNull
            public final Sequence<SpringMvcUrlTargetInfo> invoke(@NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(this.$request.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends SpringMvcUrlTargetInfo>>(this, module){
                    final /* synthetic */ resolve.1 this$0;
                    final /* synthetic */ Module $module;

                    @NotNull
                    public final Sequence<SpringMvcUrlTargetInfo> invoke(@NotNull UrlPath path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        Collection<UrlMappingElement> collection = SpringMvcUtils.getMatchingUrlMappings(this.$module, path);
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"SpringMvcUtils.getMatchi\u2026UrlMappings(module, path)");
                        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<UrlMappingElement, SpringMvcUrlTargetInfo>(this){
                            final /* synthetic */ resolve.1 this$0;

                            @NotNull
                            public final SpringMvcUrlTargetInfo invoke(@NotNull UrlMappingElement resolved) {
                                Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
                                return new SpringMvcUrlTargetInfo(this.this$0.this$0.this$0.getSupportedSchemes(), resolved, SpringMvcUrlUtils.getAuthoritiesByModule(this.this$0.$module));
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$module = module;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = springMvcUrlResolver;
                this.$request = urlResolveRequest;
                super(1);
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap(this.getModules(), (Function1)((Function1)new Function1<Module, Sequence<? extends SpringMvcUrlTargetInfo>>(this){
            final /* synthetic */ SpringMvcUrlResolver this$0;

            @NotNull
            public final Sequence<SpringMvcUrlTargetInfo> invoke(@NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                List<UrlMappingElement> list = SpringMvcUtils.getUrlMappingsWithoutSpringModel(module);
                Intrinsics.checkNotNullExpressionValue(list, (String)"SpringMvcUtils.getUrlMap\u2026ithoutSpringModel(module)");
                return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<UrlMappingElement, SpringMvcUrlTargetInfo>(this, module){
                    final /* synthetic */ getVariants.1 this$0;
                    final /* synthetic */ Module $module;

                    @NotNull
                    public final SpringMvcUrlTargetInfo invoke(UrlMappingElement urlPath) {
                        List list = this.this$0.this$0.getSupportedSchemes();
                        UrlMappingElement urlMappingElement = urlPath;
                        Intrinsics.checkNotNullExpressionValue((Object)urlMappingElement, (String)"urlPath");
                        return new SpringMvcUrlTargetInfo(list, urlMappingElement, SpringMvcUrlUtils.getAuthoritiesByModule(this.$module));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$module = module;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = springMvcUrlResolver;
                super(1);
            }
        })));
    }

    public SpringMvcUrlResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/spring/mvc/model/SpringMvcUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.mvc.impl"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SpringLibraryUtil.hasSpringLibrary((Project)project) ? (UrlResolver)new SpringMvcUrlResolver(project) : null;
        }
    }
}

