/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.webSockets.endpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.functional.SpringFunctionalRoutingUrlMapping;
import com.intellij.spring.mvc.functional.webSockets.SpringReactiveWebSocketsUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringReactiveWebSocketFramework
implements EndpointsProvider<SpringBeanPointer<?>, SpringFunctionalRoutingUrlMapping> {
    private final FrameworkPresentation myPresentation = new FrameworkPresentation("Spring-Reactive-WebSocket", "Spring Reactive WebSockets", SpringApiIcons.SpringWeb);

    SpringReactiveWebSocketFramework() {
    }

    @NotNull
    public EndpointType getEndpointType() {
        EndpointType endpointType = EndpointTypes.WEBSOCKET_SERVER_TYPE;
        if (endpointType == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(0);
        }
        return endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        FrameworkPresentation frameworkPresentation = this.myPresentation;
        if (frameworkPresentation == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(1);
        }
        return frameworkPresentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(2);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)project) || !JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.web.reactive.HandlerMapping")) {
            EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
            if (status == null) {
                SpringReactiveWebSocketFramework.$$$reportNull$$$0(3);
            }
            return status;
        }
        if (SpringCommonUtils.hasSpringFacets((Project)project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.HAS_ENDPOINTS;
            if (status == null) {
                SpringReactiveWebSocketFramework.$$$reportNull$$$0(4);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.AVAILABLE;
        if (status == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(5);
        }
        return status;
    }

    @NotNull
    public Iterable<SpringBeanPointer<?>> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        if (project == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(7);
        }
        if (!(filter instanceof ModuleEndpointsFilter)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringReactiveWebSocketFramework.$$$reportNull$$$0(8);
            }
            return list;
        }
        ModuleEndpointsFilter moduleFilter = (ModuleEndpointsFilter)filter;
        Module module = moduleFilter.getModule();
        if (!JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.springframework.web.reactive.HandlerMapping")) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringReactiveWebSocketFramework.$$$reportNull$$$0(9);
            }
            return list;
        }
        Set<SpringBeanPointer<?>> allControllers = SpringReactiveWebSocketsUtil.getReactiveHandlerMapping(module);
        Iterable iterable = moduleFilter.filterByScope(allControllers, SpringBeanPointer::getContainingFile);
        if (iterable == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(10);
        }
        return iterable;
    }

    @NotNull
    public Iterable<SpringFunctionalRoutingUrlMapping> getEndpoints(@NotNull SpringBeanPointer<?> reactiveWebSocketMapping) {
        Module module;
        if (reactiveWebSocketMapping == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(11);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)reactiveWebSocketMapping.getContainingFile())) == null) {
            List<SpringFunctionalRoutingUrlMapping> list = Collections.emptyList();
            if (list == null) {
                SpringReactiveWebSocketFramework.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<SpringFunctionalRoutingUrlMapping> endpoints = new ArrayList<SpringFunctionalRoutingUrlMapping>();
        SpringReactiveWebSocketsUtil.processReactiveHandlerMappingBean((Processor<SpringFunctionalRoutingUrlMapping>)new CommonProcessors.CollectProcessor(endpoints), module, reactiveWebSocketMapping);
        ArrayList<SpringFunctionalRoutingUrlMapping> arrayList = endpoints;
        if (arrayList == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SpringBeanPointer<?> reactiveWebSocketMapping, @NotNull SpringFunctionalRoutingUrlMapping endpoint) {
        if (reactiveWebSocketMapping == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(14);
        }
        if (endpoint == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(15);
        }
        return new PresentationData(endpoint.getPresentation(), reactiveWebSocketMapping.getName(), AllIcons.Webreferences.WebSocket, null);
    }

    @Nullable
    public Object getEndpointData(@NotNull SpringBeanPointer<?> reactiveWebSocketMapping, @NotNull SpringFunctionalRoutingUrlMapping endpoint, @NotNull String dataId) {
        if (reactiveWebSocketMapping == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(16);
        }
        if (endpoint == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(17);
        }
        if (dataId == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(18);
        }
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.DOCUMENTATION_ELEMENT).thenGet(() -> {
            PsiElement documentationPsiElement = endpoint.getDocumentationPsiElement();
            if (documentationPsiElement == null) {
                documentationPsiElement = reactiveWebSocketMapping.getPsiElement();
            }
            return documentationPsiElement;
        }), (PsiElement)endpoint.getNavigationTarget());
    }

    public boolean isValidEndpoint(@NotNull SpringBeanPointer<?> reactiveWebSocketMapping, @NotNull SpringFunctionalRoutingUrlMapping endpoint) {
        PsiElement element;
        if (reactiveWebSocketMapping == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(19);
        }
        if (endpoint == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(20);
        }
        return (element = endpoint.getNavigationTarget()) != null && element.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(21);
        }
        ModificationTracker modificationTracker = SpringModificationTrackersManager.getInstance((Project)project).getEndpointsModificationTracker();
        if (modificationTracker == null) {
            SpringReactiveWebSocketFramework.$$$reportNull$$$0(22);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/functional/webSockets/endpoints/SpringReactiveWebSocketFramework";
                break;
            }
            case 2: 
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reactiveWebSocketMapping";
                break;
            }
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/functional/webSockets/endpoints/SpringReactiveWebSocketFramework";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointGroups";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointGroups";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEndpoints";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

