/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.webClient.functional;

import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.mvc.functional.webClient.WebClientConstants;
import com.intellij.spring.mvc.functional.webClient.WebClientModel;
import com.intellij.spring.mvc.functional.webClient.WebClientUtils;
import com.intellij.spring.mvc.functional.webClient.functional.FunctionalWebClientPatterns;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\rH\u0014J\b\u0010\u0015\u001a\u00020\rH\u0014J\b\u0010\u0016\u001a\u00020\u0010H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/spring/mvc/functional/webClient/functional/FunctionalWebClientModel;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientModel;", "()V", "getApiClasses", "", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/cache/ScopedCacheValueHolder;", "getApiMethods", "Lcom/intellij/psi/PsiMethod;", "project", "Lcom/intellij/openapi/project/Project;", "getHttpMethodPattern", "Lcom/intellij/patterns/uast/UCallExpressionPattern;", "getHttpMethodsPattern", "getPackageBlackList", "", "getUrlApiMethods", "module", "Lcom/intellij/openapi/module/Module;", "getWebClientBuilderUrlPattern", "getWebClientCreatePattern", "getWebClientPackage", "intellij.spring.mvc.impl"})
public final class FunctionalWebClientModel
extends WebClientModel {
    @NotNull
    public static final FunctionalWebClientModel INSTANCE;

    @Override
    @NotNull
    protected List<PsiMethod> getUrlApiMethods(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        return WebClientUtils.INSTANCE.getFunctionalClientUrlApiMethods(project);
    }

    @Override
    @NotNull
    public List<PsiClass> getApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return WebClientUtils.INSTANCE.getFunctionalApiClasses(query);
    }

    @Override
    @NotNull
    public List<PsiMethod> getApiMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return WebClientUtils.INSTANCE.getFunctionalClientUrlApiMethods(project);
    }

    @Override
    @NotNull
    protected List<String> getPackageBlackList() {
        return WebClientConstants.INSTANCE.getPACKAGE_SEARCH_BLACK_LIST();
    }

    @Override
    @NotNull
    protected String getWebClientPackage() {
        return "org.springframework.web.reactive.function.client";
    }

    @Override
    @NotNull
    protected UCallExpressionPattern getWebClientCreatePattern() {
        return FunctionalWebClientPatterns.INSTANCE.getWEB_CLIENT_CREATE_PATTERN();
    }

    @Override
    @NotNull
    protected UCallExpressionPattern getWebClientBuilderUrlPattern() {
        return FunctionalWebClientPatterns.INSTANCE.getWEB_CLIENT_BUILDER_BASE_URL_PATTERN();
    }

    @Override
    @NotNull
    protected UCallExpressionPattern getHttpMethodsPattern() {
        return FunctionalWebClientPatterns.INSTANCE.getHTTP_METHODS_PATTERN();
    }

    @Override
    @NotNull
    protected UCallExpressionPattern getHttpMethodPattern() {
        return FunctionalWebClientPatterns.INSTANCE.getHTTP_METHOD_PATTERN();
    }

    private FunctionalWebClientModel() {
    }

    static {
        FunctionalWebClientModel functionalWebClientModel;
        INSTANCE = functionalWebClientModel = new FunctionalWebClientModel();
    }
}

