/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.webClient;

import com.intellij.jam.JavaLibraryUtils;
import com.intellij.microservices.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.mvc.functional.webClient.WebClientUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/spring/mvc/functional/webClient/WebClientUtils;", "", "()V", "findApiClasses", "", "Lcom/intellij/psi/PsiClass;", "project", "Lcom/intellij/openapi/project/Project;", "webClientSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "clientApiSpec", "", "findUrlMethods", "Lcom/intellij/psi/PsiMethod;", "apiSearchScope", "specClassName", "getFunctionalApiClasses", "query", "Lcom/intellij/microservices/cache/ScopedCacheValueHolder;", "getFunctionalClientUrlApiMethods", "getWebTestClientApiClasses", "getWebTestClientUrlApiMethods", "isFunctionalWebClientAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "isWebTestClientAvailable", "intellij.spring.mvc.impl"})
public final class WebClientUtils {
    @NotNull
    public static final WebClientUtils INSTANCE;

    @JvmStatic
    public static final boolean isFunctionalWebClientAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.web.reactive.function.client.WebClient");
    }

    @JvmStatic
    public static final boolean isFunctionalWebClientAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.client.WebClient");
    }

    @JvmStatic
    public static final boolean isWebTestClientAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"org.springframework.test.web.reactive.server.WebTestClient");
    }

    @JvmStatic
    public static final boolean isWebTestClientAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.springframework.test.web.reactive.server.WebTestClient");
    }

    @NotNull
    public final List<PsiMethod> getFunctionalClientUrlApiMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, new CachedValueProvider(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<List<PsiMethod>> compute() {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
                List methods = WebClientUtils.access$findUrlMethods(WebClientUtils.INSTANCE, this.$project, globalSearchScope, "org.springframework.web.reactive.function.client.WebClient.UriSpec");
                return CachedValueProvider.Result.createSingleDependency((Object)methods, (Object)ProjectRootManager.getInstance((Project)this.$project));
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026Instance(project))\n    })");
        return (List)object;
    }

    @NotNull
    public final List<PsiClass> getFunctionalApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(new CachedValueProvider(query){
            final /* synthetic */ ScopedCacheValueHolder $query;

            @Nullable
            public final CachedValueProvider.Result<List<PsiClass>> compute() {
                List classes = WebClientUtils.access$findApiClasses(WebClientUtils.INSTANCE, this.$query.getProject(), this.$query.getApiSearchScope(), "org.springframework.web.reactive.function.client.WebClient.UriSpec");
                return CachedValueProvider.Result.createSingleDependency((Object)classes, (Object)ProjectRootManager.getInstance((Project)this.$query.getProject()));
            }
            {
                this.$query = scopedCacheValueHolder;
            }
        });
    }

    @NotNull
    public final List<PsiMethod> getWebTestClientUrlApiMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, new CachedValueProvider(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<List<PsiMethod>> compute() {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
                List methods = WebClientUtils.access$findUrlMethods(WebClientUtils.INSTANCE, this.$project, globalSearchScope, "org.springframework.test.web.reactive.server.WebTestClient.UriSpec");
                return CachedValueProvider.Result.createSingleDependency((Object)methods, (Object)ProjectRootManager.getInstance((Project)this.$project));
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026Instance(project))\n    })");
        return (List)object;
    }

    @NotNull
    public final List<PsiClass> getWebTestClientApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(new CachedValueProvider(query){
            final /* synthetic */ ScopedCacheValueHolder $query;

            @Nullable
            public final CachedValueProvider.Result<List<PsiClass>> compute() {
                List classes = WebClientUtils.access$findApiClasses(WebClientUtils.INSTANCE, this.$query.getProject(), this.$query.getApiSearchScope(), "org.springframework.test.web.reactive.server.WebTestClient.UriSpec");
                return CachedValueProvider.Result.createSingleDependency((Object)classes, (Object)ProjectRootManager.getInstance((Project)this.$query.getProject()));
            }
            {
                this.$query = scopedCacheValueHolder;
            }
        });
    }

    private final List<PsiClass> findApiClasses(Project project, GlobalSearchScope webClientSearchScope, String clientApiSpec) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClassArray = javaPsiFacade.findClasses(clientApiSpec, webClientSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"javaPsiFacade.findClasse\u2026ec, webClientSearchScope)");
        return CollectionsKt.mutableListOf((Object[])Arrays.copyOf(psiClassArray, psiClassArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiMethod> findUrlMethods(Project project, GlobalSearchScope apiSearchScope, String specClassName) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Function1 stringReceiverMethod2 = findUrlMethods.stringReceiverMethod.1.INSTANCE;
        boolean bl = false;
        List methods = new ArrayList();
        for (PsiClass httpUrlClass : javaPsiFacade.findClasses(specClassName, apiSearchScope)) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullExpressionValue((Object)httpUrlClass.findMethodsByName("uri", true), (String)"httpUrlClass.findMethods\u2026ts.URI_SPEC_METHOD, true)");
            List list = methods;
            boolean $i$f$filter = false;
            void var13_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)stringReceiverMethod2.invoke((Object)element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            list.addAll(list2);
        }
        return methods;
    }

    private WebClientUtils() {
    }

    static {
        WebClientUtils webClientUtils;
        INSTANCE = webClientUtils = new WebClientUtils();
    }

    public static final /* synthetic */ List access$findUrlMethods(WebClientUtils $this, Project project, GlobalSearchScope apiSearchScope, String specClassName) {
        return $this.findUrlMethods(project, apiSearchScope, specClassName);
    }

    public static final /* synthetic */ List access$findApiClasses(WebClientUtils $this, Project project, GlobalSearchScope webClientSearchScope, String clientApiSpec) {
        return $this.findApiClasses(project, webClientSearchScope, clientApiSpec);
    }
}

