/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.webClient;

import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import com.intellij.uast.UastModificationTracker;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/spring/mvc/functional/webClient/WebClientFramework;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointData", "", "group", "endpoint", "dataId", "", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "isValidEndpoint", "", "intellij.spring.mvc.impl"})
public abstract class WebClientFramework
implements EndpointsProvider<WebClientHolder, WebClientUrl> {
    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_CLIENT_TYPE;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull WebClientHolder group, @NotNull WebClientUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return (ItemPresentation)new HttpMethodPresentation(endpoint.getUriPresentation(), endpoint.getHttpMethod(), group.getName(), SpringApiIcons.SpringWeb, null, 16, null);
    }

    @Nullable
    public Object getEndpointData(@NotNull WebClientHolder group, @NotNull WebClientUrl endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        ValueKey.BeforeIf beforeIf = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.DOCUMENTATION_ELEMENT).thenGet(new Supplier(endpoint){
            final /* synthetic */ WebClientUrl $endpoint;

            public final PsiElement get() {
                UElement parent;
                UElement uElement;
                UElement uElement2 = uElement = UastContextKt.toUElement((PsiElement)this.$endpoint.getPsiElement());
                UElement uElement3 = parent = uElement2 != null ? UastUtils.getParentOfType((UElement)uElement2, (boolean)true, UMethod.class, (Class[])new Class[]{UClass.class}) : null;
                return uElement3 != null ? ((UDeclaration)uElement3).getSourcePsi() : null;
            }
            {
                this.$endpoint = webClientUrl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)beforeIf, (String)"ValueKey.match(dataId)\n \u2026parent?.sourcePsi\n      }");
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)beforeIf, (PsiElement)endpoint.getPsiElement());
    }

    public boolean isValidEndpoint(@NotNull WebClientHolder group, @NotNull WebClientUrl endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }
}

