/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.utils;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.functional.utils.FunctionalMvcProcessingContext;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalPatterns;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalSearchers;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UastUtils;

public final class SpringWebfluxKotlinDslUtil {
    public static boolean processKotlinDsl(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        PsiClass requestPredicatesClass;
        if (processor == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(1);
        }
        if ((requestPredicatesClass = SpringWebfluxKotlinDslUtil.findRequestPredicatesDslClass(context.module)) == null) {
            return true;
        }
        return SpringMvcFunctionalUtil.processRouterPredicates(processor, context, requestPredicatesClass, SpringWebfluxKotlinDslUtil.getKotlinDslNestCallExpressions(context));
    }

    @NotNull
    public static Set<UCallExpression> getKotlinDslNestCallExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(2);
        }
        HashSet<UCallExpression> nestDefinitions = new HashSet<UCallExpression>();
        for (PsiMethod nestMethod : SpringMvcFunctionalSearchers.findRouterFunctionDslNestMethods(context.module)) {
            for (UCallExpression uCallExpression : SpringMvcFunctionalSearchers.findMethodCallsWithSearchService(nestMethod, context.searchScope)) {
                UCallExpression callExpression;
                ULambdaExpression uLambdaExpression = (ULambdaExpression)UastUtils.getParentOfType((UElement)uCallExpression, ULambdaExpression.class);
                if (uLambdaExpression == null || (callExpression = (UCallExpression)UastUtils.getParentOfType((UElement)uCallExpression, UCallExpression.class)) == null || !SpringMvcFunctionalPatterns.ROUTER_DSL_METHOD_PATTERN.accepts((Object)callExpression)) continue;
                nestDefinitions.add(uCallExpression);
            }
        }
        HashSet<UCallExpression> hashSet = nestDefinitions;
        if (hashSet == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static PsiClass findRequestPredicatesDslClass(@Nullable Module module) {
        return module == null ? null : SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.server.RouterFunctionDsl");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/functional/utils/SpringWebfluxKotlinDslUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/functional/utils/SpringWebfluxKotlinDslUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinDslNestCallExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processKotlinDsl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKotlinDslNestCallExpressions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

