/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.utils;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.mvc.functional.SpringFunctionalRoutingUrlMapping;
import com.intellij.spring.mvc.functional.references.WebfluxReferenceContributor;
import com.intellij.spring.mvc.functional.utils.FunctionalMvcProcessingContext;
import com.intellij.spring.mvc.functional.utils.SpringFunctionalRoutingUastUtil;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalPatterns;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalRequestPredicateMethods;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalSearchers;
import com.intellij.spring.mvc.functional.utils.SpringWebfluxKotlinDslUtil;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class SpringMvcFunctionalUtil {
    public static Set<SpringBeanPointer<?>> getRouterFunctions(@NotNull Module module) {
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(0);
        }
        return SpringMvcFunctionalUtil.getRouterFunctions(module, SpringManager.getInstance((Project)module.getProject()).getAllModels(module));
    }

    private static Set<SpringBeanPointer<?>> getRouterFunctions(@NotNull Module module, @NotNull Collection<SpringModel> models) {
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(1);
        }
        if (models == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(2);
        }
        return SpringMvcFunctionalUtil.getRouterFunctionBeans(module, models, "org.springframework.web.servlet.function.RouterFunction", "org.springframework.web.reactive.function.server.RouterFunction");
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> getRouterFunctionBeans(@NotNull Module module, @NotNull Collection<SpringModel> models, String ... routerFunctionClasses) {
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(3);
        }
        if (models == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(4);
        }
        HashSet pointers = new HashSet();
        for (String routerFunctionClass : routerFunctionClasses) {
            PsiClass routerFunction = SpringCommonUtils.findLibraryClass((Module)module, (String)routerFunctionClass);
            if (routerFunction == null) continue;
            for (SpringModel model : models) {
                pointers.addAll(SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)routerFunction).withInheritors()));
            }
        }
        HashSet hashSet = pointers;
        if (hashSet == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public static boolean processRouterFunctionUrlMappingsWithoutSpringModel(@NotNull Processor<UrlMappingElement> requestMappings, @NotNull Module module) {
        if (requestMappings == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(6);
        }
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(7);
        }
        if (!SpringMvcFunctionalUtil.processRouterFunctionalUrlMappingsClass(requestMappings, module, "org.springframework.web.servlet.function.RequestPredicates", false)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterFunctionalUrlMappingsClass(requestMappings, module, "org.springframework.web.reactive.function.server.RequestPredicates", true);
    }

    private static boolean processRouterFunctionalUrlMappingsClass(Processor<UrlMappingElement> requestMappings, @NotNull Module module, @NotNull String requestPredicates, boolean isReactive) {
        PsiClass requestPredicatesClass;
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(8);
        }
        if (requestPredicates == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(9);
        }
        if ((requestPredicatesClass = SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, requestPredicates)) == null) {
            return true;
        }
        FunctionalMvcProcessingContext processingContext = FunctionalMvcProcessingContext.create(module).reactive(isReactive).withScope((SearchScope)GlobalSearchScope.moduleScope((Module)module));
        if (!SpringMvcFunctionalUtil.processConfigurationClassRouterPredicates(requestMappings, processingContext)) {
            return false;
        }
        return SpringWebfluxKotlinDslUtil.processKotlinDsl(requestMappings, processingContext);
    }

    public static boolean processRouterFunctionUrlMappings(@NotNull Processor<UrlMappingElement> requestMappings, @NotNull Module module, @NotNull Collection<SpringModel> models) {
        if (requestMappings == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(10);
        }
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(11);
        }
        if (models == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(12);
        }
        if (!SpringMvcFunctionalUtil.processRouterFunctionUrlMappingsBeans(requestMappings, module, models, "org.springframework.web.reactive.function.server.RequestPredicates", true)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterFunctionUrlMappingsBeans(requestMappings, module, models, "org.springframework.web.servlet.function.RequestPredicates", false);
    }

    private static boolean processRouterFunctionUrlMappingsBeans(@NotNull Processor<UrlMappingElement> requestMappings, @NotNull Module module, @NotNull Collection<SpringModel> models, @NotNull String requestPredicates, boolean isReactive) {
        PsiClass requestPredicatesClass;
        if (requestMappings == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(13);
        }
        if (module == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(14);
        }
        if (models == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(15);
        }
        if (requestPredicates == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(16);
        }
        if ((requestPredicatesClass = SpringMvcFunctionalSearchers.findRequestPredicatesClass(module, requestPredicates)) == null) {
            return true;
        }
        Set<SpringBeanPointer<?>> routerFunctions = SpringMvcFunctionalUtil.getRouterFunctionBeans(module, models, isReactive ? "org.springframework.web.reactive.function.server.RouterFunction" : "org.springframework.web.servlet.function.RouterFunction");
        for (SpringBeanPointer<?> routerFunction : routerFunctions) {
            CommonSpringBean bean = routerFunction.getSpringBean();
            PsiElement definitionScope = bean.getIdentifyingPsiElement();
            if (definitionScope == null) continue;
            FunctionalMvcProcessingContext processingContext = FunctionalMvcProcessingContext.create(module).reactive(isReactive).withControllerDefinitionScope(definitionScope).withScope((SearchScope)new LocalSearchScope(definitionScope));
            if (!SpringMvcFunctionalUtil.processConfigurationClass(requestMappings, definitionScope, processingContext)) {
                return false;
            }
            if (SpringWebfluxKotlinDslUtil.processKotlinDsl(requestMappings, processingContext)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasRouterInvocationsInScope(FunctionalMvcProcessingContext context) {
        if (SpringMvcFunctionalSearchers.findMethodCalls(SpringMvcFunctionalSearchers.findRouterFunctionsNestMethod(context.module), context.searchScope).size() > 0) {
            return true;
        }
        if (SpringMvcFunctionalSearchers.findMethodCalls(SpringMvcFunctionalSearchers.findReactiveRouterFunctionsNestMethod(context.module), context.searchScope).size() > 0) {
            return true;
        }
        if (SpringMvcFunctionalSearchers.findMethodCalls(SpringMvcFunctionalSearchers.findReactiveRouterFunctionsRouteMethod(context.module), context.searchScope).size() > 0) {
            return true;
        }
        return SpringMvcFunctionalSearchers.findMethodCalls(SpringMvcFunctionalSearchers.findRouterFunctionsRouteMethod(context.module), context.searchScope).size() > 0;
    }

    private static boolean processConfigurationClass(@NotNull Processor<UrlMappingElement> processor, @NotNull PsiElement definitionScope, @NotNull FunctionalMvcProcessingContext context) {
        Boolean preventingRecursion;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(17);
        }
        if (definitionScope == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(19);
        }
        return (preventingRecursion = (Boolean)RecursionManager.doPreventingRecursion((Object)definitionScope, (boolean)true, () -> {
            if (SpringMvcFunctionalUtil.hasRouterInvocationsInScope(context)) {
                return SpringMvcFunctionalUtil.processConfigurationClassRouterPredicates(processor, context);
            }
            for (PsiElement extendedElementScope : SpringMvcFunctionalSearchers.getExtendedDefinitionScope(definitionScope)) {
                if (SpringMvcFunctionalUtil.processConfigurationClass(processor, extendedElementScope, context.getCopyWithScope(new LocalSearchScope(extendedElementScope)))) continue;
                return false;
            }
            return true;
        })) == null || preventingRecursion != false;
    }

    private static boolean processConfigurationClassRouterPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(20);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(21);
        }
        if (!SpringMvcFunctionalUtil.processRouterPredicates(processor, context)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterFunctionsBuilderPredicates(processor, context);
    }

    private static boolean processRouterPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        PsiClass requestPredicatesClass;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(22);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(23);
        }
        if ((requestPredicatesClass = SpringMvcFunctionalSearchers.findRequestPredicatesClass(context.module, context.reactive)) == null) {
            return true;
        }
        return SpringMvcFunctionalUtil.processRouterPredicates(processor, context, requestPredicatesClass, SpringMvcFunctionalUtil.filterNestedExpressions(SpringMvcFunctionalSearchers.findRouterFunctionsNestExpressions(context)));
    }

    private static boolean processRouterFunctionsBuilderPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        PsiClass aClass;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(24);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(25);
        }
        if ((aClass = SpringMvcFunctionalSearchers.findRouterFunctionsBuilderClass(context.module, context.reactive)) == null) {
            return true;
        }
        return SpringMvcFunctionalUtil.processRouterPredicates(processor, context, aClass, SpringMvcFunctionalUtil.filterNestedExpressions(SpringMvcFunctionalSearchers.findRouterFunctionsBuilderNestExpressions(context)));
    }

    public static boolean processRouterPredicates(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @Nullable PsiClass requestPredicatesClass, @NotNull Set<UCallExpression> nestDefinitions) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(26);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(27);
        }
        if (nestDefinitions == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(28);
        }
        if (requestPredicatesClass == null) {
            return true;
        }
        return nestDefinitions.size() == 0 ? SpringMvcFunctionalUtil.processRequestPredicatesMethods(processor, context, requestPredicatesClass) : SpringMvcFunctionalUtil.processNestedExpressions(processor, context, nestDefinitions, requestPredicatesClass);
    }

    private static boolean processRequestPredicatesMethods(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(29);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(30);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(31);
        }
        for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
            if (SpringMvcFunctionalUtil.processPredicateMethodsForClass(processor, context, method, requestPredicatesClass, new String[0])) continue;
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterAddMethod(processor, context, requestPredicatesClass);
    }

    private static boolean processRouterAddMethod(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(32);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(33);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(34);
        }
        for (PsiMethod psiMethod : requestPredicatesClass.findMethodsByName("add", false)) {
            for (UExpression uExpression : SpringCommonUtils.findParameterExpressionInMethodCalls((PsiMethod)psiMethod, (int)0, (SearchScope)context.searchScope)) {
                PsiElement resolveAddExpression = SpringMvcFunctionalUtil.resolveAddExpression(uExpression);
                if (resolveAddExpression == null || SpringMvcFunctionalUtil.processConfigurationClassRouterPredicates(processor, context.getCopyWithScope(new LocalSearchScope(resolveAddExpression)))) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static PsiElement resolveAddExpression(UExpression uExpression) {
        if (uExpression instanceof UReferenceExpression) {
            UReferenceExpression referenceExpression = (UReferenceExpression)uExpression;
            UElement uElement = UResolvableKt.resolveToUElement((UResolvable)referenceExpression);
            if (uElement instanceof UMethod) {
                return uElement.getSourcePsi();
            }
        } else if (uExpression instanceof UCallExpression) {
            return ((UCallExpression)uExpression).resolve();
        }
        return null;
    }

    private static Set<UCallExpression> filterNestedExpressions(@NotNull Set<UCallExpression> nestDefinitions) {
        if (nestDefinitions == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(35);
        }
        return nestDefinitions.stream().filter(expression -> !SpringMvcFunctionalUtil.isNestedNestExpression(expression)).collect(Collectors.toSet());
    }

    private static boolean processNestedExpressions(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull Set<UCallExpression> nestDefinitions, @NotNull PsiClass requestPredicatesClass) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(36);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(37);
        }
        if (nestDefinitions == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(38);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(39);
        }
        for (UCallExpression nestCallExpression : nestDefinitions) {
            if (!SpringMvcFunctionalUtil.processNestedMethodCallExpressions(processor, context, requestPredicatesClass, nestCallExpression, new String[0])) {
                return false;
            }
            if (SpringMvcFunctionalUtil.processNestMethodLambdaExpression(processor, context, requestPredicatesClass, nestCallExpression)) continue;
            return false;
        }
        return true;
    }

    private static boolean processNestMethodLambdaExpression(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, @NotNull UCallExpression nestCallExpression) {
        UExpression receiver;
        List arguments;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(40);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(41);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(42);
        }
        if (nestCallExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(43);
        }
        if ((arguments = nestCallExpression.getValueArguments()).size() == 1 && (receiver = nestCallExpression.getReceiver()) != null) {
            PsiElement sourcePsi;
            String rootPath = SpringMvcFunctionalUtil.getParentPathForNestExpression(receiver);
            UExpression expression = (UExpression)arguments.get(0);
            if (expression instanceof ULambdaExpression && (sourcePsi = expression.getSourcePsi()) != null) {
                for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
                    String[] stringArray;
                    FunctionalMvcProcessingContext functionalMvcProcessingContext = context.getCopyWithScope(new LocalSearchScope(sourcePsi));
                    if (rootPath == null) {
                        stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = rootPath;
                    }
                    if (SpringMvcFunctionalUtil.processPredicateMethodsForClass(processor, functionalMvcProcessingContext, method, requestPredicatesClass, stringArray)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static String getParentPathForNestExpression(UExpression receiver) {
        List valueArguments;
        UCallExpression uCallExpression;
        String rootPath = SpringFunctionalRoutingUastUtil.getUExpressionText(receiver);
        if (rootPath == null && (uCallExpression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)receiver.getSourcePsi(), UCallExpression.class)) != null && "path".equals(uCallExpression.getMethodName()) && (valueArguments = uCallExpression.getValueArguments()).size() == 1) {
            return SpringFunctionalRoutingUastUtil.getUExpressionText((UExpression)valueArguments.get(0));
        }
        return rootPath;
    }

    private static boolean processNestedMethodCallExpressions(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, @NotNull UCallExpression nestCallExpression, String ... parentPaths) {
        String rootPath;
        UExpression pathExpression;
        List arguments;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(44);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(45);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(46);
        }
        if (nestCallExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(47);
        }
        if ((arguments = nestCallExpression.getValueArguments()).size() == 2 && (pathExpression = SpringMvcFunctionalSearchers.findPathExpression((UExpression)arguments.get(0), context.module, context.reactive)) != null && StringUtil.isNotEmpty((String)(rootPath = SpringFunctionalRoutingUastUtil.getUExpressionText(pathExpression)))) {
            PsiElement sourcePsi;
            UExpression predicateExpression;
            String[] allParentPaths = (String[])ArrayUtil.append((Object[])parentPaths, (Object)rootPath);
            if (!SpringMvcFunctionalUtil.processCallExpressionsChain(processor, context, requestPredicatesClass, allParentPaths, predicateExpression = (UExpression)arguments.get(1))) {
                return false;
            }
            if (!SpringMvcFunctionalUtil.processExpressionResolvedToMembers(processor, context, requestPredicatesClass, predicateExpression, allParentPaths)) {
                return false;
            }
            if (predicateExpression instanceof ULambdaExpression && (sourcePsi = predicateExpression.getSourcePsi()) != null) {
                for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
                    if (SpringMvcFunctionalUtil.processPredicateMethodsForClass(processor, context.getCopyWithScope(new LocalSearchScope(sourcePsi)), method, requestPredicatesClass, allParentPaths)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processExpressionResolvedToMembers(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, @Nullable UExpression predicateExpression, String ... allParentPaths) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(48);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(49);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(50);
        }
        return !(predicateExpression instanceof UReferenceExpression ? !SpringMvcFunctionalUtil.processResolvedMembers(processor, context, requestPredicatesClass, allParentPaths, ((UReferenceExpression)predicateExpression).resolve()) : predicateExpression instanceof UCallExpression && !SpringMvcFunctionalUtil.processResolvedMembers(processor, context, requestPredicatesClass, allParentPaths, (PsiElement)((UCallExpression)predicateExpression).resolve()));
    }

    private static boolean processResolvedMembers(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, String[] allParentPaths, @Nullable PsiElement resolve2) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(51);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(52);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(53);
        }
        return !(resolve2 instanceof PsiMember) || SpringMvcFunctionalPatterns.ROUTER_CLASSES_PATTERN.accepts((Object)((PsiMember)resolve2).getContainingClass()) || SpringMvcFunctionalUtil.processPredicateMethods(processor, requestPredicatesClass, allParentPaths, context.getCopyWithScope(new LocalSearchScope(resolve2)));
    }

    private static boolean processCallExpressionsChain(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull PsiClass requestPredicatesClass, String[] allParentPaths, UExpression predicateExpression) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(54);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(55);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(56);
        }
        for (UCallExpression nestCallExpression : SpringMvcFunctionalUtil.collectNestCallExpressions(predicateExpression)) {
            LocalSearchScope nestFunctionSearchScope = SpringMvcFunctionalUtil.getNestFunctionSearchScope((UExpression)nestCallExpression);
            if (nestFunctionSearchScope == null || SpringMvcFunctionalUtil.processNestedMethodCallExpressions(processor, context.getCopyWithScope(nestFunctionSearchScope), requestPredicatesClass, nestCallExpression, allParentPaths)) continue;
            return false;
        }
        for (UCallExpression routeCallExpression : SpringMvcFunctionalUtil.collectRouteCallExpressions(predicateExpression)) {
            LocalSearchScope routerFunctionSearchScope = SpringMvcFunctionalUtil.getRouterFunctionSearchScope((UExpression)routeCallExpression);
            if (routerFunctionSearchScope == null || SpringMvcFunctionalUtil.processPredicateMethods(processor, requestPredicatesClass, allParentPaths, context.getCopyWithScope(routerFunctionSearchScope))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<UCallExpression> collectNestCallExpressions(UExpression chain) {
        Collection<UCallExpression> collection = SpringFunctionalRoutingUastUtil.collectCallExpressionsInChain(chain, SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN, SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN);
        if (collection == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(57);
        }
        return collection;
    }

    @NotNull
    private static Collection<UCallExpression> collectRouteCallExpressions(UExpression chain) {
        Collection<UCallExpression> collection = SpringFunctionalRoutingUastUtil.collectCallExpressionsInChain(chain, SpringMvcFunctionalPatterns.ROUTE_METHOD_PATTERN, SpringMvcFunctionalPatterns.AND_ROUTE_METHOD_PATTERN);
        if (collection == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(58);
        }
        return collection;
    }

    private static boolean processPredicateMethods(@NotNull Processor<UrlMappingElement> processor, @NotNull PsiClass requestPredicatesClass, String[] allParentPaths, FunctionalMvcProcessingContext processingContext) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(59);
        }
        if (requestPredicatesClass == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(60);
        }
        for (SpringMvcFunctionalRequestPredicateMethods method : SpringMvcFunctionalRequestPredicateMethods.values()) {
            if (SpringMvcFunctionalUtil.processPredicateMethodsForClass(processor, processingContext, method, requestPredicatesClass, allParentPaths)) continue;
            return false;
        }
        return SpringMvcFunctionalUtil.processRequestPredicateMethods(processor, processingContext, allParentPaths);
    }

    private static boolean isNestExpression(UElement expression) {
        return SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN.accepts((Object)expression);
    }

    private static boolean isNestedNestExpression(UCallExpression expression) {
        UElement parent = UastUtils.getParentOfType((UElement)expression, UCallExpression.class);
        if (parent == null) {
            return false;
        }
        if (SpringMvcFunctionalUtil.isNestExpression(parent)) {
            return true;
        }
        if (parent instanceof UQualifiedReferenceExpression) {
            return SpringMvcFunctionalUtil.isNestExpression((UElement)SpringFunctionalRoutingUastUtil.findFirstCallExpressionInChain((UExpression)((UQualifiedReferenceExpression)parent)));
        }
        return false;
    }

    private static boolean processPredicateMethodsForClass(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, @NotNull SpringMvcFunctionalRequestPredicateMethods method, @Nullable PsiClass requestPredicatesClass, String ... rootPaths) {
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(61);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(62);
        }
        if (method == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(63);
        }
        if (requestPredicatesClass == null) {
            return true;
        }
        for (PsiMethod psiMethod : requestPredicatesClass.findMethodsByName(method.getMethodName(), false)) {
            for (UExpression uExpression : SpringCommonUtils.findParameterExpressionInMethodCalls((PsiMethod)psiMethod, (int)0, (SearchScope)context.searchScope)) {
                String valueIfKnown = SpringCommonUtils.evaluateStringExpression((UExpression)uExpression);
                if (!(valueIfKnown != null ? !SpringMvcFunctionalUtil.processRequestPredicate(processor, context.controllerDefinitionScope, method, valueIfKnown, uExpression.getSourcePsi(), rootPaths) : rootPaths.length > 0 && WebfluxReferenceContributor.methodCallPattern.accepts((Object)uExpression) && !SpringMvcFunctionalUtil.processRequestPredicate(processor, context.controllerDefinitionScope, method, null, uExpression.getSourcePsi(), rootPaths))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processRequestPredicateMethods(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context, String ... rootPath) {
        PsiMethod predicatesMethod;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(64);
        }
        if (context == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(65);
        }
        if (context.searchScope == null) {
            return true;
        }
        PsiMethod psiMethod = predicatesMethod = context.reactive ? SpringMvcFunctionalSearchers.findReactiveRequestPredicatesMethod(context.module) : SpringMvcFunctionalSearchers.findRequestPredicatesMethod(context.module);
        if (predicatesMethod != null) {
            Set uCallExpressions = MethodReferencesSearch.search((PsiMethod)predicatesMethod, (SearchScope)context.searchScope, (boolean)true).findAll().stream().map(reference -> (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)reference.getElement(), UCallExpression.class)).filter(Objects::nonNull).collect(Collectors.toSet());
            for (UCallExpression uCallExpression : uCallExpressions) {
                PsiElement sourcePsi;
                UExpression enumExpression = uCallExpression.getArgumentForParameter(0);
                if (enumExpression == null || (sourcePsi = enumExpression.getSourcePsi()) == null || SpringMvcFunctionalUtil.processRequestPredicate(processor, context.controllerDefinitionScope, SpringMvcFunctionalUtil.getWebfluxPredicateMethodType(enumExpression), null, sourcePsi, rootPath)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processRequestPredicate(@NotNull Processor<UrlMappingElement> processor, @Nullable PsiElement controllerDefinition, @NotNull SpringMvcFunctionalRequestPredicateMethods method, @Nullable String url, @Nullable PsiElement sourcePsi, String ... rootPath) {
        UrlMappingElement mapping;
        if (processor == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(66);
        }
        if (method == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(67);
        }
        return sourcePsi == null || (mapping = SpringMvcFunctionalUtil.createUrlMapping(url, sourcePsi, rootPath, controllerDefinition, method.getType())) == null || processor.process((Object)mapping);
    }

    @Nullable
    private static UrlMappingElement createUrlMapping(@Nullable String path, @NotNull PsiElement definition, String[] rootPaths, @Nullable PsiElement controllerDefinition, RequestMethod ... requestMethods) {
        String url;
        if (definition == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(68);
        }
        if ((url = SpringMvcFunctionalUtil.concatenatePaths(path, rootPaths)) == null) {
            return null;
        }
        UExpression handlerDefinition = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)definition, (Class[])new Class[]{UExpression.class});
        if (handlerDefinition == null) {
            return null;
        }
        return new SpringFunctionalRoutingUrlMapping(url, definition, (PsiMethod)ObjectUtils.tryCast((Object)controllerDefinition, PsiMethod.class), requestMethods);
    }

    @Nullable
    private static String concatenatePaths(@Nullable String path, String ... rootPaths) {
        if (path == null && rootPaths == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String rootPath : rootPaths) {
            sb.append(rootPath);
        }
        if (path != null) {
            if (sb.toString().endsWith("/")) {
                sb.append(StringsKt.removePrefix((String)path, (CharSequence)"/"));
            } else {
                if (!path.startsWith("/")) {
                    sb.append("/");
                }
                sb.append(path);
            }
        }
        return sb.toString();
    }

    @Nullable
    public static String getParentUrlPath(@NotNull PsiElement host) {
        List arguments;
        Module module;
        if (host == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(69);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host)) == null) {
            return null;
        }
        UMethod definedInMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)host, UMethod.class);
        if (definedInMethod == null) {
            return null;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)definedInMethod.getPsi());
        Iterable nestMethodCalls = ContainerUtil.concat((Iterable)SpringCommonUtils.findMethodCallsByPattern((Project)module.getProject(), (String)"nest", (SearchScope)localSearchScope, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN, SpringMvcFunctionalPatterns.NEST_METHOD_IN_BUILDER_PATTERN}), (Iterable)SpringCommonUtils.findMethodCallsByPattern((Project)module.getProject(), (String)"andNest", (SearchScope)localSearchScope, (UCallExpressionPattern[])new UCallExpressionPattern[]{SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN}));
        for (UCallExpression nestCallExpression : nestMethodCalls) {
            arguments = nestCallExpression.getValueArguments();
            if (arguments.size() != 2) continue;
            UExpression reactivePathExpression = SpringMvcFunctionalSearchers.findPathExpression((UExpression)arguments.get(0), module, true);
            if (reactivePathExpression != null) {
                return SpringFunctionalRoutingUastUtil.getUExpressionText(reactivePathExpression);
            }
            UExpression pathExpression = SpringMvcFunctionalSearchers.findPathExpression((UExpression)arguments.get(0), module, false);
            if (pathExpression == null) continue;
            return SpringFunctionalRoutingUastUtil.getUExpressionText(pathExpression);
        }
        for (UCallExpression dslNestCallExpression : SpringWebfluxKotlinDslUtil.getKotlinDslNestCallExpressions(FunctionalMvcProcessingContext.create(module).withScope((SearchScope)localSearchScope))) {
            UExpression receiver;
            arguments = dslNestCallExpression.getValueArguments();
            if (arguments.size() != 1 || (receiver = dslNestCallExpression.getReceiver()) == null) continue;
            return SpringMvcFunctionalUtil.getParentPathForNestExpression(receiver);
        }
        return null;
    }

    @NotNull
    public static SpringMvcFunctionalRequestPredicateMethods getWebfluxPredicateMethodType(@NotNull UExpression enumExpression) {
        String resolvedName;
        if (enumExpression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(70);
        }
        if (enumExpression instanceof UReferenceExpression && (resolvedName = ((UReferenceExpression)enumExpression).getResolvedName()) != null) {
            for (SpringMvcFunctionalRequestPredicateMethods predicateMethods : SpringMvcFunctionalRequestPredicateMethods.values()) {
                if (!resolvedName.equals(predicateMethods.getMethodName())) continue;
                SpringMvcFunctionalRequestPredicateMethods springMvcFunctionalRequestPredicateMethods = predicateMethods;
                if (springMvcFunctionalRequestPredicateMethods == null) {
                    SpringMvcFunctionalUtil.$$$reportNull$$$0(71);
                }
                return springMvcFunctionalRequestPredicateMethods;
            }
        }
        SpringMvcFunctionalRequestPredicateMethods springMvcFunctionalRequestPredicateMethods = SpringMvcFunctionalRequestPredicateMethods.GET;
        if (springMvcFunctionalRequestPredicateMethods == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(72);
        }
        return springMvcFunctionalRequestPredicateMethods;
    }

    @Nullable
    public static LocalSearchScope getRouterFunctionSearchScope(@NotNull UExpression expression) {
        UExpression parameter;
        if (expression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(73);
        }
        if (expression instanceof UCallExpression && (SpringMvcFunctionalPatterns.ROUTE_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.AND_ROUTE_METHOD_PATTERN.accepts((Object)expression)) && (parameter = ((UCallExpression)expression).getArgumentForParameter(0)) != null) {
            PsiElement sourcePsi = parameter.getSourcePsi();
            return sourcePsi == null ? null : new LocalSearchScope(sourcePsi);
        }
        return null;
    }

    @Nullable
    public static LocalSearchScope getNestFunctionSearchScope(@NotNull UExpression expression) {
        PsiElement[] arguments;
        if (expression == null) {
            SpringMvcFunctionalUtil.$$$reportNull$$$0(74);
        }
        if (expression instanceof UCallExpression && (SpringMvcFunctionalPatterns.NEST_METHOD_PATTERN.accepts((Object)expression) || SpringMvcFunctionalPatterns.AND_NEST_METHOD_PATTERN.accepts((Object)expression)) && (arguments = (PsiElement[])((UCallExpression)expression).getValueArguments().stream().map(expression1 -> expression1.getSourcePsi()).filter(Objects::nonNull).toArray(PsiElement[]::new)).length > 0) {
            return new LocalSearchScope(arguments);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 57: 
            case 58: 
            case 71: 
            case 72: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 57: 
            case 58: 
            case 71: 
            case 72: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 5: 
            case 57: 
            case 58: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/functional/utils/SpringMvcFunctionalUtil";
                break;
            }
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMappings";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPredicates";
                break;
            }
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 51: 
            case 54: 
            case 59: 
            case 61: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionScope";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 41: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestDefinitions";
                break;
            }
            case 31: 
            case 34: 
            case 39: 
            case 42: 
            case 46: 
            case 50: 
            case 53: 
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPredicatesClass";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestCallExpression";
                break;
            }
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumExpression";
                break;
            }
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/functional/utils/SpringMvcFunctionalUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRouterFunctionBeans";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNestCallExpressions";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRouteCallExpressions";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebfluxPredicateMethodType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRouterFunctions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRouterFunctionBeans";
                break;
            }
            case 5: 
            case 57: 
            case 58: 
            case 71: 
            case 72: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionUrlMappingsWithoutSpringModel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionalUrlMappingsClass";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionUrlMappings";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionUrlMappingsBeans";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationClassRouterPredicates";
                break;
            }
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processRouterPredicates";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processRouterFunctionsBuilderPredicates";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processRequestPredicatesMethods";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processRouterAddMethod";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "filterNestedExpressions";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processNestedExpressions";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processNestMethodLambdaExpression";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processNestedMethodCallExpressions";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processExpressionResolvedToMembers";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedMembers";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpressionsChain";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processPredicateMethods";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processPredicateMethodsForClass";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "processRequestPredicateMethods";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "processRequestPredicate";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createUrlMapping";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getParentUrlPath";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getWebfluxPredicateMethodType";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getRouterFunctionSearchScope";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getNestFunctionSearchScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 57: 
            case 58: 
            case 71: 
            case 72: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

