/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.freemarker;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalSearchers;
import com.intellij.spring.mvc.thymeleaf.ThymeleafViewResolverFactory;
import com.intellij.spring.mvc.views.CustomTemplateViewResolverFactory;
import com.intellij.spring.mvc.views.ViewResolver;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

public class SpringReactiveTemplateViewResolverFactory
extends CustomTemplateViewResolverFactory {
    private static final String DEFAULT_SUFFIX = ".ftl";
    private static final String DEFAULT_PREFIX = "classpath:/templates/";

    @Override
    public String getCustomResolverClassName() {
        return "org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfigurer";
    }

    @Override
    protected boolean isMine(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            SpringReactiveTemplateViewResolverFactory.$$$reportNull$$$0(0);
        }
        return InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfigurer");
    }

    @Override
    public String getBeanClass() {
        return "org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfigurer";
    }

    @Override
    @NotNull
    public Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        PsiElement scopeElement;
        if (bean != null && (scopeElement = bean.getIdentifyingPsiElement()) != null) {
            Module module;
            Module module2 = module = model.getModule() != null ? model.getModule() : bean.getModule();
            if (module == null) {
                Set<ViewResolver> set = Collections.emptySet();
                if (set == null) {
                    SpringReactiveTemplateViewResolverFactory.$$$reportNull$$$0(1);
                }
                return set;
            }
            PsiMethod psiMethod = SpringMvcFunctionalSearchers.findMethod("setTemplateLoaderPath", SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfigurer"));
            for (UCallExpression uCallExpression : SpringMvcFunctionalSearchers.findMethodCalls(psiMethod, (SearchScope)new LocalSearchScope(scopeElement))) {
                String templateLoaderPath;
                UExpression uExpression = uCallExpression.getArgumentForParameter(0);
                if (uExpression == null || !StringUtil.isNotEmpty((String)(templateLoaderPath = UastUtils.evaluateString((UExpression)uExpression)))) continue;
                Object path = templateLoaderPath.endsWith("/") ? templateLoaderPath : templateLoaderPath + "/";
                Set<ViewResolver> set = Collections.singleton(ThymeleafViewResolverFactory.createURLBasedViewResolver(module, DEFAULT_SUFFIX, (String)path));
                if (set == null) {
                    SpringReactiveTemplateViewResolverFactory.$$$reportNull$$$0(2);
                }
                return set;
            }
            Set<ViewResolver> set = Collections.singleton(ThymeleafViewResolverFactory.createURLBasedViewResolver(module, DEFAULT_SUFFIX, DEFAULT_PREFIX));
            if (set == null) {
                SpringReactiveTemplateViewResolverFactory.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<ViewResolver> set = Collections.emptySet();
        if (set == null) {
            SpringReactiveTemplateViewResolverFactory.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/freemarker/SpringReactiveTemplateViewResolverFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/freemarker/SpringReactiveTemplateViewResolverFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

