/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.freemarker;

import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SpringMvcFtlGlobalVariableProvider
extends FtlGlobalVariableProvider {
    public boolean processGlobalVariables(@NotNull FtlFile file, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Module module;
        if (file == null) {
            SpringMvcFtlGlobalVariableProvider.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            SpringMvcFtlGlobalVariableProvider.$$$reportNull$$$0(1);
        }
        if (state == null) {
            SpringMvcFtlGlobalVariableProvider.$$$reportNull$$$0(2);
        }
        if (place == null) {
            SpringMvcFtlGlobalVariableProvider.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return true;
        }
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(module)) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String nameHintText = nameHint != null ? nameHint.getName(state) : null;
        Processor toFtlVariableProcessor = variable -> {
            String name = variable.getName();
            PsiClass variableClass = PsiTypesUtil.getPsiClass((PsiType)variable.getType());
            if (name != null && variableClass != null && variableClass.getQualifiedName() != null) {
                boolean nameMatch = Comparing.strEqual((String)name, (String)nameHintText);
                if ((nameHintText == null || nameMatch) && !processor.execute((PsiElement)variable, state)) {
                    return false;
                }
                if (nameMatch) {
                    return false;
                }
            }
            return true;
        };
        return SpringMvcUtils.processVariables((PsiElement)file, (Processor<? super PsiVariable>)toFtlVariableProcessor, nameHintText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "place";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/mvc/freemarker/SpringMvcFtlGlobalVariableProvider";
        objectArray[2] = "processGlobalVariables";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

