/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.config.anno;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.WebModelContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.config.ServletFileSet;
import com.intellij.spring.mvc.config.anno.PsiBasedServlet;
import com.intellij.spring.mvc.services.SpringMvcServiceImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;

public class SpringMvcPsiBasedServletWebModelContributor
extends WebModelContributor {
    private static final Function<SpringModel, CommonServlet> SERVLET_CONTEXT_SERVLET_MAPPING = model -> {
        SpringFileSet set = model.getFileSet();
        if (!(set instanceof ServletFileSet)) {
            return null;
        }
        CommonServlet servlet = ((ServletFileSet)set).getServlet();
        if (!(servlet instanceof PsiBasedServlet)) {
            return null;
        }
        return servlet;
    };
    private static final Function<CommonServlet, CommonServletMapping<CommonServlet>> SERVLET_MAPPING_FUNCTION = servlet -> {
        if (!(servlet instanceof CommonServletMapping)) {
            return null;
        }
        return (CommonServletMapping)servlet;
    };

    public List<CommonServlet> getServlets(Module module) {
        if (!SpringCommonUtils.hasSpringFacets((Project)module.getProject())) {
            return Collections.emptyList();
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return Collections.emptyList();
        }
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(module)) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull(SpringMvcServiceImpl.getServletModels(module), SERVLET_CONTEXT_SERVLET_MAPPING);
    }

    public List<CommonServletMapping<CommonServlet>> getServletMappings(Module module) {
        return ContainerUtil.mapNotNull(this.getServlets(module), SERVLET_MAPPING_FUNCTION);
    }
}

