/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.config.anno;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.config.ServletFileSet;
import com.intellij.spring.mvc.config.anno.CodeConfigurationPropertiesParser;
import com.intellij.spring.mvc.config.anno.PsiBasedServlet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationConfigSpringWebModelContributor
implements SpringModelProvider {
    private static final String ABSTRACT_ANNOTATION_INITIALIZER = "org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer";

    public String getName() {
        return this.getClass().getSimpleName();
    }

    @NotNull
    public List<? extends SpringAutodetectedFileSet> getFilesets(@NotNull SpringFacet springFacet) {
        Module module;
        if (springFacet == null) {
            AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)(module = springFacet.getModule()).getProject()) || !SpringMvcLibraryUtil.hasSpringMvcLibrary(module)) {
            List list = Collections.emptyList();
            if (list == null) {
                AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiClass initializerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)ABSTRACT_ANNOTATION_INITIALIZER);
        if (initializerClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList additionalDependencies = new SmartList((Object)PsiModificationTracker.MODIFICATION_COUNT);
        GlobalSearchScope inheritorsScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        Collection initializers = ClassInheritorsSearch.search((PsiClass)initializerClass, (SearchScope)inheritorsScope, (boolean)true).findAll();
        SmartList fileSets = new SmartList();
        ContainerUtil.process((Iterable)initializers, arg_0 -> AnnotationConfigSpringWebModelContributor.lambda$getFilesets$0((List)additionalDependencies, module, springFacet, (List)fileSets, arg_0));
        SmartList smartList = fileSets;
        if (smartList == null) {
            AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static boolean isConfigurationOrComponent(PsiClass psiClass) {
        return SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass) || SpringCommonUtils.isComponentOrMeta((PsiClass)psiClass);
    }

    private static /* synthetic */ boolean lambda$getFilesets$0(List additionalDependencies, Module module, SpringFacet springFacet, List fileSets, PsiClass initializer) {
        additionalDependencies.add(initializer.getContainingFile());
        CodeConfigurationPropertiesParser parser2 = new CodeConfigurationPropertiesParser(initializer);
        String servletName = parser2.getString("getServletName", true);
        if (StringUtil.isEmptyOrSpaces((String)servletName)) {
            return true;
        }
        PsiClass servletClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet");
        PsiClass servletDefinitionElement = initializer;
        PsiElement mappingDefinitionElement = (PsiElement)ArrayUtil.getFirstElement((Object[])initializer.findMethodsByName("getServletMappings", false));
        String[] servletMappings = parser2.getStringArray("getServletMappings", false);
        PsiBasedServlet implicitServlet = new PsiBasedServlet(servletName, servletClass, (PsiElement)servletDefinitionElement, mappingDefinitionElement, servletMappings);
        ServletFileSet initializerServletFileSet = new ServletFileSet("initializer " + initializer.getQualifiedName() + " servlet context", SpringMvcBundle.message("mvc.initializer.context.autodetected", servletName), implicitServlet, springFacet);
        List<PsiClass> servletConfigClasses = parser2.getPsiClasses("getServletConfigClasses", false);
        boolean hasServletContext = !servletConfigClasses.isEmpty();
        for (PsiClass servletConfigClass : servletConfigClasses) {
            if (!AnnotationConfigSpringWebModelContributor.isConfigurationOrComponent(servletConfigClass)) continue;
            ServletFileSet.addInFileset((SpringFileSet)initializerServletFileSet, servletConfigClass.getContainingFile());
        }
        fileSets.add(initializerServletFileSet);
        PsiBasedServlet rootContextImplicitServlet = hasServletContext ? null : implicitServlet;
        ServletFileSet rootContext = new ServletFileSet("initializer " + initializer.getQualifiedName() + " root context", "MVC " + servletName + " initializer root context", rootContextImplicitServlet, springFacet);
        for (PsiClass rootConfigClasses : parser2.getPsiClasses("getRootConfigClasses", false)) {
            if (!AnnotationConfigSpringWebModelContributor.isConfigurationOrComponent(rootConfigClasses)) continue;
            ServletFileSet.addInFileset((SpringFileSet)rootContext, rootConfigClasses.getContainingFile());
        }
        initializerServletFileSet.addDependency((SpringFileSet)rootContext);
        fileSets.add(rootContext);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springFacet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/config/anno/AnnotationConfigSpringWebModelContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/config/anno/AnnotationConfigSpringWebModelContributor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesets";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

